/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.helix.HelixException;
import org.apache.helix.ZNRecord;
import org.apache.helix.api.config.RebalanceConfig;
import org.apache.helix.api.rebalancer.constraint.AbstractRebalanceHardConstraint;
import org.apache.helix.api.rebalancer.constraint.AbstractRebalanceSoftConstraint;
import org.apache.helix.controller.common.PartitionStateMap;
import org.apache.helix.controller.common.ResourcesStateMap;
import org.apache.helix.controller.dataproviders.ResourceControllerDataProvider;
import org.apache.helix.controller.rebalancer.strategy.ConstraintRebalanceStrategy;
import org.apache.helix.model.BuiltInStateModelDefinitions;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.Partition;
import org.apache.helix.model.ResourceConfig;
import org.apache.helix.model.StateModelDefinition;

public class WeightAwareRebalanceUtil {
    private final ClusterConfig _clusterConfig;
    private final Map<String, InstanceConfig> _instanceConfigMap = new HashMap<String, InstanceConfig>();
    private final Map<String, StateModelDefinition> _stateModelDefs = new HashMap<String, StateModelDefinition>();
    private final ResourceControllerDataProvider _dataCache;

    public WeightAwareRebalanceUtil(ClusterConfig clusterConfig, List<InstanceConfig> instanceConfigs) {
        for (InstanceConfig instanceConfig : instanceConfigs) {
            instanceConfig.setInstanceEnabled(true);
            this._instanceConfigMap.put(instanceConfig.getInstanceName(), instanceConfig);
        }
        clusterConfig.setDisabledInstances(Collections.emptyMap());
        this._clusterConfig = clusterConfig;
        this._dataCache = new ResourceControllerDataProvider();
        this._dataCache.setInstanceConfigMap(this._instanceConfigMap);
        this._dataCache.setClusterConfig(this._clusterConfig);
        ArrayList<LiveInstance> liveInstanceList = new ArrayList<LiveInstance>();
        for (String instance : this._instanceConfigMap.keySet()) {
            LiveInstance liveInstance = new LiveInstance(instance);
            liveInstanceList.add(liveInstance);
        }
        this._dataCache.setLiveInstances(liveInstanceList);
    }

    public ResourcesStateMap buildIncrementalRebalanceAssignment(List<ResourceConfig> resourceConfigs, ResourcesStateMap existingAssignment, List<? extends AbstractRebalanceHardConstraint> hardConstraints, List<? extends AbstractRebalanceSoftConstraint> softConstraints) {
        return this.calculateAssignment(resourceConfigs, existingAssignment, RebalanceOption.INCREMENTAL, hardConstraints, softConstraints);
    }

    public ResourcesStateMap buildFullRebalanceAssignment(List<ResourceConfig> resourceConfigs, ResourcesStateMap preferredAssignment, List<? extends AbstractRebalanceHardConstraint> hardConstraints, List<? extends AbstractRebalanceSoftConstraint> softConstraints) {
        return this.calculateAssignment(resourceConfigs, preferredAssignment, RebalanceOption.FULL, hardConstraints, softConstraints);
    }

    private ResourcesStateMap calculateAssignment(List<ResourceConfig> resourceConfigs, ResourcesStateMap existingAssignment, RebalanceOption option, List<? extends AbstractRebalanceHardConstraint> hardConstraints, List<? extends AbstractRebalanceSoftConstraint> softConstraints) {
        for (ResourceConfig resourceConfig : resourceConfigs) {
            RebalanceConfig.RebalanceMode rebalanceMode = resourceConfig.getRebalanceConfig().getRebalanceMode();
            if (!rebalanceMode.equals((Object)RebalanceConfig.RebalanceMode.FULL_AUTO)) continue;
            throw new HelixException("Resources that in FULL_AUTO mode are not supported: " + resourceConfig.getResourceName());
        }
        ConstraintRebalanceStrategy constraintBasedStrategy = new ConstraintRebalanceStrategy(hardConstraints, softConstraints);
        ResourcesStateMap resultAssignment = new ResourcesStateMap();
        for (ResourceConfig resourceConfig : resourceConfigs) {
            HashMap<String, Map<String, String>> preferredMapping = new HashMap<String, Map<String, String>>();
            if (existingAssignment != null) {
                PartitionStateMap partitionStateMap = existingAssignment.getPartitionStateMap(resourceConfig.getResourceName());
                if (option.equals((Object)RebalanceOption.INCREMENTAL) && partitionStateMap != null) {
                    for (Partition partition : partitionStateMap.getStateMap().keySet()) {
                        preferredMapping.put(partition.getPartitionName(), partitionStateMap.getPartitionMap(partition));
                    }
                }
            }
            StateModelDefinition stateModelDefinition = this.getStateModelDef(resourceConfig.getStateModelDefRef());
            constraintBasedStrategy.init(resourceConfig.getResourceName(), new ArrayList<String>(resourceConfig.getPreferenceLists().keySet()), stateModelDefinition.getStateCountMap(this._instanceConfigMap.size(), Integer.parseInt(resourceConfig.getNumReplica())), Integer.MAX_VALUE);
            ArrayList<String> instanceNames = new ArrayList<String>(this._instanceConfigMap.keySet());
            ZNRecord znRecord = constraintBasedStrategy.computePartitionAssignment((List<String>)instanceNames, (List<String>)instanceNames, (Map<String, Map<String, String>>)preferredMapping, this._dataCache);
            Map<String, Map<String, String>> stateMap = znRecord.getMapFields();
            PartitionStateMap newStateMap = new PartitionStateMap(resourceConfig.getResourceName());
            for (String partition : stateMap.keySet()) {
                newStateMap.setState(new Partition(partition), stateMap.get(partition));
            }
            resultAssignment.setState(resourceConfig.getResourceName(), newStateMap);
        }
        return resultAssignment;
    }

    private StateModelDefinition getStateModelDef(String stateModelDefRef) {
        if (this._stateModelDefs.containsKey(stateModelDefRef)) {
            return this._stateModelDefs.get(stateModelDefRef);
        }
        return BuiltInStateModelDefinitions.valueOf(stateModelDefRef).getStateModelDefinition();
    }

    public void registerCustomizedStateModelDef(String stateModelDefRef, StateModelDefinition stateModelDefinition) {
        this._stateModelDefs.put(stateModelDefRef, stateModelDefinition);
    }

    private static enum RebalanceOption {
        INCREMENTAL,
        FULL;

    }
}

