/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.I0Itec.zkclient.DataUpdater;
import org.apache.helix.AccessOption;
import org.apache.helix.BaseDataAccessor;
import org.apache.helix.ConfigAccessor;
import org.apache.helix.HelixAdmin;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixProperty;
import org.apache.helix.PropertyKey;
import org.apache.helix.PropertyPathBuilder;
import org.apache.helix.ZNRecord;
import org.apache.helix.manager.zk.ZKHelixAdmin;
import org.apache.helix.manager.zk.ZKHelixDataAccessor;
import org.apache.helix.manager.zk.ZkBaseDataAccessor;
import org.apache.helix.manager.zk.client.HelixZkClient;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.builder.CustomModeISBuilder;
import org.apache.helix.store.HelixPropertyStore;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.helix.task.JobConfig;
import org.apache.helix.task.JobContext;
import org.apache.helix.task.JobDag;
import org.apache.helix.task.JobQueue;
import org.apache.helix.task.TargetState;
import org.apache.helix.task.TaskExecutionInfo;
import org.apache.helix.task.TaskPartitionState;
import org.apache.helix.task.TaskState;
import org.apache.helix.task.TaskUtil;
import org.apache.helix.task.UserContentStore;
import org.apache.helix.task.Workflow;
import org.apache.helix.task.WorkflowConfig;
import org.apache.helix.task.WorkflowContext;
import org.apache.helix.task.WorkflowRebalancer;
import org.apache.helix.util.HelixUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskDriver {
    private static final Logger LOG = LoggerFactory.getLogger(TaskDriver.class);
    private static final int DEFAULT_TIMEOUT = 300000;
    private static final long DEFAULT_CONFIGS_LIMITATION = HelixUtil.getSystemPropertyAsLong("helixTask.configsLimitation", 100000L);
    private static final String TASK_START_TIME_KEY = "START_TIME";
    protected long _configsLimitation = DEFAULT_CONFIGS_LIMITATION;
    private final HelixDataAccessor _accessor;
    private final HelixPropertyStore<ZNRecord> _propertyStore;
    private final HelixAdmin _admin;
    private final String _clusterName;

    public TaskDriver(HelixManager manager) {
        this(manager.getClusterManagmentTool(), manager.getHelixDataAccessor(), manager.getHelixPropertyStore(), manager.getClusterName());
    }

    public TaskDriver(HelixZkClient client, String clusterName) {
        this(client, new ZkBaseDataAccessor<ZNRecord>(client), clusterName);
    }

    public TaskDriver(HelixZkClient client, ZkBaseDataAccessor<ZNRecord> baseAccessor, String clusterName) {
        this(new ZKHelixAdmin(client), new ZKHelixDataAccessor(clusterName, baseAccessor), new ZkHelixPropertyStore<ZNRecord>(baseAccessor, PropertyPathBuilder.propertyStore(clusterName), null), clusterName);
    }

    @Deprecated
    public TaskDriver(HelixAdmin admin, HelixDataAccessor accessor, ConfigAccessor cfgAccessor, HelixPropertyStore<ZNRecord> propertyStore, String clusterName) {
        this(admin, accessor, propertyStore, clusterName);
    }

    public TaskDriver(HelixAdmin admin, HelixDataAccessor accessor, HelixPropertyStore<ZNRecord> propertyStore, String clusterName) {
        this._admin = admin;
        this._accessor = accessor;
        this._propertyStore = propertyStore;
        this._clusterName = clusterName;
    }

    public void start(Workflow flow) {
        LOG.info("Starting workflow " + flow.getName());
        flow.validate();
        this.validateZKNodeLimitation(flow.getJobConfigs().keySet().size() + 1);
        WorkflowConfig newWorkflowConfig = new WorkflowConfig.Builder(flow.getWorkflowConfig()).setWorkflowId(flow.getName()).build();
        HashMap<String, String> jobTypes = new HashMap<String, String>();
        for (String job : flow.getJobConfigs().keySet()) {
            JobConfig jobCfg;
            JobConfig.Builder jobCfgBuilder = JobConfig.Builder.fromMap(flow.getJobConfigs().get(job));
            if (flow.getTaskConfigs() != null && flow.getTaskConfigs().containsKey(job)) {
                jobCfgBuilder.addTaskConfigs(flow.getTaskConfigs().get(job));
            }
            if ((jobCfg = jobCfgBuilder.build()).getJobType() != null) {
                jobTypes.put(job, jobCfg.getJobType());
            }
            this.addJobConfig(job, jobCfg);
        }
        newWorkflowConfig.setJobTypes(jobTypes);
        if (!TaskUtil.createWorkflowConfig(this._accessor, flow.getName(), newWorkflowConfig)) {
            HashSet<String> failedJobRemoval = new HashSet<String>();
            for (String job : flow.getJobConfigs().keySet()) {
                if (TaskUtil.removeJobConfig(this._accessor, job)) continue;
                failedJobRemoval.add(job);
            }
            throw new HelixException(String.format("Failed to add workflow configuration for workflow %s. It's possible that a workflow of the same name already exists or there was a connection issue. JobConfig deletion attempted but failed for the following jobs: %s", flow.getName(), failedJobRemoval));
        }
        this.addWorkflowResource(flow.getName());
    }

    public void updateWorkflow(String workflow, WorkflowConfig newWorkflowConfig) {
        if (newWorkflowConfig.getWorkflowId() == null || newWorkflowConfig.getWorkflowId().isEmpty()) {
            newWorkflowConfig.getRecord().setSimpleField(WorkflowConfig.WorkflowConfigProperty.WorkflowID.name(), workflow);
        }
        if (workflow == null || !workflow.equals(newWorkflowConfig.getWorkflowId())) {
            throw new HelixException(String.format("Workflow name {%s} does not match the workflow Id from WorkflowConfig {%s}", workflow, newWorkflowConfig.getWorkflowId()));
        }
        WorkflowConfig currentConfig = TaskUtil.getWorkflowConfig(this._accessor, workflow);
        if (currentConfig == null) {
            throw new HelixException("Workflow " + workflow + " does not exist!");
        }
        if (currentConfig.isTerminable()) {
            throw new HelixException("Workflow " + workflow + " is terminable, not allow to change its configuration!");
        }
        newWorkflowConfig.setJobDag(currentConfig.getJobDag());
        if (!TaskUtil.setWorkflowConfig(this._accessor, workflow, newWorkflowConfig)) {
            LOG.error("Failed to update workflow configuration for workflow " + workflow);
        }
    }

    public void createQueue(JobQueue queue) {
        this.start(queue);
    }

    public void flushQueue(String queue) {
        this.cleanupQueue(queue);
    }

    public void deleteJob(String queue, String job) {
        this.deleteNamespacedJob(queue, TaskUtil.getNamespacedJobName(queue, job), false);
    }

    public void deleteJob(String queue, String job, boolean forceDelete) {
        this.deleteNamespacedJob(queue, TaskUtil.getNamespacedJobName(queue, job), forceDelete);
    }

    public void deleteNamespacedJob(String queue, String job, boolean forceDelete) {
        WorkflowConfig jobQueueConfig = TaskUtil.getWorkflowConfig(this._accessor, queue);
        if (forceDelete) {
            LOG.info("Forcefully removing job: {} from queue: {}", (Object)job, (Object)queue);
            if (!TaskUtil.removeJob(this._accessor, this._propertyStore, job)) {
                LOG.info("Failed to delete job: {} from queue: {}", (Object)job, (Object)queue);
                throw new HelixException("Failed to delete job: " + job + " from queue: " + queue);
            }
            if (jobQueueConfig != null) {
                boolean isRecurringWorkflow;
                boolean bl = isRecurringWorkflow = jobQueueConfig.getScheduleConfig() != null && jobQueueConfig.getScheduleConfig().isRecurring();
                if (isRecurringWorkflow) {
                    this.deleteJobFromLastScheduledQueue(queue, TaskUtil.getDenamespacedJobName(queue, job));
                }
            }
            return;
        }
        if (jobQueueConfig == null) {
            throw new IllegalArgumentException(String.format("JobQueue %s's config is not found!", queue));
        }
        if (!jobQueueConfig.isJobQueue()) {
            throw new IllegalArgumentException(String.format("%s is not a queue!", queue));
        }
        boolean isRecurringWorkflow = jobQueueConfig.getScheduleConfig() != null && jobQueueConfig.getScheduleConfig().isRecurring();
        String denamespacedJob = TaskUtil.getDenamespacedJobName(queue, job);
        if (isRecurringWorkflow) {
            this.deleteJobFromLastScheduledQueue(queue, denamespacedJob);
        }
        this.deleteJobFromQueue(queue, denamespacedJob);
    }

    private void deleteJobFromLastScheduledQueue(String queue, String denamespacedJob) {
        WorkflowConfig lastWorkflowCfg;
        WorkflowContext wCtx = TaskUtil.getWorkflowContext(this._propertyStore, queue);
        String lastScheduledQueue = null;
        if (wCtx != null) {
            lastScheduledQueue = wCtx.getLastScheduledSingleWorkflow();
        }
        if (lastScheduledQueue != null && (lastWorkflowCfg = TaskUtil.getWorkflowConfig(this._accessor, lastScheduledQueue)) != null) {
            this.deleteJobFromQueue(lastScheduledQueue, denamespacedJob);
        }
    }

    private void deleteJobFromQueue(String queue, String job) {
        String workflowState;
        WorkflowContext workflowCtx = TaskUtil.getWorkflowContext(this._propertyStore, queue);
        String string = workflowState = workflowCtx != null ? workflowCtx.getWorkflowState().name() : TaskState.NOT_STARTED.name();
        if (workflowState.equals(TaskState.IN_PROGRESS.name())) {
            throw new IllegalStateException("Queue " + queue + " is still running!");
        }
        if (workflowState.equals(TaskState.COMPLETED.name()) || workflowState.equals(TaskState.FAILED.name()) || workflowState.equals(TaskState.ABORTED.name())) {
            LOG.warn("Queue " + queue + " has already reached its final state, skip deleting job from it.");
            return;
        }
        if (!TaskUtil.removeJobsFromWorkflow(this._accessor, this._propertyStore, queue, Collections.singleton(TaskUtil.getNamespacedJobName(queue, job)), true)) {
            LOG.error("Failed to delete job " + job + " from queue " + queue);
            throw new HelixException("Failed to delete job " + job + " from queue " + queue);
        }
    }

    public void enqueueJob(String queue, String job, JobConfig.Builder jobBuilder) {
        this.enqueueJobs(queue, Collections.singletonList(job), Collections.singletonList(jobBuilder));
    }

    public void enqueueJobs(String queue, List<String> jobs, List<JobConfig.Builder> jobBuilders) {
        WorkflowConfig workflowConfig = TaskUtil.getWorkflowConfig(this._accessor, queue);
        if (workflowConfig == null) {
            throw new IllegalArgumentException("Queue " + queue + " config does not yet exist!");
        }
        if (workflowConfig.isTerminable()) {
            throw new IllegalArgumentException(queue + " is not a queue!");
        }
        int capacity = workflowConfig.getCapacity();
        int queueSize = workflowConfig.getJobDag().size();
        if (capacity > 0 && queueSize >= capacity) {
            Set<String> expiredJobs;
            WorkflowContext workflowContext = TaskUtil.getWorkflowContext(this._propertyStore, queue);
            if (workflowContext != null && !TaskUtil.removeJobsFromWorkflow(this._accessor, this._propertyStore, queue, expiredJobs = TaskUtil.getExpiredJobs(this._accessor, this._propertyStore, workflowConfig, workflowContext), true)) {
                LOG.warn("Failed to clean up expired and completed jobs from queue " + queue);
            }
            if ((workflowConfig = TaskUtil.getWorkflowConfig(this._accessor, queue)).getJobDag().size() >= capacity) {
                throw new HelixException("Failed to enqueue a job, queue is full.");
            }
        }
        this.validateZKNodeLimitation(1);
        ArrayList<Object> jobConfigs = new ArrayList<Object>();
        ArrayList<String> namespacedJobNames = new ArrayList<String>();
        ArrayList<String> jobTypeList = new ArrayList<String>();
        try {
            for (int i = 0; i < jobBuilders.size(); ++i) {
                JobConfig jobConfig = jobBuilders.get(i).setWorkflow(queue).build();
                String namespacedJobName = TaskUtil.getNamespacedJobName(queue, jobs.get(i));
                this.addJobConfig(namespacedJobName, jobConfig);
                jobConfigs.add(jobConfig);
                namespacedJobNames.add(namespacedJobName);
                jobTypeList.add(jobConfig.getJobType());
            }
        }
        catch (HelixException e) {
            LOG.error("Failed to add job configs {}. Remove them all!", (Object)jobs.toString());
            for (String job : jobs) {
                String namespacedJobName = TaskUtil.getNamespacedJobName(queue, job);
                TaskUtil.removeJobConfig(this._accessor, namespacedJobName);
            }
        }
        DataUpdater updater = currentData -> {
            if (currentData == null) {
                throw new HelixException(String.format("enqueueJobs DataUpdater: JobQueue %s config is not found!", queue));
            }
            JobDag jobDag = JobDag.fromJson(currentData.getSimpleField(WorkflowConfig.WorkflowConfigProperty.Dag.name()));
            Set<String> allNodes = jobDag.getAllNodes();
            if (capacity > 0 && allNodes.size() + jobConfigs.size() >= capacity) {
                throw new IllegalStateException(String.format("Queue %s already reaches its max capacity %d, failed to add %s", queue, capacity, jobs.toString()));
            }
            String lastNodeName = null;
            for (int i = 0; i < namespacedJobNames.size(); ++i) {
                String namespacedJobName = (String)namespacedJobNames.get(i);
                if (allNodes.contains(namespacedJobName)) {
                    throw new IllegalStateException(String.format("Could not add to queue %s, job %s already exists", queue, jobs.get(i)));
                }
                jobDag.addNode(namespacedJobName);
                String candidate = null;
                if (lastNodeName == null) {
                    for (String node : allNodes) {
                        if (node.equals(namespacedJobName) || !jobDag.getDirectChildren(node).isEmpty()) continue;
                        candidate = node;
                        break;
                    }
                } else {
                    candidate = lastNodeName;
                }
                if (candidate == null) continue;
                jobDag.addParentToChild(candidate, namespacedJobName);
                lastNodeName = namespacedJobName;
            }
            Map<String, String> jobTypes = currentData.getMapField(WorkflowConfig.WorkflowConfigProperty.JobTypes.name());
            for (String jobType : jobTypeList) {
                if (jobType == null) continue;
                if (jobTypes == null) {
                    jobTypes = new HashMap<String, String>();
                }
                jobTypes.put(queue, jobType);
            }
            if (jobTypes != null) {
                currentData.setMapField(WorkflowConfig.WorkflowConfigProperty.JobTypes.name(), jobTypes);
            }
            try {
                currentData.setSimpleField(WorkflowConfig.WorkflowConfigProperty.Dag.name(), jobDag.toJson());
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Could not add jobs %s to queue %s", jobs.toString(), queue), e);
            }
            return currentData;
        };
        String path = this._accessor.keyBuilder().resourceConfig(queue).getPath();
        boolean status = this._accessor.getBaseDataAccessor().update(path, (DataUpdater<ZNRecord>)updater, AccessOption.PERSISTENT);
        if (!status) {
            LOG.error("Failed to update WorkflowConfig, remove all jobs {}", (Object)jobs.toString());
            for (String job : jobs) {
                TaskUtil.removeJobConfig(this._accessor, job);
            }
            throw new HelixException("Failed to enqueue job");
        }
        this.addWorkflowResourceIfNecessary(queue);
    }

    @Deprecated
    public void cleanupJobQueue(String queue) {
        this.cleanupQueue(queue);
    }

    public void cleanupQueue(String queue) {
        WorkflowConfig workflowConfig = TaskUtil.getWorkflowConfig(this._accessor, queue);
        if (workflowConfig == null) {
            throw new IllegalArgumentException("Queue " + queue + " does not yet exist!");
        }
        if (!workflowConfig.isJobQueue() || workflowConfig.isTerminable()) {
            throw new IllegalArgumentException(queue + " is not a queue!");
        }
        WorkflowContext wCtx = TaskUtil.getWorkflowContext(this._propertyStore, queue);
        if (wCtx == null || wCtx.getWorkflowState() == null) {
            throw new IllegalStateException("Queue " + queue + " does not have a valid work state!");
        }
        HashSet<String> jobs = new HashSet<String>();
        for (String jobNode : workflowConfig.getJobDag().getAllNodes()) {
            TaskState curState = wCtx.getJobState(jobNode);
            if ((curState == null || curState != TaskState.ABORTED) && curState != TaskState.COMPLETED && curState != TaskState.FAILED) continue;
            jobs.add(jobNode);
        }
        TaskUtil.removeJobsFromWorkflow(this._accessor, this._propertyStore, queue, jobs, true);
    }

    private void addWorkflowResource(String workflow) {
        this._admin.addResource(this._clusterName, workflow, 1, "Task");
        IdealState is = this.buildWorkflowIdealState(workflow);
        TaskUtil.createUserContent(this._propertyStore, workflow, new ZNRecord("UserContent"));
        this._admin.setResourceIdealState(this._clusterName, workflow, is);
    }

    private void addWorkflowResourceIfNecessary(String workflow) {
        IdealState is = this._admin.getResourceIdealState(this._clusterName, workflow);
        if (is == null) {
            this.addWorkflowResource(workflow);
        }
    }

    private IdealState buildWorkflowIdealState(String workflow) {
        CustomModeISBuilder IsBuilder = new CustomModeISBuilder(workflow);
        IsBuilder.setRebalancerMode(IdealState.RebalanceMode.TASK).setNumReplica(1).setNumPartitions(1).setStateModel("Task").disableExternalView();
        IdealState is = IsBuilder.build();
        is.getRecord().setListField(workflow, new ArrayList<String>());
        is.getRecord().setMapField(workflow, new HashMap<String, String>());
        is.setRebalancerClassName(WorkflowRebalancer.class.getName());
        return is;
    }

    private void addJobConfig(String job, JobConfig jobConfig) {
        LOG.info("Add job configuration " + job);
        JobConfig newJobCfg = new JobConfig(job, jobConfig);
        if (!TaskUtil.createJobConfig(this._accessor, job, newJobCfg)) {
            throw new HelixException("Failed to add job configuration for job " + job + ". It's possible that a job of the same name already exists or there was a connection issue");
        }
    }

    public void resume(String workflow) {
        this.setWorkflowTargetState(workflow, TargetState.START);
    }

    public void stop(String workflow) {
        this.setWorkflowTargetState(workflow, TargetState.STOP);
    }

    public void waitToStop(String workflow, long timeout) throws InterruptedException {
        this.setWorkflowTargetState(workflow, TargetState.STOP);
        long endTime = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() <= endTime) {
            WorkflowContext workflowContext = this.getWorkflowContext(workflow);
            if (workflowContext == null || TaskState.IN_PROGRESS.equals((Object)workflowContext.getWorkflowState())) {
                Thread.sleep(1000L);
                continue;
            }
            return;
        }
        throw new HelixException(String.format("Fail to stop the workflow/queue %s with in %d milliseconds.", workflow, timeout));
    }

    public void delete(String workflow) {
        this.delete(workflow, false);
    }

    public void delete(String workflow, boolean forceDelete) {
        WorkflowContext wCtx = TaskUtil.getWorkflowContext(this._propertyStore, workflow);
        if (forceDelete) {
            LOG.info("Forcefully removing workflow: " + workflow);
            this.removeWorkflowFromZK(workflow);
        } else {
            this.setWorkflowTargetState(workflow, TargetState.DELETE);
        }
        if (wCtx != null && wCtx.getScheduledWorkflows() != null) {
            for (String scheduledWorkflow : wCtx.getScheduledWorkflows()) {
                if (forceDelete) {
                    WorkflowContext scheduledWorkflowCtx = TaskUtil.getWorkflowContext(this._propertyStore, scheduledWorkflow);
                    if (scheduledWorkflowCtx == null || scheduledWorkflowCtx.getFinishTime() == -1L) continue;
                    this.removeWorkflowFromZK(scheduledWorkflow);
                    continue;
                }
                this.setWorkflowTargetState(scheduledWorkflow, TargetState.DELETE);
            }
        }
    }

    private void removeWorkflowFromZK(String workflow) {
        boolean success;
        HashSet<String> jobSet = new HashSet<String>();
        WorkflowConfig wCfg = TaskUtil.getWorkflowConfig(this._accessor, workflow);
        if (wCfg != null) {
            jobSet.addAll(wCfg.getJobDag().getAllNodes());
        }
        if (!(success = TaskUtil.removeWorkflow(this._accessor, this._propertyStore, workflow, jobSet))) {
            LOG.info("Failed to delete the workflow " + workflow);
            throw new HelixException("Failed to delete the workflow " + workflow);
        }
    }

    public void deleteAndWaitForCompletion(String workflow, long timeout) throws InterruptedException {
        this.delete(workflow);
        long endTime = System.currentTimeMillis() + timeout;
        BaseDataAccessor<ZNRecord> baseDataAccessor = this._accessor.getBaseDataAccessor();
        PropertyKey.Builder keyBuilder = this._accessor.keyBuilder();
        String idealStatePath = keyBuilder.idealStates(workflow).getPath();
        String workflowConfigPath = keyBuilder.resourceConfig(workflow).getPath();
        String workflowContextPath = keyBuilder.workflowContext(workflow).getPath();
        while (System.currentTimeMillis() <= endTime) {
            if (baseDataAccessor.exists(idealStatePath, AccessOption.PERSISTENT) || baseDataAccessor.exists(workflowConfigPath, AccessOption.PERSISTENT) || baseDataAccessor.exists(workflowContextPath, AccessOption.PERSISTENT)) {
                Thread.sleep(1000L);
                continue;
            }
            return;
        }
        StringBuilder failed = new StringBuilder();
        if (baseDataAccessor.exists(idealStatePath, AccessOption.PERSISTENT)) {
            failed.append("IdealState ");
        }
        if (baseDataAccessor.exists(workflowConfigPath, AccessOption.PERSISTENT)) {
            failed.append("WorkflowConfig ");
        }
        if (baseDataAccessor.exists(workflowContextPath, AccessOption.PERSISTENT)) {
            failed.append("WorkflowContext ");
        }
        throw new HelixException(String.format("Failed to delete the workflow/queue %s within %d milliseconds. The following components still remain: %s", workflow, timeout, failed.toString()));
    }

    private void setWorkflowTargetState(String workflow, TargetState state) {
        String lastScheduledWorkflow;
        this.setSingleWorkflowTargetState(workflow, state);
        WorkflowContext wCtx = TaskUtil.getWorkflowContext(this._propertyStore, workflow);
        if (wCtx != null && (lastScheduledWorkflow = wCtx.getLastScheduledSingleWorkflow()) != null) {
            this.setSingleWorkflowTargetState(lastScheduledWorkflow, state);
        }
    }

    private void setSingleWorkflowTargetState(String workflow, TargetState state) {
        LOG.info("Set " + workflow + " to target state " + (Object)((Object)state));
        WorkflowConfig workflowConfig = TaskUtil.getWorkflowConfig(this._accessor, workflow);
        if (workflowConfig == null) {
            LOG.warn("WorkflowConfig for " + workflow + " not found!");
            return;
        }
        WorkflowContext workflowContext = TaskUtil.getWorkflowContext(this._propertyStore, workflow);
        if (state != TargetState.DELETE && workflowContext != null && workflowContext.getFinishTime() != -1L) {
            LOG.info("Workflow " + workflow + " is already completed, skip to update its target state " + (Object)((Object)state));
            return;
        }
        DataUpdater updater = currentData -> {
            if (currentData != null) {
                currentData.setSimpleField(WorkflowConfig.WorkflowConfigProperty.TargetState.name(), state.name());
            } else {
                LOG.warn("TargetState DataUpdater: Fails to update target state. CurrentData is null.");
            }
            return currentData;
        };
        PropertyKey workflowConfigKey = TaskUtil.getWorkflowConfigKey(this._accessor, workflow);
        this._accessor.getBaseDataAccessor().update(workflowConfigKey.getPath(), (DataUpdater<ZNRecord>)updater, AccessOption.PERSISTENT);
    }

    public WorkflowConfig getWorkflowConfig(String workflow) {
        return TaskUtil.getWorkflowConfig(this._accessor, workflow);
    }

    public WorkflowContext getWorkflowContext(String workflow) {
        return TaskUtil.getWorkflowContext(this._propertyStore, workflow);
    }

    public JobConfig getJobConfig(String job) {
        return TaskUtil.getJobConfig(this._accessor, job);
    }

    public JobContext getJobContext(String job) {
        return TaskUtil.getJobContext(this._propertyStore, job);
    }

    public static JobContext getJobContext(HelixManager manager, String job) {
        return TaskUtil.getJobContext(manager, job);
    }

    public static WorkflowConfig getWorkflowConfig(HelixManager manager, String workflow) {
        return TaskUtil.getWorkflowConfig(manager, workflow);
    }

    public static WorkflowContext getWorkflowContext(HelixManager manager, String workflow) {
        return TaskUtil.getWorkflowContext(manager, workflow);
    }

    public static JobConfig getJobConfig(HelixManager manager, String job) {
        return TaskUtil.getJobConfig(manager, job);
    }

    public Map<String, WorkflowConfig> getWorkflows() {
        HashMap<String, WorkflowConfig> workflowConfigMap = new HashMap<String, WorkflowConfig>();
        Map resourceConfigMap = this._accessor.getChildValuesMap(this._accessor.keyBuilder().resourceConfigs(), true);
        for (Map.Entry resource : resourceConfigMap.entrySet()) {
            try {
                WorkflowConfig config = WorkflowConfig.fromHelixProperty((HelixProperty)resource.getValue());
                workflowConfigMap.put(resource.getKey(), config);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return workflowConfigMap;
    }

    public TaskState pollForWorkflowState(String workflowName, long timeout, TaskState ... targetStates) throws InterruptedException {
        WorkflowContext ctx;
        long st = System.currentTimeMillis();
        HashSet<TaskState> allowedStates = new HashSet<TaskState>(Arrays.asList(targetStates));
        long timeToSleep = timeout > 100L ? 100L : timeout;
        do {
            Thread.sleep(timeToSleep);
        } while (((ctx = this.getWorkflowContext(workflowName)) == null || ctx.getWorkflowState() == null || !allowedStates.contains((Object)ctx.getWorkflowState())) && System.currentTimeMillis() < st + timeout);
        if (ctx == null || !allowedStates.contains((Object)ctx.getWorkflowState())) {
            throw new HelixException(String.format("Workflow \"%s\" context is empty or not in states: \"%s\", current state: \"%s\"", workflowName, Arrays.asList(targetStates), ctx == null ? "null" : ctx.getWorkflowState().toString()));
        }
        return ctx.getWorkflowState();
    }

    public TaskState pollForWorkflowState(String workflowName, TaskState ... targetStates) throws InterruptedException {
        return this.pollForWorkflowState(workflowName, 300000L, targetStates);
    }

    public TaskState pollForJobState(String workflowName, String jobName, long timeout, TaskState ... states) throws InterruptedException {
        WorkflowContext ctx;
        long timeToSleep;
        WorkflowConfig workflowConfig = this.getWorkflowConfig(workflowName);
        if (workflowConfig == null) {
            throw new HelixException(String.format("Workflow \"%s\" does not exists!", workflowName));
        }
        long l = timeToSleep = timeout > 50L ? 50L : timeout;
        if (workflowConfig.isRecurring()) {
            do {
                Thread.sleep(timeToSleep);
            } while ((ctx = this.getWorkflowContext(workflowName)) == null || ctx.getLastScheduledSingleWorkflow() == null);
            jobName = jobName.substring(workflowName.length() + 1);
            workflowName = ctx.getLastScheduledSingleWorkflow();
        }
        HashSet<TaskState> allowedStates = new HashSet<TaskState>(Arrays.asList(states));
        long st = System.currentTimeMillis();
        do {
            Thread.sleep(timeToSleep);
        } while (((ctx = this.getWorkflowContext(workflowName)) == null || ctx.getJobState(jobName) == null || !allowedStates.contains((Object)ctx.getJobState(jobName))) && System.currentTimeMillis() < st + timeout);
        if (ctx == null || !allowedStates.contains((Object)ctx.getJobState(jobName))) {
            throw new HelixException(String.format("Workflow \"%s\" context is null or job \"%s\" is not in states: %s", workflowName, jobName, allowedStates));
        }
        return ctx.getJobState(jobName);
    }

    public TaskState pollForJobState(String workflowName, String jobName, TaskState ... states) throws InterruptedException {
        return this.pollForJobState(workflowName, jobName, 300000L, states);
    }

    public long getLastScheduledTaskTimestamp(String workflowName) {
        return this.getLastScheduledTaskExecutionInfo(workflowName).getStartTimeStamp();
    }

    public TaskExecutionInfo getLastScheduledTaskExecutionInfo(String workflowName) {
        long lastScheduledTaskTimestamp = -1L;
        String jobName = null;
        Integer taskPartitionIndex = null;
        TaskPartitionState state = null;
        WorkflowContext workflowContext = this.getWorkflowContext(workflowName);
        if (workflowContext != null) {
            Map<String, TaskState> allJobStates = workflowContext.getJobStates();
            for (Map.Entry<String, TaskState> jobState : allJobStates.entrySet()) {
                JobContext jobContext;
                if (jobState.getValue().equals((Object)TaskState.NOT_STARTED) || (jobContext = this.getJobContext(jobState.getKey())) == null) continue;
                Set<Integer> allPartitions = jobContext.getPartitionSet();
                for (Integer partition : allPartitions) {
                    long startTimeLong;
                    String startTime = jobContext.getMapField(partition).get(TASK_START_TIME_KEY);
                    if (startTime == null || (startTimeLong = Long.parseLong(startTime)) <= lastScheduledTaskTimestamp) continue;
                    lastScheduledTaskTimestamp = startTimeLong;
                    jobName = jobState.getKey();
                    taskPartitionIndex = partition;
                    state = jobContext.getPartitionState(partition);
                }
            }
        }
        return new TaskExecutionInfo(jobName, taskPartitionIndex, state, lastScheduledTaskTimestamp);
    }

    @Deprecated
    public String getUserContent(String key, UserContentStore.Scope scope, String workflowName, String jobName, String taskName) {
        return TaskUtil.getUserContent(this._propertyStore, key, scope, workflowName, jobName, taskName);
    }

    public Map<String, String> getWorkflowUserContentMap(String workflowName) {
        return TaskUtil.getWorkflowJobUserContentMap(this._propertyStore, workflowName);
    }

    public Map<String, String> getJobUserContentMap(String workflowName, String jobName) {
        String namespacedJobName = TaskUtil.getNamespacedJobName(workflowName, jobName);
        return TaskUtil.getWorkflowJobUserContentMap(this._propertyStore, namespacedJobName);
    }

    public Map<String, String> getTaskUserContentMap(String workflowName, String jobName, String taskPartitionId) {
        String namespacedJobName = TaskUtil.getNamespacedJobName(workflowName, jobName);
        String namespacedTaskName = TaskUtil.getNamespacedTaskName(namespacedJobName, taskPartitionId);
        return TaskUtil.getTaskUserContentMap(this._propertyStore, namespacedJobName, namespacedTaskName);
    }

    public void addOrUpdateWorkflowUserContentMap(String workflowName, Map<String, String> contentToAddOrUpdate) {
        TaskUtil.addOrUpdateWorkflowJobUserContentMap(this._propertyStore, workflowName, contentToAddOrUpdate);
    }

    public void addOrUpdateJobUserContentMap(String workflowName, String jobName, Map<String, String> contentToAddOrUpdate) {
        String namespacedJobName = TaskUtil.getNamespacedJobName(workflowName, jobName);
        TaskUtil.addOrUpdateWorkflowJobUserContentMap(this._propertyStore, namespacedJobName, contentToAddOrUpdate);
    }

    public void addOrUpdateTaskUserContentMap(String workflowName, String jobName, String taskPartitionId, Map<String, String> contentToAddOrUpdate) {
        String namespacedJobName = TaskUtil.getNamespacedJobName(workflowName, jobName);
        String namespacedTaskName = TaskUtil.getNamespacedTaskName(namespacedJobName, taskPartitionId);
        TaskUtil.addOrUpdateTaskUserContentMap(this._propertyStore, namespacedJobName, namespacedTaskName, contentToAddOrUpdate);
    }

    private void validateZKNodeLimitation(int newConfigNodeCount) {
        List<String> resourceConfigs = this._accessor.getChildNames(this._accessor.keyBuilder().resourceConfigs());
        if ((long)(resourceConfigs.size() + newConfigNodeCount) > this._configsLimitation) {
            throw new HelixException("Cannot create more workflows or jobs because there are already too many items created in the path CONFIGS.");
        }
    }

    public static enum DriverCommand {
        start,
        stop,
        delete,
        resume,
        list,
        flush,
        clean;

    }
}

