/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.spectator;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.JMException;
import org.apache.helix.HelixConstants;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.HelixManager;
import org.apache.helix.NotificationContext;
import org.apache.helix.PropertyKey;
import org.apache.helix.PropertyType;
import org.apache.helix.api.listeners.ConfigChangeListener;
import org.apache.helix.api.listeners.CurrentStateChangeListener;
import org.apache.helix.api.listeners.ExternalViewChangeListener;
import org.apache.helix.api.listeners.InstanceConfigChangeListener;
import org.apache.helix.api.listeners.LiveInstanceChangeListener;
import org.apache.helix.api.listeners.PreFetch;
import org.apache.helix.api.listeners.RoutingTableChangeListener;
import org.apache.helix.common.ClusterEventProcessor;
import org.apache.helix.common.caches.CurrentStateSnapshot;
import org.apache.helix.controller.stages.AttributeName;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.controller.stages.ClusterEventType;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.monitoring.mbeans.RoutingTableProviderMonitor;
import org.apache.helix.spectator.RoutingDataCache;
import org.apache.helix.spectator.RoutingTable;
import org.apache.helix.spectator.RoutingTableSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutingTableProvider
implements ExternalViewChangeListener,
InstanceConfigChangeListener,
ConfigChangeListener,
LiveInstanceChangeListener,
CurrentStateChangeListener {
    private static final Logger logger = LoggerFactory.getLogger(RoutingTableProvider.class);
    private static final long DEFAULT_PERIODIC_REFRESH_INTERVAL = 300000L;
    private final AtomicReference<RoutingTable> _routingTableRef;
    private final HelixManager _helixManager;
    private final RouterUpdater _routerUpdater;
    private final PropertyType _sourceDataType;
    private final Map<RoutingTableChangeListener, ListenerContext> _routingTableChangeListenerMap;
    private final RoutingTableProviderMonitor _monitor;
    private long _lastRefreshTimestamp;
    private boolean _isPeriodicRefreshEnabled = true;
    private long _periodRefreshInterval;
    private ScheduledThreadPoolExecutor _periodicRefreshExecutor;
    private ExecutorService _reportExecutor;
    private Future _reportingTask = null;
    final AtomicReference<Map<String, LiveInstance>> _lastSeenSessions = new AtomicReference();

    public RoutingTableProvider() {
        this(null);
    }

    public RoutingTableProvider(HelixManager helixManager) throws HelixException {
        this(helixManager, PropertyType.EXTERNALVIEW, true, 300000L);
    }

    public RoutingTableProvider(HelixManager helixManager, PropertyType sourceDataType) throws HelixException {
        this(helixManager, sourceDataType, true, 300000L);
    }

    public RoutingTableProvider(HelixManager helixManager, PropertyType sourceDataType, boolean isPeriodicRefreshEnabled, long periodRefreshInterval) throws HelixException {
        this._routingTableRef = new AtomicReference<RoutingTable>(new RoutingTable());
        this._helixManager = helixManager;
        this._sourceDataType = sourceDataType;
        this._routingTableChangeListenerMap = new ConcurrentHashMap<RoutingTableChangeListener, ListenerContext>();
        String clusterName = this._helixManager != null ? this._helixManager.getClusterName() : null;
        this._monitor = new RoutingTableProviderMonitor(this._sourceDataType, clusterName);
        try {
            this._monitor.register();
        }
        catch (JMException e) {
            logger.error("Failed to register RoutingTableProvider monitor MBean.", (Throwable)e);
        }
        this._reportExecutor = Executors.newSingleThreadExecutor();
        this._routerUpdater = new RouterUpdater(clusterName, this._sourceDataType);
        this._routerUpdater.start();
        if (this._helixManager != null) {
            switch (this._sourceDataType) {
                case EXTERNALVIEW: {
                    try {
                        this._helixManager.addExternalViewChangeListener(this);
                        break;
                    }
                    catch (Exception e) {
                        this.shutdown();
                        logger.error("Failed to attach ExternalView Listener to HelixManager!");
                        throw new HelixException("Failed to attach ExternalView Listener to HelixManager!", e);
                    }
                }
                case TARGETEXTERNALVIEW: {
                    if (!this._helixManager.getHelixDataAccessor().getBaseDataAccessor().exists(this._helixManager.getHelixDataAccessor().keyBuilder().targetExternalViews().getPath(), 0)) {
                        this.shutdown();
                        throw new HelixException("Target External View is not enabled!");
                    }
                    try {
                        this._helixManager.addTargetExternalViewChangeListener(this);
                        break;
                    }
                    catch (Exception e) {
                        this.shutdown();
                        logger.error("Failed to attach TargetExternalView Listener to HelixManager!");
                        throw new HelixException("Failed to attach TargetExternalView Listener to HelixManager!", e);
                    }
                }
                case CURRENTSTATES: {
                    break;
                }
                default: {
                    throw new HelixException(String.format("Unsupported source data type: %s", new Object[]{sourceDataType}));
                }
            }
            try {
                this._helixManager.addInstanceConfigChangeListener(this);
                this._helixManager.addLiveInstanceChangeListener(this);
            }
            catch (Exception e) {
                this.shutdown();
                logger.error("Failed to attach InstanceConfig and LiveInstance Change listeners to HelixManager!");
                throw new HelixException("Failed to attach InstanceConfig and LiveInstance Change listeners to HelixManager!", e);
            }
        }
        if (isPeriodicRefreshEnabled && this._helixManager != null) {
            this._lastRefreshTimestamp = System.currentTimeMillis();
            this._periodRefreshInterval = periodRefreshInterval;
            final NotificationContext periodicRefreshContext = new NotificationContext(this._helixManager);
            periodicRefreshContext.setType(NotificationContext.Type.PERIODIC_REFRESH);
            this._periodicRefreshExecutor = new ScheduledThreadPoolExecutor(1);
            this._periodicRefreshExecutor.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    if (RoutingTableProvider.this._lastRefreshTimestamp + RoutingTableProvider.this._periodRefreshInterval < System.currentTimeMillis()) {
                        RoutingTableProvider.this._routerUpdater.queueEvent(periodicRefreshContext, ClusterEventType.PeriodicalRebalance, null);
                    }
                }
            }, this._periodRefreshInterval, this._periodRefreshInterval, TimeUnit.MILLISECONDS);
        } else {
            this._isPeriodicRefreshEnabled = false;
        }
    }

    public void shutdown() {
        if (this._periodicRefreshExecutor != null) {
            this._periodicRefreshExecutor.purge();
            this._periodicRefreshExecutor.shutdown();
        }
        this._routerUpdater.shutdown();
        this._monitor.unregister();
        if (this._helixManager != null) {
            PropertyKey.Builder keyBuilder = this._helixManager.getHelixDataAccessor().keyBuilder();
            switch (this._sourceDataType) {
                case EXTERNALVIEW: {
                    this._helixManager.removeListener(keyBuilder.externalViews(), this);
                    break;
                }
                case TARGETEXTERNALVIEW: {
                    this._helixManager.removeListener(keyBuilder.targetExternalViews(), this);
                    break;
                }
                case CURRENTSTATES: {
                    NotificationContext context = new NotificationContext(this._helixManager);
                    context.setType(NotificationContext.Type.FINALIZE);
                    this.updateCurrentStatesListeners(Collections.emptyList(), context);
                    break;
                }
            }
        }
    }

    public RoutingTableSnapshot getRoutingTableSnapshot() {
        return new RoutingTableSnapshot(this._routingTableRef.get());
    }

    public void addRoutingTableChangeListener(RoutingTableChangeListener routingTableChangeListener, Object context) {
        this._routingTableChangeListenerMap.put(routingTableChangeListener, new ListenerContext(context));
        logger.info("Attach RoutingTableProviderChangeListener {}", (Object)routingTableChangeListener.getClass().getName());
    }

    public Object removeRoutingTableChangeListener(RoutingTableChangeListener routingTableChangeListener) {
        logger.info("Detach RoutingTableProviderChangeListener {}", (Object)routingTableChangeListener.getClass().getName());
        return this._routingTableChangeListenerMap.remove(routingTableChangeListener);
    }

    public List<InstanceConfig> getInstances(String resourceName, String partitionName, String state) {
        return this.getInstancesForResource(resourceName, partitionName, state);
    }

    public List<InstanceConfig> getInstancesForResource(String resourceName, String partitionName, String state) {
        return this._routingTableRef.get().getInstancesForResource(resourceName, partitionName, state);
    }

    public List<InstanceConfig> getInstancesForResourceGroup(String resourceGroupName, String partitionName, String state) {
        return this._routingTableRef.get().getInstancesForResourceGroup(resourceGroupName, partitionName, state);
    }

    public List<InstanceConfig> getInstancesForResourceGroup(String resourceGroupName, String partitionName, String state, List<String> resourceTags) {
        return this._routingTableRef.get().getInstancesForResourceGroup(resourceGroupName, partitionName, state, resourceTags);
    }

    public Set<InstanceConfig> getInstances(String resourceName, String state) {
        return this.getInstancesForResource(resourceName, state);
    }

    public Set<InstanceConfig> getInstancesForResource(String resourceName, String state) {
        return this._routingTableRef.get().getInstancesForResource(resourceName, state);
    }

    public Set<InstanceConfig> getInstancesForResourceGroup(String resourceGroupName, String state) {
        return this._routingTableRef.get().getInstancesForResourceGroup(resourceGroupName, state);
    }

    public Set<InstanceConfig> getInstancesForResourceGroup(String resourceGroupName, String state, List<String> resourceTags) {
        return this._routingTableRef.get().getInstancesForResourceGroup(resourceGroupName, state, resourceTags);
    }

    public Collection<LiveInstance> getLiveInstances() {
        return this._routingTableRef.get().getLiveInstances();
    }

    public Collection<InstanceConfig> getInstanceConfigs() {
        return this._routingTableRef.get().getInstanceConfigs();
    }

    public Collection<String> getResources() {
        return this._routingTableRef.get().getResources();
    }

    @Override
    @PreFetch(enabled=false)
    public void onExternalViewChange(List<ExternalView> externalViewList, NotificationContext changeContext) {
        HelixConstants.ChangeType changeType = changeContext.getChangeType();
        if (changeType != null && !changeType.getPropertyType().equals((Object)this._sourceDataType)) {
            logger.warn("onExternalViewChange called with mismatched change types. Source data type {}, changed data type: {}", (Object)this._sourceDataType, (Object)changeType);
            return;
        }
        if (externalViewList != null && externalViewList.size() > 0) {
            this.refresh(externalViewList, changeContext);
        } else {
            ClusterEventType eventType;
            if (this._sourceDataType.equals((Object)PropertyType.EXTERNALVIEW)) {
                eventType = ClusterEventType.ExternalViewChange;
            } else if (this._sourceDataType.equals((Object)PropertyType.TARGETEXTERNALVIEW)) {
                eventType = ClusterEventType.TargetExternalViewChange;
            } else {
                logger.warn("onExternalViewChange called with mismatched change types. Source data type {}, change type: {}", (Object)this._sourceDataType, (Object)changeType);
                return;
            }
            this._routerUpdater.queueEvent(changeContext, eventType, changeType);
        }
    }

    @Override
    @PreFetch(enabled=false)
    public void onInstanceConfigChange(List<InstanceConfig> configs, NotificationContext changeContext) {
        this._routerUpdater.queueEvent(changeContext, ClusterEventType.InstanceConfigChange, HelixConstants.ChangeType.INSTANCE_CONFIG);
    }

    @Override
    @PreFetch(enabled=false)
    public void onConfigChange(List<InstanceConfig> configs, NotificationContext changeContext) {
        this.onInstanceConfigChange(configs, changeContext);
    }

    @Override
    @PreFetch(enabled=true)
    public void onLiveInstanceChange(List<LiveInstance> liveInstances, NotificationContext changeContext) {
        if (this._sourceDataType.equals((Object)PropertyType.CURRENTSTATES)) {
            this.updateCurrentStatesListeners(liveInstances, changeContext);
        }
        this._routerUpdater.queueEvent(changeContext, ClusterEventType.LiveInstanceChange, HelixConstants.ChangeType.LIVE_INSTANCE);
    }

    @Override
    @PreFetch(enabled=false)
    public void onStateChange(String instanceName, List<CurrentState> statesInfo, NotificationContext changeContext) {
        if (this._sourceDataType.equals((Object)PropertyType.CURRENTSTATES)) {
            this._routerUpdater.queueEvent(changeContext, ClusterEventType.CurrentStateChange, HelixConstants.ChangeType.CURRENT_STATE);
        } else {
            logger.warn("RoutingTableProvider does not use CurrentStates as source, ignore CurrentState changes!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCurrentStatesListeners(List<LiveInstance> liveInstances, NotificationContext changeContext) {
        HelixManager manager = changeContext.getManager();
        PropertyKey.Builder keyBuilder = new PropertyKey.Builder(manager.getClusterName());
        if (changeContext.getType() == NotificationContext.Type.FINALIZE) {
            logger.info("remove current-state listeners. lastSeenSessions: {}", this._lastSeenSessions);
            liveInstances = Collections.emptyList();
        }
        HashMap<String, LiveInstance> curSessions = new HashMap<String, LiveInstance>();
        for (LiveInstance liveInstance : liveInstances) {
            curSessions.put(liveInstance.getEphemeralOwner(), liveInstance);
        }
        AtomicReference<Map<String, LiveInstance>> atomicReference = this._lastSeenSessions;
        synchronized (atomicReference) {
            String instanceName;
            Map<String, LiveInstance> lastSessions = this._lastSeenSessions.get();
            if (lastSessions == null) {
                lastSessions = Collections.emptyMap();
            }
            for (String session : curSessions.keySet()) {
                if (lastSessions.containsKey(session)) continue;
                instanceName = ((LiveInstance)curSessions.get(session)).getInstanceName();
                try {
                    manager.addCurrentStateChangeListener(this, instanceName, session);
                    logger.info("{} added current-state listener for instance: {}, session: {}, listener: {}", new Object[]{manager.getInstanceName(), instanceName, session, this});
                }
                catch (Exception e) {
                    logger.error("Fail to add current state listener for instance: {} with session: {}", new Object[]{instanceName, session, e});
                }
            }
            for (String session : lastSessions.keySet()) {
                if (curSessions.containsKey(session)) continue;
                instanceName = lastSessions.get(session).getInstanceName();
                manager.removeListener(keyBuilder.currentStates(instanceName, session), this);
                logger.info("remove current-state listener for instance: {}, session: {}", (Object)instanceName, (Object)session);
            }
            this._lastSeenSessions.set(curSessions);
        }
    }

    private void reset() {
        logger.info("Resetting the routing table.");
        RoutingTable newRoutingTable = new RoutingTable();
        this._routingTableRef.set(newRoutingTable);
    }

    protected void refresh(List<ExternalView> externalViewList, NotificationContext changeContext) {
        HelixDataAccessor accessor = changeContext.getManager().getHelixDataAccessor();
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        List<InstanceConfig> configList = accessor.getChildValues(keyBuilder.instanceConfigs(), true);
        List<LiveInstance> liveInstances = accessor.getChildValues(keyBuilder.liveInstances(), true);
        this.refresh(externalViewList, configList, liveInstances);
    }

    protected void refresh(Collection<ExternalView> externalViews, Collection<InstanceConfig> instanceConfigs, Collection<LiveInstance> liveInstances) {
        long startTime = System.currentTimeMillis();
        RoutingTable newRoutingTable = new RoutingTable(externalViews, instanceConfigs, liveInstances);
        this.resetRoutingTableAndNotify(startTime, newRoutingTable);
    }

    protected void refresh(Map<String, Map<String, Map<String, CurrentState>>> currentStateMap, Collection<InstanceConfig> instanceConfigs, Collection<LiveInstance> liveInstances) {
        long startTime = System.currentTimeMillis();
        RoutingTable newRoutingTable = new RoutingTable(currentStateMap, instanceConfigs, liveInstances);
        this.resetRoutingTableAndNotify(startTime, newRoutingTable);
    }

    private void resetRoutingTableAndNotify(long startTime, RoutingTable newRoutingTable) {
        this._routingTableRef.set(newRoutingTable);
        String clusterName = this._helixManager != null ? this._helixManager.getClusterName() : null;
        logger.info("Refreshed the RoutingTable for cluster {}, took {} ms.", (Object)clusterName, (Object)(System.currentTimeMillis() - startTime));
        this.notifyRoutingTableChange(clusterName);
        if (this._isPeriodicRefreshEnabled) {
            this._lastRefreshTimestamp = System.currentTimeMillis();
        }
    }

    private void notifyRoutingTableChange(String clusterName) {
        long startTime = System.currentTimeMillis();
        for (Map.Entry<RoutingTableChangeListener, ListenerContext> entry : this._routingTableChangeListenerMap.entrySet()) {
            entry.getKey().onRoutingTableChange(new RoutingTableSnapshot(this._routingTableRef.get()), entry.getValue().getContext());
        }
        logger.info("RoutingTableProvider user callback time for cluster {}, took {} ms.", (Object)clusterName, (Object)(System.currentTimeMillis() - startTime));
    }

    private class ListenerContext {
        private Object _context;

        public ListenerContext(Object context) {
            this._context = context;
        }

        public Object getContext() {
            return this._context;
        }
    }

    private class RouterUpdater
    extends ClusterEventProcessor {
        private final RoutingDataCache _dataCache;

        public RouterUpdater(String clusterName, PropertyType sourceDataType) {
            super(clusterName, "Helix-RouterUpdater-event_process");
            this._dataCache = new RoutingDataCache(clusterName, sourceDataType);
        }

        @Override
        protected void handleEvent(ClusterEvent event) {
            NotificationContext changeContext = (NotificationContext)event.getAttribute(AttributeName.changeContext.name());
            HelixConstants.ChangeType changeType = changeContext.getChangeType();
            this._dataCache.setClusterEventId(event.getEventId());
            if (changeContext == null || changeContext.getType() != NotificationContext.Type.CALLBACK) {
                this._dataCache.requireFullRefresh();
            } else {
                this._dataCache.notifyDataChange(changeType, changeContext.getPathChanged());
            }
            if (changeContext.getType() == NotificationContext.Type.FINALIZE) {
                RoutingTableProvider.this.reset();
            } else {
                HelixManager manager = (HelixManager)event.getAttribute(AttributeName.helixmanager.name());
                if (manager == null) {
                    logger.error(String.format("HelixManager is null for router update event: %s", event));
                    throw new HelixException("HelixManager is null for router update event.");
                }
                if (!manager.isConnected()) {
                    logger.error(String.format("HelixManager is not connected for router update event: %s", event));
                    throw new HelixException("HelixManager is not connected for router update event.");
                }
                long startTime = System.currentTimeMillis();
                this._dataCache.refresh(manager.getHelixDataAccessor());
                switch (RoutingTableProvider.this._sourceDataType) {
                    case EXTERNALVIEW: {
                        RoutingTableProvider.this.refresh(this._dataCache.getExternalViews().values(), this._dataCache.getInstanceConfigMap().values(), this._dataCache.getLiveInstances().values());
                        break;
                    }
                    case TARGETEXTERNALVIEW: {
                        RoutingTableProvider.this.refresh(this._dataCache.getTargetExternalViews().values(), this._dataCache.getInstanceConfigMap().values(), this._dataCache.getLiveInstances().values());
                        break;
                    }
                    case CURRENTSTATES: {
                        RoutingTableProvider.this.refresh(this._dataCache.getCurrentStatesMap(), this._dataCache.getInstanceConfigMap().values(), this._dataCache.getLiveInstances().values());
                        this.recordPropagationLatency(System.currentTimeMillis(), this._dataCache.getCurrentStateSnapshot());
                        break;
                    }
                    default: {
                        logger.warn("Unsupported source data type: {}, stop refreshing the routing table!", (Object)RoutingTableProvider.this._sourceDataType);
                    }
                }
                RoutingTableProvider.this._monitor.increaseDataRefreshCounters(startTime);
            }
        }

        private void recordPropagationLatency(final long currentTime, final CurrentStateSnapshot currentStateSnapshot) {
            if (RoutingTableProvider.this._reportingTask == null || RoutingTableProvider.this._reportingTask.isDone()) {
                RoutingTableProvider.this._reportingTask = RoutingTableProvider.this._reportExecutor.submit(new Callable<Object>(){

                    @Override
                    public Object call() {
                        Map<PropertyKey, Map<String, Long>> currentStateEndTimeMap = currentStateSnapshot.getNewCurrentStateEndTimes();
                        for (PropertyKey key : currentStateEndTimeMap.keySet()) {
                            Map<String, Long> partitionStateEndTimes = currentStateEndTimeMap.get(key);
                            for (String partition : partitionStateEndTimes.keySet()) {
                                long endTime = partitionStateEndTimes.get(partition);
                                if (currentTime >= endTime) {
                                    RoutingTableProvider.this._monitor.recordStatePropagationLatency(currentTime - endTime);
                                    logger.debug("CurrentState updated in the routing table. Node Key {}, Partition {}, end time {}, Propagation latency {}", new Object[]{key.toString(), partition, endTime, currentTime - endTime});
                                    continue;
                                }
                                logger.trace("CurrentState updated in the routing table. Node Key {}, Partition {}, end time {}, Propagation latency {}", new Object[]{key.toString(), partition, endTime, currentTime - endTime});
                            }
                        }
                        return null;
                    }
                });
            }
        }

        public void queueEvent(NotificationContext context, ClusterEventType eventType, HelixConstants.ChangeType changeType) {
            ClusterEvent event = new ClusterEvent(this._clusterName, eventType);
            event.addAttribute(AttributeName.helixmanager.name(), context.getManager());
            event.addAttribute(AttributeName.changeContext.name(), context);
            this.queueEvent(event);
            RoutingTableProvider.this._monitor.increaseCallbackCounters(this._eventQueue.size());
        }
    }
}

