/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.model;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import org.apache.helix.HelixProperty;
import org.apache.helix.ZNRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParticipantHistory
extends HelixProperty {
    private static Logger LOG = LoggerFactory.getLogger(ParticipantHistory.class);
    private static final int HISTORY_SIZE = 20;
    public static long ONLINE = -1L;

    public ParticipantHistory(String id) {
        super(id);
    }

    public ParticipantHistory(ZNRecord znRecord) {
        super(znRecord);
    }

    public void reportOffline() {
        long time = System.currentTimeMillis();
        this._record.setSimpleField(ConfigProperty.LAST_OFFLINE_TIME.name(), String.valueOf(time));
        this.updateOfflineHistory(time);
    }

    public void reportOnline(String sessionId, String version) {
        this.updateSessionHistory(sessionId, version);
        this._record.setSimpleField(ConfigProperty.LAST_OFFLINE_TIME.name(), String.valueOf(ONLINE));
    }

    public long getLastOfflineTime() {
        long offlineTime = ONLINE;
        String timeStr = this._record.getSimpleField(ConfigProperty.LAST_OFFLINE_TIME.name());
        if (timeStr != null) {
            try {
                offlineTime = Long.valueOf(timeStr);
            }
            catch (NumberFormatException ex) {
                LOG.warn("Failed to parse LAST_OFFLINE_TIME " + timeStr);
            }
        }
        return offlineTime;
    }

    private void updateSessionHistory(String sessionId, String version) {
        List<String> list = this._record.getListField(ConfigProperty.HISTORY.name());
        if (list == null) {
            list = new ArrayList<String>();
            this._record.setListField(ConfigProperty.HISTORY.name(), list);
        }
        if (list.size() == 20) {
            list.remove(0);
        }
        HashMap<String, String> sessionEntry = new HashMap<String, String>();
        sessionEntry.put(ConfigProperty.SESSION.name(), sessionId);
        long timeMillis = System.currentTimeMillis();
        sessionEntry.put(ConfigProperty.TIME.name(), String.valueOf(timeMillis));
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss:SSS");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        String dateTime = df.format(new Date(timeMillis));
        sessionEntry.put(ConfigProperty.DATE.name(), dateTime);
        sessionEntry.put(ConfigProperty.VERSION.name(), version);
        list.add(((Object)sessionEntry).toString());
    }

    private void updateOfflineHistory(long time) {
        List<String> list = this._record.getListField(ConfigProperty.OFFLINE.name());
        if (list == null) {
            list = new ArrayList<String>();
            this._record.setListField(ConfigProperty.OFFLINE.name(), list);
        }
        if (list.size() == 20) {
            list.remove(0);
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss:SSS");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        String dateTime = df.format(new Date(time));
        list.add(dateTime);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    private static enum ConfigProperty {
        TIME,
        DATE,
        SESSION,
        HISTORY,
        OFFLINE,
        VERSION,
        LAST_OFFLINE_TIME;

    }
}

