/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records;

import com.google.common.annotations.VisibleForTesting;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class URL {
    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static URL newInstance(String scheme, String host, int port, String file) {
        URL url = Records.newRecord(URL.class);
        url.setScheme(scheme);
        url.setHost(host);
        url.setPort(port);
        url.setFile(file);
        return url;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract String getScheme();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setScheme(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract String getUserInfo();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setUserInfo(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract String getHost();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setHost(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract int getPort();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setPort(int var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract String getFile();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setFile(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public Path toPath() throws URISyntaxException {
        return new Path(new URI(this.getScheme(), this.getUserInfo(), this.getHost(), this.getPort(), this.getFile(), null, null));
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public static URL fromURI(URI uri, Configuration conf) {
        URL url = RecordFactoryProvider.getRecordFactory(conf).newRecordInstance(URL.class);
        if (uri.getHost() != null) {
            url.setHost(uri.getHost());
        }
        if (uri.getUserInfo() != null) {
            url.setUserInfo(uri.getUserInfo());
        }
        url.setPort(uri.getPort());
        url.setScheme(uri.getScheme());
        url.setFile(uri.getPath());
        return url;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static URL fromURI(URI uri) {
        return URL.fromURI(uri, null);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public static URL fromPath(Path path, Configuration conf) {
        return URL.fromURI(path.toUri(), conf);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static URL fromPath(Path path) {
        return URL.fromURI(path.toUri());
    }
}

