/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.protobuf.generated.ComparatorProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class BinaryComponentComparator
extends ByteArrayComparable {
    private int offset;

    public BinaryComponentComparator(byte[] value, int offset) {
        super(value);
        this.offset = offset;
    }

    public int compareTo(byte[] value) {
        return this.compareTo(value, 0, value.length);
    }

    public int compareTo(byte[] value, int offset, int length) {
        return Bytes.compareTo((byte[])this.value, (int)0, (int)this.value.length, (byte[])value, (int)(offset + this.offset), (int)this.value.length);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof BinaryComponentComparator)) {
            return false;
        }
        BinaryComponentComparator bcc = (BinaryComponentComparator)((Object)other);
        return this.offset == bcc.offset && this.compareTo(bcc.value) == 0;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.offset;
        return result;
    }

    public byte[] toByteArray() {
        ComparatorProtos.BinaryComponentComparator.Builder builder = ComparatorProtos.BinaryComponentComparator.newBuilder();
        builder.setValue(ByteString.copyFrom((byte[])this.value));
        builder.setOffset(this.offset);
        return builder.build().toByteArray();
    }

    public static BinaryComponentComparator parseFrom(byte[] pbBytes) throws DeserializationException {
        ComparatorProtos.BinaryComponentComparator proto;
        try {
            proto = ComparatorProtos.BinaryComponentComparator.parseFrom((byte[])pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException((Throwable)e);
        }
        return new BinaryComponentComparator(proto.getValue().toByteArray(), proto.getOffset());
    }

    boolean areSerializedFieldsEqual(ByteArrayComparable other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof BinaryComponentComparator)) {
            return false;
        }
        return super.areSerializedFieldsEqual(other);
    }
}

