/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.CharArrayWriter;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.catalyst.csv.UnivocityGenerator;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.StructsToCsv$;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr[, options]) - Returns a CSV string with a given struct value", examples="\n    Examples:\n      > SELECT _FUNC_(named_struct('a', 1, 'b', 2));\n       1,2\n      > SELECT _FUNC_(named_struct('time', to_timestamp('2015-08-26', 'yyyy-MM-dd')), map('timestampFormat', 'dd/MM/yyyy'));\n       26/08/2015\n  ", since="3.0.0", group="csv_funcs")
@ScalaSignature(bytes="\u0006\u0001\ted\u0001B\u0015+\u0001^B\u0001\u0002\u0017\u0001\u0003\u0016\u0004%\t!\u0017\u0005\tQ\u0002\u0011\t\u0012)A\u00055\"A\u0011\u000e\u0001BK\u0002\u0013\u0005!\u000e\u0003\u0005o\u0001\tE\t\u0015!\u0003l\u0011!y\u0007A!f\u0001\n\u0003\u0001\b\u0002\u0003;\u0001\u0005#\u0005\u000b\u0011B9\t\u000bU\u0004A\u0011\u0001<\t\u000bm\u0004A\u0011\t?\t\rU\u0004A\u0011AA\u0001\u0011\u0019)\b\u0001\"\u0001\u0002\b!1Q\u000f\u0001C\u0001\u0003\u0017A!\"!\u0005\u0001\u0011\u000b\u0007I\u0011AA\n\u0011)\ti\u0003\u0001EC\u0002\u0013\u0005\u0011q\u0006\u0005\u000b\u0003\u007f\u0001\u0001R1A\u0005\u0002\u0005\u0005\u0003BCA)\u0001!\u0015\r\u0011\"\u0001\u0002T!9\u0011\u0011\u000f\u0001\u0005B\u0005M\u0004bBA>\u0001\u0011\u0005\u0013Q\u0010\u0005\b\u0003\u0003\u0003A\u0011IAB\u0011\u001d\tI\t\u0001C!\u0003\u0017Cq!a)\u0001\t\u0003\n)\u000bC\u0004\u0002(\u0002!\t&!+\t\u0013\u0005=\u0006!!A\u0005\u0002\u0005E\u0006\"CA]\u0001E\u0005I\u0011AA^\u0011%\t\t\u000eAI\u0001\n\u0003\t\u0019\u000eC\u0005\u0002X\u0002\t\n\u0011\"\u0001\u0002Z\"I\u0011Q\u001c\u0001\u0002\u0002\u0013\u0005\u0013q\u001c\u0005\n\u0003W\u0004\u0011\u0011!C\u0001\u0003[D\u0011\"!>\u0001\u0003\u0003%\t!a>\t\u0013\u0005u\b!!A\u0005B\u0005}\b\"\u0003B\u0007\u0001\u0005\u0005I\u0011\u0001B\b\u0011%\u0011\u0019\u0002AA\u0001\n\u0003\u0012)bB\u0005\u0003:)\n\t\u0011#\u0001\u0003<\u0019A\u0011FKA\u0001\u0012\u0003\u0011i\u0004\u0003\u0004vC\u0011\u0005!1\n\u0005\n\u0005\u001b\n\u0013\u0011!C#\u0005\u001fB\u0011B!\u0015\"\u0003\u0003%\tIa\u0015\t\u0013\tm\u0013%%A\u0005\u0002\u0005e\u0007\"\u0003B/C\u0005\u0005I\u0011\u0011B0\u0011%\u0011i'II\u0001\n\u0003\tI\u000eC\u0005\u0003p\u0005\n\t\u0011\"\u0003\u0003r\ta1\u000b\u001e:vGR\u001cHk\\\"tm*\u00111\u0006L\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002.]\u0005A1-\u0019;bYf\u001cHO\u0003\u00020a\u0005\u00191/\u001d7\u000b\u0005E\u0012\u0014!B:qCJ\\'BA\u001a5\u0003\u0019\t\u0007/Y2iK*\tQ'A\u0002pe\u001e\u001c\u0001a\u0005\u0005\u0001qqzT\tS(V!\tI$(D\u0001+\u0013\tY$FA\bV]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\tIT(\u0003\u0002?U\t9B+[7f5>tW-Q<be\u0016,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u0005*\nqaY8eK\u001e,g.\u0003\u0002E\u0003\ny1i\u001c3fO\u0016tg)\u00197mE\u0006\u001c7\u000e\u0005\u0002:\r&\u0011qI\u000b\u0002\u0012\u000bb\u0004Xm\u0019;t\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bCA%M\u001d\tI$*\u0003\u0002LU\u00059\u0001/Y2lC\u001e,\u0017BA'O\u00059qU\u000f\u001c7J]R|G.\u001a:b]RT!a\u0013\u0016\u0011\u0005A\u001bV\"A)\u000b\u0003I\u000bQa]2bY\u0006L!\u0001V)\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0001KV\u0005\u0003/F\u0013AbU3sS\u0006d\u0017N_1cY\u0016\fqa\u001c9uS>t7/F\u0001[!\u0011Y&-Z3\u000f\u0005q\u0003\u0007CA/R\u001b\u0005q&BA07\u0003\u0019a$o\\8u}%\u0011\u0011-U\u0001\u0007!J,G-\u001a4\n\u0005\r$'aA'ba*\u0011\u0011-\u0015\t\u00037\u001aL!a\u001a3\u0003\rM#(/\u001b8h\u0003!y\u0007\u000f^5p]N\u0004\u0013!B2iS2$W#A6\u0011\u0005eb\u0017BA7+\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0007G\"LG\u000e\u001a\u0011\u0002\u0015QLW.\u001a.p]\u0016LE-F\u0001r!\r\u0001&/Z\u0005\u0003gF\u0013aa\u00149uS>t\u0017a\u0003;j[\u0016TvN\\3JI\u0002\na\u0001P5oSRtD\u0003B<ysj\u0004\"!\u000f\u0001\t\u000ba;\u0001\u0019\u0001.\t\u000b%<\u0001\u0019A6\t\u000f=<\u0001\u0013!a\u0001c\u0006Aa.\u001e7mC\ndW-F\u0001~!\t\u0001f0\u0003\u0002\u0000#\n9!i\\8mK\u0006tG#B<\u0002\u0004\u0005\u0015\u0001\"\u0002-\n\u0001\u0004Q\u0006\"B5\n\u0001\u0004YGcA<\u0002\n!)\u0011N\u0003a\u0001WR)q/!\u0004\u0002\u0010!)\u0011n\u0003a\u0001W\")\u0001l\u0003a\u0001W\u00061qO]5uKJ,\"!!\u0006\u0011\t\u0005]\u0011\u0011E\u0007\u0003\u00033QA!a\u0007\u0002\u001e\u0005\u0011\u0011n\u001c\u0006\u0003\u0003?\tAA[1wC&!\u00111EA\r\u0005=\u0019\u0005.\u0019:BeJ\f\u0017p\u0016:ji\u0016\u0014\bf\u0001\u0007\u0002(A\u0019\u0001+!\u000b\n\u0007\u0005-\u0012KA\u0005ue\u0006t7/[3oi\u0006Y\u0011N\u001c9viN\u001b\u0007.Z7b+\t\t\t\u0004\u0005\u0003\u00024\u0005eRBAA\u001b\u0015\r\t9DL\u0001\u0006if\u0004Xm]\u0005\u0005\u0003w\t)D\u0001\u0006TiJ,8\r\u001e+za\u0016D3!DA\u0014\u0003\r9WM\\\u000b\u0003\u0003\u0007\u0002B!!\u0012\u0002L5\u0011\u0011q\t\u0006\u0004\u0003\u0013b\u0013aA2tm&!\u0011QJA$\u0005I)f.\u001b<pG&$\u0018pR3oKJ\fGo\u001c:)\u00079\t9#A\u0005d_:4XM\u001d;feV\u0011\u0011Q\u000b\t\b!\u0006]\u00131LA1\u0013\r\tI&\u0015\u0002\n\rVt7\r^5p]F\u00022\u0001UA/\u0013\r\ty&\u0015\u0002\u0004\u0003:L\b\u0003BA2\u0003Wj!!!\u001a\u000b\t\u0005]\u0012q\r\u0006\u0004\u0003S\u0002\u0014AB;og\u00064W-\u0003\u0003\u0002n\u0005\u0015$AC+U\rb\u001aFO]5oO\"\u001aq\"a\n\u0002\u0011\u0011\fG/\u0019+za\u0016,\"!!\u001e\u0011\t\u0005M\u0012qO\u0005\u0005\u0003s\n)D\u0001\u0005ECR\fG+\u001f9f\u000319\u0018\u000e\u001e5US6,'l\u001c8f)\ra\u0014q\u0010\u0005\u0006_F\u0001\r!Z\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0005\u00037\n)\tC\u0004\u0002\bJ\u0001\r!a\u0017\u0002\u000bY\fG.^3\u0002\u0015%t\u0007/\u001e;UsB,7/\u0006\u0002\u0002\u000eB1\u0011qRAL\u0003;sA!!%\u0002\u0016:\u0019Q,a%\n\u0003IK!aS)\n\t\u0005e\u00151\u0014\u0002\u0004'\u0016\f(BA&R!\u0011\t\u0019$a(\n\t\u0005\u0005\u0016Q\u0007\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\f!\u0002\u001d:fiRLh*Y7f+\u0005)\u0017\u0001F<ji\"tUm^\"iS2$\u0017J\u001c;fe:\fG\u000eF\u0002x\u0003WCa!!,\u0016\u0001\u0004Y\u0017\u0001\u00038fo\u000eC\u0017\u000e\u001c3\u0002\t\r|\u0007/\u001f\u000b\bo\u0006M\u0016QWA\\\u0011\u001dAf\u0003%AA\u0002iCq!\u001b\f\u0011\u0002\u0003\u00071\u000eC\u0004p-A\u0005\t\u0019A9\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u0018\u0016\u00045\u0006}6FAAa!\u0011\t\u0019-!4\u000e\u0005\u0005\u0015'\u0002BAd\u0003\u0013\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005-\u0017+\u0001\u0006b]:|G/\u0019;j_:LA!a4\u0002F\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\u001b\u0016\u0004W\u0006}\u0016AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u00037T3!]A`\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011\u0011\u001d\t\u0005\u0003G\fI/\u0004\u0002\u0002f*!\u0011q]A\u000f\u0003\u0011a\u0017M\\4\n\u0007\u001d\f)/\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002pB\u0019\u0001+!=\n\u0007\u0005M\u0018KA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\\\u0005e\b\"CA~9\u0005\u0005\t\u0019AAx\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!\u0011\u0001\t\u0007\u0005\u0007\u0011I!a\u0017\u000e\u0005\t\u0015!b\u0001B\u0004#\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t-!Q\u0001\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002~\u0005#A\u0011\"a?\u001f\u0003\u0003\u0005\r!a\u0017\u0002\r\u0015\fX/\u00197t)\ri(q\u0003\u0005\n\u0003w|\u0012\u0011!a\u0001\u00037B3\u0003\u0001B\u000e\u0005C\u0011\u0019Ca\n\u0003*\t5\"q\u0006B\u001a\u0005k\u00012!\u000fB\u000f\u0013\r\u0011yB\u000b\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\u0011)#\u0001%`\rVs5i\u0018\u0015fqB\u00148\f\f\u0011paRLwN\\:^S\u0001j\u0003EU3ukJt7\u000fI1!\u0007N3\u0006e\u001d;sS:<\u0007e^5uQ\u0002\n\u0007eZ5wK:\u00043\u000f\u001e:vGR\u0004c/\u00197vK\u0006AQ\r_1na2,7/\t\u0002\u0003,\u0005\t\tM\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015oC6,GmX:ueV\u001cG\u000fK\u0014bO1\u0002\u0013\u0007\f\u0011(E\u001eb\u0003EM\u0015*w)\u0001\u0003\u0005\t\u0011!A\u0001\nDF\r\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)]\u0006lW\rZ0tiJ,8\r\u001e\u0015(i&lWm\n\u0017!i>|F/[7fgR\fW\u000e\u001d\u0015(eA\nT'\f\u00199[I2t\u0005\f\u0011(sfL\u00180L'N[\u0011$w%K\u0015-A5\f\u0007\u000fK\u0014uS6,7\u000f^1na\u001a{'/\\1uO1\u0002s\u0005\u001a30\u001b6{\u00130_=zO%J3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001a7_ABtF\r\u00192k)\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u00032\u0005)1G\f\u0019/a\u0005)qM]8va\u0006\u0012!qG\u0001\nGN4xLZ;oGN\fAb\u0015;sk\u000e$8\u000fV8DgZ\u0004\"!O\u0011\u0014\t\u0005\u0012y$\u0016\t\t\u0005\u0003\u00129EW6ro6\u0011!1\t\u0006\u0004\u0005\u000b\n\u0016a\u0002:v]RLW.Z\u0005\u0005\u0005\u0013\u0012\u0019EA\tBEN$(/Y2u\rVt7\r^5p]N\"\"Aa\u000f\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!9\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000f]\u0014)Fa\u0016\u0003Z!)\u0001\f\na\u00015\")\u0011\u000e\na\u0001W\"9q\u000e\nI\u0001\u0002\u0004\t\u0018aD1qa2LH\u0005Z3gCVdG\u000fJ\u001a\u0002\u000fUt\u0017\r\u001d9msR!!\u0011\rB5!\u0011\u0001&Oa\u0019\u0011\rA\u0013)GW6r\u0013\r\u00119'\u0015\u0002\u0007)V\u0004H.Z\u001a\t\u0011\t-d%!AA\u0002]\f1\u0001\u001f\u00131\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011\u0019\b\u0005\u0003\u0002d\nU\u0014\u0002\u0002B<\u0003K\u0014aa\u00142kK\u000e$\b")
public class StructsToCsv
extends UnaryExpression
implements TimeZoneAwareExpression,
CodegenFallback,
ExpectsInputTypes,
package.NullIntolerant,
scala.Serializable {
    private transient CharArrayWriter writer;
    private transient StructType inputSchema;
    private transient UnivocityGenerator gen;
    private transient Function1<Object, UTF8String> converter;
    private final Map<String, String> options;
    private final Expression child;
    private final Option<String> timeZoneId;
    private boolean resolved;
    private final Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<String> $lessinit$greater$default$3() {
        return StructsToCsv$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Map<String, String>, Expression, Option<String>>> unapply(StructsToCsv structsToCsv) {
        return StructsToCsv$.MODULE$.unapply(structsToCsv);
    }

    public static Option<String> apply$default$3() {
        return StructsToCsv$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Map<String, String>, Expression, Option<String>>, StructsToCsv> tupled() {
        return StructsToCsv$.MODULE$.tupled();
    }

    public static Function1<Map<String, String>, Function1<Expression, Function1<Option<String>, StructsToCsv>>> curried() {
        return StructsToCsv$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public Seq<Enumeration.Value> nodePatternsInternal() {
        return TimeZoneAwareExpression.nodePatternsInternal$(this);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    private boolean resolved$lzycompute() {
        StructsToCsv structsToCsv = this;
        synchronized (structsToCsv) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        StructsToCsv structsToCsv = this;
        synchronized (structsToCsv) {
            if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x10);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        return (byte)(this.bitmap$trans$0 & 0x10) == 0 ? this.zoneId$lzycompute() : this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Map<String, String> options() {
        return this.options;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    private CharArrayWriter writer$lzycompute() {
        StructsToCsv structsToCsv = this;
        synchronized (structsToCsv) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.writer = new CharArrayWriter();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.writer;
    }

    public CharArrayWriter writer() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.writer$lzycompute() : this.writer;
    }

    private StructType inputSchema$lzycompute() {
        StructsToCsv structsToCsv = this;
        synchronized (structsToCsv) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                StructType structType;
                DataType dataType = this.child().dataType();
                if (!(dataType instanceof StructType)) {
                    throw QueryExecutionErrors$.MODULE$.inputTypeUnsupportedError(dataType);
                }
                StructType structType2 = structType = (StructType)dataType;
                this.inputSchema = structType2;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.inputSchema;
    }

    public StructType inputSchema() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.inputSchema$lzycompute() : this.inputSchema;
    }

    private UnivocityGenerator gen$lzycompute() {
        StructsToCsv structsToCsv = this;
        synchronized (structsToCsv) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.gen = new UnivocityGenerator(this.inputSchema(), this.writer(), new CSVOptions(this.options(), true, (String)this.timeZoneId().get()));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.gen;
    }

    public UnivocityGenerator gen() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.gen$lzycompute() : this.gen;
    }

    private Function1<Object, UTF8String> converter$lzycompute() {
        StructsToCsv structsToCsv = this;
        synchronized (structsToCsv) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.converter = (Function1 & Serializable & scala.Serializable)row -> UTF8String.fromString((String)this.gen().writeToString((InternalRow)row));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.converter;
    }

    public Function1<Object, UTF8String> converter() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.converter$lzycompute() : this.converter;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Map<String, String> x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, (Option<String>)x$1);
    }

    @Override
    public Object nullSafeEval(Object value) {
        return this.converter().apply(value);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        StructType$ structType$ = StructType$.MODULE$;
        return Nil$.MODULE$.$colon$colon((Object)structType$);
    }

    @Override
    public String prettyName() {
        return "to_csv";
    }

    @Override
    public StructsToCsv withNewChildInternal(Expression newChild) {
        Expression x$1 = newChild;
        Map<String, String> x$2 = this.copy$default$1();
        Option<String> x$3 = this.copy$default$3();
        return this.copy(x$2, x$1, x$3);
    }

    public StructsToCsv copy(Map<String, String> options, Expression child, Option<String> timeZoneId) {
        return new StructsToCsv(options, child, timeZoneId);
    }

    public Map<String, String> copy$default$1() {
        return this.options();
    }

    public Expression copy$default$2() {
        return this.child();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "StructsToCsv";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.options();
                break;
            }
            case 1: {
                object = this.child();
                break;
            }
            case 2: {
                object = this.timeZoneId();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StructsToCsv;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StructsToCsv)) return false;
        boolean bl = true;
        if (!bl) return false;
        StructsToCsv structsToCsv = (StructsToCsv)x$1;
        Map<String, String> map = this.options();
        Map<String, String> map2 = structsToCsv.options();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Expression expression = this.child();
        Expression expression2 = structsToCsv.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = structsToCsv.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!structsToCsv.canEqual(this)) return false;
        return true;
    }

    public StructsToCsv(Map<String, String> options, Expression child, Option<String> timeZoneId) {
        this.options = options;
        this.child = child;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        CodegenFallback.$init$(this);
        ExpectsInputTypes.$init$(this);
    }

    public StructsToCsv(Map<String, String> options, Expression child) {
        this(options, child, (Option<String>)None$.MODULE$);
    }

    public StructsToCsv(Expression child) {
        this((Map<String, String>)Predef$.MODULE$.Map().empty(), child, (Option<String>)None$.MODULE$);
    }

    public StructsToCsv(Expression child, Expression options) {
        this(ExprUtils$.MODULE$.convertToMapData(options), child, (Option<String>)None$.MODULE$);
    }
}

