/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.math.BigDecimal;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.SecondsToTimestamp$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(seconds) - Creates timestamp from the number of seconds (can be fractional) since UTC epoch.", examples="\n    Examples:\n      > SELECT _FUNC_(1230219000);\n       2008-12-25 07:30:00\n      > SELECT _FUNC_(1230219000.123);\n       2008-12-25 07:30:00.123\n  ", group="datetime_funcs", since="3.1.0")
@ScalaSignature(bytes="\u0006\u0001\u0005}g\u0001B\u000e\u001d\u0001&B\u0001\"\u0011\u0001\u0003\u0016\u0004%\tA\u0011\u0005\t\r\u0002\u0011\t\u0012)A\u0005\u0007\")q\t\u0001C\u0001\u0011\")1\n\u0001C!\u0019\")a\f\u0001C!?\")1\r\u0001C!I\"A\u0001\u000e\u0001EC\u0002\u0013%\u0011\u000eC\u0003u\u0001\u0011\u0005S\u000fC\u0003y\u0001\u0011\u0005\u0013\u0010C\u0004\u0002\u0010\u0001!\t%!\u0005\t\u000f\u0005\r\u0002\u0001\"\u0015\u0002&!I\u00111\u0006\u0001\u0002\u0002\u0013\u0005\u0011Q\u0006\u0005\n\u0003c\u0001\u0011\u0013!C\u0001\u0003gA\u0011\"!\u0013\u0001\u0003\u0003%\t%a\u0013\t\u0013\u0005m\u0003!!A\u0005\u0002\u0005u\u0003\"CA3\u0001\u0005\u0005I\u0011AA4\u0011%\ti\u0007AA\u0001\n\u0003\ny\u0007C\u0005\u0002~\u0001\t\t\u0011\"\u0001\u0002\u0000!I\u00111\u0011\u0001\u0002\u0002\u0013\u0005\u0013QQ\u0004\n\u0003Sc\u0012\u0011!E\u0001\u0003W3\u0001b\u0007\u000f\u0002\u0002#\u0005\u0011Q\u0016\u0005\u0007\u000fV!\t!a/\t\u0013\u0005uV#!A\u0005F\u0005}\u0006\"CAa+\u0005\u0005I\u0011QAb\u0011%\t9-FA\u0001\n\u0003\u000bI\rC\u0005\u0002VV\t\t\u0011\"\u0003\u0002X\n\u00112+Z2p]\u0012\u001cHk\u001c+j[\u0016\u001cH/Y7q\u0015\tib$A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0010!\u0003!\u0019\u0017\r^1msN$(BA\u0011#\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003G\u0011\nQa\u001d9be.T!!\n\u0014\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0013aA8sO\u000e\u00011C\u0002\u0001+]EBd\b\u0005\u0002,Y5\tA$\u0003\u0002.9\tyQK\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u0002,_%\u0011\u0001\u0007\b\u0002\u0012\u000bb\u0004Xm\u0019;t\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bC\u0001\u001a6\u001d\tY3'\u0003\u000259\u00059\u0001/Y2lC\u001e,\u0017B\u0001\u001c8\u00059qU\u000f\u001c7J]R|G.\u001a:b]RT!\u0001\u000e\u000f\u0011\u0005ebT\"\u0001\u001e\u000b\u0003m\nQa]2bY\u0006L!!\u0010\u001e\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0011hP\u0005\u0003\u0001j\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fQa\u00195jY\u0012,\u0012a\u0011\t\u0003W\u0011K!!\u0012\u000f\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0004dQ&dG\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005%S\u0005CA\u0016\u0001\u0011\u0015\t5\u00011\u0001D\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0002\u001bB\u0019a*\u0016-\u000f\u0005=#fB\u0001)T\u001b\u0005\t&B\u0001*)\u0003\u0019a$o\\8u}%\t1(\u0003\u00025u%\u0011ak\u0016\u0002\u0004'\u0016\f(B\u0001\u001b;!\tIF,D\u0001[\u0015\tY\u0006%A\u0003usB,7/\u0003\u0002^5\n\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\tI\u0006$\u0018\rV=qKV\t\u0001\r\u0005\u0002ZC&\u0011!M\u0017\u0002\t\t\u0006$\u0018\rV=qK\u0006Aa.\u001e7mC\ndW-F\u0001f!\tId-\u0003\u0002hu\t9!i\\8mK\u0006t\u0017\u0001C3wC24UO\\2\u0016\u0003)\u0004B!O6n[&\u0011AN\u000f\u0002\n\rVt7\r^5p]F\u0002\"!\u000f8\n\u0005=T$aA!os\"\u0012q!\u001d\t\u0003sIL!a\u001d\u001e\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dGCA7w\u0011\u00159\b\u00021\u0001n\u0003\u0015Ig\u000e];u\u0003%!wnR3o\u0007>$W\rF\u0003{\u0003\u0003\tY\u0001\u0005\u0002|}6\tAP\u0003\u0002~9\u000591m\u001c3fO\u0016t\u0017BA@}\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007bBA\u0002\u0013\u0001\u0007\u0011QA\u0001\u0004GRD\bcA>\u0002\b%\u0019\u0011\u0011\u0002?\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"1\u0011QB\u0005A\u0002i\f!!\u001a<\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0006\u0002\u0002\u0014A!\u0011QCA\u000f\u001d\u0011\t9\"!\u0007\u0011\u0005AS\u0014bAA\u000eu\u00051\u0001K]3eK\u001aLA!a\b\u0002\"\t11\u000b\u001e:j]\u001eT1!a\u0007;\u0003Q9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7e\u0013:$XM\u001d8bYR\u0019\u0011*a\n\t\r\u0005%2\u00021\u0001D\u0003!qWm^\"iS2$\u0017\u0001B2paf$2!SA\u0018\u0011\u001d\tE\u0002%AA\u0002\r\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u00026)\u001a1)a\u000e,\u0005\u0005e\u0002\u0003BA\u001e\u0003\u000bj!!!\u0010\u000b\t\u0005}\u0012\u0011I\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0011;\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u000f\niDA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA'!\u0011\ty%!\u0017\u000e\u0005\u0005E#\u0002BA*\u0003+\nA\u0001\\1oO*\u0011\u0011qK\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002 \u0005E\u0013\u0001\u00049s_\u0012,8\r^!sSRLXCAA0!\rI\u0014\u0011M\u0005\u0004\u0003GR$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$HcA7\u0002j!I\u00111\u000e\t\u0002\u0002\u0003\u0007\u0011qL\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005E\u0004#BA:\u0003sjWBAA;\u0015\r\t9HO\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA>\u0003k\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019Q-!!\t\u0011\u0005-$#!AA\u00025\fa!Z9vC2\u001cHcA3\u0002\b\"A\u00111N\n\u0002\u0002\u0003\u0007Q\u000eK\n\u0001\u0003\u0017\u000b\t*a%\u0002\u0018\u0006e\u0015QTAP\u0003G\u000b)\u000bE\u0002,\u0003\u001bK1!a$\u001d\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!&\u0002G~3UKT\"`QM,7m\u001c8eg&\u0002S\u0006I\"sK\u0006$Xm\u001d\u0011uS6,7\u000f^1na\u00022'o\\7!i\",\u0007E\\;nE\u0016\u0014\be\u001c4!g\u0016\u001cwN\u001c3tA!\u001a\u0017M\u001c\u0011cK\u00022'/Y2uS>t\u0017\r\\\u0015!g&t7-\u001a\u0011V)\u000e\u0003S\r]8dQ:\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u00037\u000b\u00111\u0006\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)cI\u001a\u0004GM\u0019:aA\u0002\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00113aABT&\r\u001a.eU\u0002\u0003g\u000e\u001e4ai\u0002\u0004G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u00152eM\u0002$'M\u001d1aAr\u0013GM\u001a*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012\u0004\u0007\r\u001d.cIj#'\u000e\u00111oi\u001a\u0004G\u000f\u00191]E\u00124G\u0003\u0011!\u0003\u00159'o\\;qC\t\t\t+\u0001\beCR,G/[7f?\u001a,hnY:\u0002\u000bMLgnY3\"\u0005\u0005\u001d\u0016!B\u001a/c9\u0002\u0014AE*fG>tGm\u001d+p)&lWm\u001d;b[B\u0004\"aK\u000b\u0014\tU\tyK\u0010\t\u0007\u0003c\u000b9lQ%\u000e\u0005\u0005M&bAA[u\u00059!/\u001e8uS6,\u0017\u0002BA]\u0003g\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c82)\t\tY+\u0001\u0005u_N#(/\u001b8h)\t\ti%A\u0003baBd\u0017\u0010F\u0002J\u0003\u000bDQ!\u0011\rA\u0002\r\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002L\u0006E\u0007\u0003B\u001d\u0002N\u000eK1!a4;\u0005\u0019y\u0005\u000f^5p]\"A\u00111[\r\u0002\u0002\u0003\u0007\u0011*A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011\u0011\u0011\u001c\t\u0005\u0003\u001f\nY.\u0003\u0003\u0002^\u0006E#AB(cU\u0016\u001cG\u000f")
public class SecondsToTimestamp
extends UnaryExpression
implements ExpectsInputTypes,
package.NullIntolerant,
scala.Serializable {
    private transient Function1<Object, Object> evalFunc;
    private final Expression child;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Expression> unapply(SecondsToTimestamp secondsToTimestamp) {
        return SecondsToTimestamp$.MODULE$.unapply(secondsToTimestamp);
    }

    public static <A> Function1<Expression, A> andThen(Function1<SecondsToTimestamp, A> function1) {
        return SecondsToTimestamp$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, SecondsToTimestamp> compose(Function1<A, Expression> function1) {
        return SecondsToTimestamp$.MODULE$.compose(function1);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)NumericType$.MODULE$, (List)Nil$.MODULE$);
    }

    @Override
    public DataType dataType() {
        return TimestampType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        DataType dataType = this.child().dataType();
        boolean bl = dataType instanceof FloatType ? true : dataType instanceof DoubleType;
        boolean bl2 = bl ? true : this.child().nullable();
        return bl2;
    }

    private Function1<Object, Object> evalFunc$lzycompute() {
        SecondsToTimestamp secondsToTimestamp = this;
        synchronized (secondsToTimestamp) {
            if (!this.bitmap$trans$0) {
                Function1 & Serializable & scala.Serializable intersect;
                DataType dataType = this.child().dataType();
                if (dataType instanceof IntegralType) {
                    intersect = (Function1 & Serializable & scala.Serializable)input -> BoxesRunTime.boxToLong((long)SecondsToTimestamp.$anonfun$evalFunc$1(input));
                } else if (dataType instanceof DecimalType) {
                    intersect = (Function1 & Serializable & scala.Serializable)input -> BoxesRunTime.boxToLong((long)SecondsToTimestamp.$anonfun$evalFunc$2(input));
                } else if (dataType instanceof FloatType) {
                    intersect = (Function1 & Serializable & scala.Serializable)input -> {
                        float f = BoxesRunTime.unboxToFloat((Object)input);
                        return Float.isNaN(f) || Float.isInfinite(f) ? null : BoxesRunTime.boxToLong((long)((long)((double)f * (double)1000000L)));
                    };
                } else if (dataType instanceof DoubleType) {
                    intersect = (Function1 & Serializable & scala.Serializable)input -> {
                        double d = BoxesRunTime.unboxToDouble((Object)input);
                        return Double.isNaN(d) || Double.isInfinite(d) ? null : BoxesRunTime.boxToLong((long)((long)(d * (double)1000000L)));
                    };
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.evalFunc = intersect;
                this.bitmap$trans$0 = true;
            }
        }
        return this.evalFunc;
    }

    private Function1<Object, Object> evalFunc() {
        return !this.bitmap$trans$0 ? this.evalFunc$lzycompute() : this.evalFunc;
    }

    @Override
    public Object nullSafeEval(Object input) {
        return this.evalFunc().apply(input);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        DataType dataType = this.child().dataType();
        if (dataType instanceof IntegralType) {
            exprCode = this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> new StringBuilder(33).append("java.lang.Math.multiplyExact(").append((String)c).append(", ").append(1000000L).append("L)").toString());
        } else if (dataType instanceof DecimalType) {
            String operand = new StringBuilder(26).append("new java.math.BigDecimal(").append(1000000L).append(")").toString();
            exprCode = this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> new StringBuilder(47).append((String)c).append(".toJavaBigDecimal().multiply(").append(operand).append(").longValueExact()").toString());
        } else {
            String castToDouble = dataType instanceof FloatType ? "(double)" : "";
            exprCode = this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> {
                String typeStr = CodeGenerator$.MODULE$.boxedType(dataType);
                return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(146).append("\n           |if (").append(typeStr).append(".isNaN(").append((String)c).append(") || ").append(typeStr).append(".isInfinite(").append((String)c).append(")) {\n           |  ").append(ev.isNull()).append(" = true;\n           |} else {\n           |  ").append(ev.value()).append(" = (long)(").append(castToDouble).append((String)c).append(" * ").append(1000000L).append(");\n           |}\n           |").toString())).stripMargin();
            });
        }
        return exprCode;
    }

    @Override
    public String prettyName() {
        return "timestamp_seconds";
    }

    @Override
    public SecondsToTimestamp withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public SecondsToTimestamp copy(Expression child) {
        return new SecondsToTimestamp(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "SecondsToTimestamp";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return this.child();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SecondsToTimestamp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SecondsToTimestamp)) return false;
        boolean bl = true;
        if (!bl) return false;
        SecondsToTimestamp secondsToTimestamp = (SecondsToTimestamp)x$1;
        Expression expression = this.child();
        Expression expression2 = secondsToTimestamp.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!secondsToTimestamp.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ long $anonfun$evalFunc$1(Object input) {
        return Math.multiplyExact(((Number)input).longValue(), 1000000L);
    }

    public static final /* synthetic */ long $anonfun$evalFunc$2(Object input) {
        BigDecimal operand = new BigDecimal(1000000L);
        return ((Decimal)input).toJavaBigDecimal().multiply(operand).longValueExact();
    }

    public SecondsToTimestamp(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
    }
}

