/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BitwiseCount$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the number of bits that are set in the argument expr as an unsigned 64-bit integer, or NULL if the argument is NULL.", examples="\n    Examples:\n      > SELECT _FUNC_(0);\n       0\n  ", since="3.0.0", group="bitwise_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005%g\u0001\u0002\u000e\u001c\u0001\"B\u0001\u0002\u0011\u0001\u0003\u0016\u0004%\t!\u0011\u0005\t\u000b\u0002\u0011\t\u0012)A\u0005\u0005\")a\t\u0001C\u0001\u000f\")!\n\u0001C!\u0017\")Q\f\u0001C!=\")!\r\u0001C!G\")A\u000e\u0001C![\")a\u000e\u0001C!_\")Q\u0010\u0001C)}\"9\u0011\u0011\u0002\u0001\u0005R\u0005-\u0001\"CA\t\u0001\u0005\u0005I\u0011AA\n\u0011%\t9\u0002AI\u0001\n\u0003\tI\u0002C\u0005\u00020\u0001\t\t\u0011\"\u0011\u00022!I\u0011\u0011\t\u0001\u0002\u0002\u0013\u0005\u00111\t\u0005\n\u0003\u0017\u0002\u0011\u0011!C\u0001\u0003\u001bB\u0011\"a\u0015\u0001\u0003\u0003%\t%!\u0016\t\u0013\u0005\r\u0004!!A\u0005\u0002\u0005\u0015\u0004\"CA8\u0001\u0005\u0005I\u0011IA9\u000f%\t)jGA\u0001\u0012\u0003\t9J\u0002\u0005\u001b7\u0005\u0005\t\u0012AAM\u0011\u00191E\u0003\"\u0001\u0002(\"A!\rFA\u0001\n\u000b\nI\u000bC\u0005\u0002,R\t\t\u0011\"!\u0002.\"I\u0011\u0011\u0017\u000b\u0002\u0002\u0013\u0005\u00151\u0017\u0005\n\u0003\u007f#\u0012\u0011!C\u0005\u0003\u0003\u0014ABQ5uo&\u001cXmQ8v]RT!\u0001H\u000f\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003=}\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003A\u0005\n1a]9m\u0015\t\u00113%A\u0003ta\u0006\u00148N\u0003\u0002%K\u00051\u0011\r]1dQ\u0016T\u0011AJ\u0001\u0004_J<7\u0001A\n\u0007\u0001%j\u0003gN\u001f\u0011\u0005)ZS\"A\u000e\n\u00051Z\"aD+oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005)r\u0013BA\u0018\u001c\u0005E)\u0005\u0010]3diNLe\u000e];u)f\u0004Xm\u001d\t\u0003cQr!A\u000b\u001a\n\u0005MZ\u0012a\u00029bG.\fw-Z\u0005\u0003kY\u0012aBT;mY&sGo\u001c7fe\u0006tGO\u0003\u000247A\u0011\u0001hO\u0007\u0002s)\t!(A\u0003tG\u0006d\u0017-\u0003\u0002=s\t9\u0001K]8ek\u000e$\bC\u0001\u001d?\u0013\ty\u0014H\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\u0003dQ&dG-F\u0001C!\tQ3)\u0003\u0002E7\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\r\rD\u0017\u000e\u001c3!\u0003\u0019a\u0014N\\5u}Q\u0011\u0001*\u0013\t\u0003U\u0001AQ\u0001Q\u0002A\u0002\t\u000b!\"\u001b8qkR$\u0016\u0010]3t+\u0005a\u0005cA'U/:\u0011aj\u0015\b\u0003\u001fJk\u0011\u0001\u0015\u0006\u0003#\u001e\na\u0001\u0010:p_Rt\u0014\"\u0001\u001e\n\u0005MJ\u0014BA+W\u0005\r\u0019V-\u001d\u0006\u0003ge\u0002\"\u0001W.\u000e\u0003eS!AW\u0010\u0002\u000bQL\b/Z:\n\u0005qK&\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003!!\u0017\r^1UsB,W#A0\u0011\u0005a\u0003\u0017BA1Z\u0005!!\u0015\r^1UsB,\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003\u0011\u0004\"!Z5\u000f\u0005\u0019<\u0007CA(:\u0013\tA\u0017(\u0001\u0004Qe\u0016$WMZ\u0005\u0003U.\u0014aa\u0015;sS:<'B\u00015:\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002I\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0004aZ\\\bCA9u\u001b\u0005\u0011(BA:\u001c\u0003\u001d\u0019w\u000eZ3hK:L!!\u001e:\u0003\u0011\u0015C\bO]\"pI\u0016DQa\u001e\u0005A\u0002a\f1a\u0019;y!\t\t\u00180\u0003\u0002{e\nq1i\u001c3fO\u0016t7i\u001c8uKb$\b\"\u0002?\t\u0001\u0004\u0001\u0018AA3w\u00031qW\u000f\u001c7TC\u001a,WI^1m)\ry\u0018Q\u0001\t\u0004q\u0005\u0005\u0011bAA\u0002s\t\u0019\u0011I\\=\t\r\u0005\u001d\u0011\u00021\u0001\u0000\u0003\u0015Ig\u000e];u\u0003Q9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7e\u0013:$XM\u001d8bYR\u0019\u0001*!\u0004\t\r\u0005=!\u00021\u0001C\u0003!qWm^\"iS2$\u0017\u0001B2paf$2\u0001SA\u000b\u0011\u001d\u00015\u0002%AA\u0002\t\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u001c)\u001a!)!\b,\u0005\u0005}\u0001\u0003BA\u0011\u0003Wi!!a\t\u000b\t\u0005\u0015\u0012qE\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u000b:\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003[\t\u0019CA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\u001a!\u0011\t)$a\u0010\u000e\u0005\u0005]\"\u0002BA\u001d\u0003w\tA\u0001\\1oO*\u0011\u0011QH\u0001\u0005U\u00064\u0018-C\u0002k\u0003o\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u0012\u0011\u0007a\n9%C\u0002\u0002Je\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2a`A(\u0011%\t\tfDA\u0001\u0002\u0004\t)%A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003/\u0002R!!\u0017\u0002`}l!!a\u0017\u000b\u0007\u0005u\u0013(\u0001\u0006d_2dWm\u0019;j_:LA!!\u0019\u0002\\\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t9'!\u001c\u0011\u0007a\nI'C\u0002\u0002le\u0012qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002RE\t\t\u00111\u0001\u0000\u0003\u0019)\u0017/^1mgR!\u0011qMA:\u0011!\t\tFEA\u0001\u0002\u0004y\bf\u0005\u0001\u0002x\u0005u\u0014qPAB\u0003\u000b\u000bI)a#\u0002\u0010\u0006E\u0005c\u0001\u0016\u0002z%\u0019\u00111P\u000e\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011\u0011Q\u0001\u0002\u0018}3UKT\"`Q\u0015D\bO]\u0015![\u0001\u0012V\r^;s]N\u0004C\u000f[3!]Vl'-\u001a:!_\u001a\u0004#-\u001b;tAQD\u0017\r\u001e\u0011be\u0016\u00043/\u001a;!S:\u0004C\u000f[3!CJ<W/\\3oi\u0002*\u0007\u0010\u001d:!CN\u0004\u0013M\u001c\u0011v]NLwM\\3eAY\"TFY5uA%tG/Z4fe2\u0002sN\u001d\u0011O+2c\u0005%\u001b4!i\",\u0007%\u0019:hk6,g\u000e\u001e\u0011jg\u0002rU\u000b\u0014'/\u0003!)\u00070Y7qY\u0016\u001c\u0018EAAD\u0003QR\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006\u0006M\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AAR\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003\u001b\u000bQa\r\u00181]A\nQa\u001a:pkB\f#!a%\u0002\u001b\tLGo^5tK~3WO\\2t\u00031\u0011\u0015\u000e^<jg\u0016\u001cu.\u001e8u!\tQCc\u0005\u0003\u0015\u00037k\u0004CBAO\u0003G\u0013\u0005*\u0004\u0002\u0002 *\u0019\u0011\u0011U\u001d\u0002\u000fI,h\u000e^5nK&!\u0011QUAP\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g.\r\u000b\u0003\u0003/#\"!a\r\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007!\u000by\u000bC\u0003A/\u0001\u0007!)A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005U\u00161\u0018\t\u0005q\u0005]&)C\u0002\u0002:f\u0012aa\u00149uS>t\u0007\u0002CA_1\u0005\u0005\t\u0019\u0001%\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GCAAb!\u0011\t)$!2\n\t\u0005\u001d\u0017q\u0007\u0002\u0007\u001f\nTWm\u0019;")
public class BitwiseCount
extends UnaryExpression
implements ExpectsInputTypes,
package.NullIntolerant,
scala.Serializable {
    private final Expression child;

    public static Option<Expression> unapply(BitwiseCount bitwiseCount) {
        return BitwiseCount$.MODULE$.unapply(bitwiseCount);
    }

    public static <A> Function1<Expression, A> andThen(Function1<BitwiseCount, A> function1) {
        return BitwiseCount$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, BitwiseCount> compose(Function1<A, Expression> function1) {
        return BitwiseCount$.MODULE$.compose(function1);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{IntegralType$.MODULE$, BooleanType$.MODULE$})), (List)Nil$.MODULE$);
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public String toString() {
        return new StringBuilder(11).append("bit_count(").append(this.child()).append(")").toString();
    }

    @Override
    public String prettyName() {
        return "bit_count";
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        DataType dataType = this.child().dataType();
        ExprCode exprCode = BooleanType$.MODULE$.equals(dataType) ? this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> new StringBuilder(14).append("if (").append((String)c).append(") 1 else 0").toString()) : this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> new StringBuilder(25).append("java.lang.Long.bitCount(").append((String)c).append(")").toString());
        return exprCode;
    }

    @Override
    public Object nullSafeEval(Object input) {
        Integer n;
        DataType dataType = this.child().dataType();
        if (BooleanType$.MODULE$.equals(dataType)) {
            n = BoxesRunTime.unboxToBoolean((Object)input) ? BoxesRunTime.boxToInteger((int)1) : BoxesRunTime.boxToInteger((int)0);
        } else if (ByteType$.MODULE$.equals(dataType)) {
            n = BoxesRunTime.boxToInteger((int)Long.bitCount(BoxesRunTime.unboxToByte((Object)input)));
        } else if (ShortType$.MODULE$.equals(dataType)) {
            n = BoxesRunTime.boxToInteger((int)Long.bitCount(BoxesRunTime.unboxToShort((Object)input)));
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            n = BoxesRunTime.boxToInteger((int)Long.bitCount(BoxesRunTime.unboxToInt((Object)input)));
        } else if (LongType$.MODULE$.equals(dataType)) {
            n = BoxesRunTime.boxToInteger((int)Long.bitCount(BoxesRunTime.unboxToLong((Object)input)));
        } else {
            throw new MatchError((Object)dataType);
        }
        return n;
    }

    @Override
    public BitwiseCount withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public BitwiseCount copy(Expression child) {
        return new BitwiseCount(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "BitwiseCount";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return this.child();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof BitwiseCount;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof BitwiseCount)) return false;
        boolean bl = true;
        if (!bl) return false;
        BitwiseCount bitwiseCount = (BitwiseCount)x$1;
        Expression expression = this.child();
        Expression expression2 = bitwiseCount.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!bitwiseCount.canEqual(this)) return false;
        return true;
    }

    public BitwiseCount(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
    }
}

