/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ArrayBasedSimpleHigherOrderFunction;
import org.apache.spark.sql.catalyst.expressions.ArraySort$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.HigherOrderFunction;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.NamedLambdaVariable;
import org.apache.spark.sql.catalyst.expressions.SimpleHigherOrderFunction;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.BinaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.NullType$;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr, func) - Sorts the input array. If func is omitted, sort\n    in ascending order. The elements of the input array must be orderable.\n    NaN is greater than any non-NaN elements for double/float type.\n    Null elements will be placed at the end of the returned array.\n    Since 3.0.0 this function also sorts and returns the array based on the\n    given comparator function. The comparator will take two arguments representing\n    two elements of the array.\n    It returns a negative integer, 0, or a positive integer as the first element is less than,\n    equal to, or greater than the second element. If the comparator function returns null,\n    the function will fail and raise an error.\n    ", examples="\n    Examples:\n      > SELECT _FUNC_(array(5, 6, 1), (left, right) -> case when left < right then -1 when left > right then 1 else 0 end);\n       [1,5,6]\n      > SELECT _FUNC_(array('bc', 'ab', 'dc'), (left, right) -> case when left is null and right is null then 0 when left is null then -1 when right is null then 1 when left < right then 1 when left > right then -1 else 0 end);\n       [\"dc\",\"bc\",\"ab\"]\n      > SELECT _FUNC_(array('b', 'd', null, 'c', 'a'));\n       [\"a\",\"b\",\"c\",\"d\",null]\n  ", since="2.4.0", group="lambda_funcs")
@ScalaSignature(bytes="\u0006\u0001\t\u0015d\u0001B\u0015+\u0001^B\u0001B\u0014\u0001\u0003\u0016\u0004%\ta\u0014\u0005\t!\u0002\u0011\t\u0012)A\u0005q!A\u0011\u000b\u0001BK\u0002\u0013\u0005q\n\u0003\u0005S\u0001\tE\t\u0015!\u00039\u0011!\u0019\u0006A!f\u0001\n\u0003!\u0006\u0002\u0003-\u0001\u0005#\u0005\u000b\u0011B+\t\u000be\u0003A\u0011\u0001.\t\u000be\u0003A\u0011A0\t\u000be\u0003A\u0011\u00012\t\u0011\u0011\u0004\u0001R1A\u0005\u0002\u0015DQ\u0001\u001d\u0001\u0005BEDQ!\u001e\u0001\u0005BYDQ! \u0001\u0005ByDA\"!\f\u0001!\u0003E9\u0019)C\u0005\u0003_A!\"!\u000f\u0001\u0011\u000b\u0007I\u0011AA\u001e\u0011)\ty\u0004\u0001EC\u0002\u0013\u0005\u00111\b\u0005\b\u0003\u0007\u0002A\u0011AA#\u0011\u001d\tI\u0007\u0001C!\u0003WBq!a\u001d\u0001\t\u0003\n)\bC\u0004\u0002\b\u0002!\t&!#\t\u0013\u0005M\u0005!!A\u0005\u0002\u0005U\u0005\"CAO\u0001E\u0005I\u0011AAP\u0011%\t)\fAI\u0001\n\u0003\ty\nC\u0005\u00028\u0002\t\n\u0011\"\u0001\u0002:\"I\u0011Q\u0018\u0001\u0002\u0002\u0013\u0005\u0013q\u0018\u0005\n\u0003\u0017\u0004\u0011\u0011!C\u0001\u0003\u001bD\u0011\"!6\u0001\u0003\u0003%\t!a6\t\u0013\u0005u\u0007!!A\u0005B\u0005}\u0007\"CAw\u0001\u0005\u0005I\u0011AAx\u0011%\t\u0019\u0010AA\u0001\n\u0003\n)pB\u0004\u0003\u001a)B\tAa\u0007\u0007\r%R\u0003\u0012\u0001B\u000f\u0011\u0019I\u0006\u0005\"\u0001\u0003&!9!q\u0005\u0011\u0005\u0002\t%\u0002bBA\"A\u0011\u0005!q\u0006\u0005\n\u0005s\u0001#\u0019!C\u0001\u0005wA\u0001B!\u0010!A\u0003%\u0011q\u0005\u0005\n\u0005O\u0001\u0013\u0011!CA\u0005\u007fA\u0011Ba\u0012!\u0003\u0003%\tI!\u0013\t\u0013\tm\u0003%!A\u0005\n\tu#!C!se\u0006L8k\u001c:u\u0015\tYC&A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0017/\u0003!\u0019\u0017\r^1msN$(BA\u00181\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003cI\nQa\u001d9be.T!a\r\u001b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0014aA8sO\u000e\u00011C\u0002\u00019y}*5\n\u0005\u0002:u5\t!&\u0003\u0002<U\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005ej\u0014B\u0001 +\u0005\r\n%O]1z\u0005\u0006\u001cX\rZ*j[BdW\rS5hQ\u0016\u0014xJ\u001d3fe\u001a+hn\u0019;j_:\u0004\"\u0001Q\"\u000e\u0003\u0005S!A\u0011\u0016\u0002\u000f\r|G-Z4f]&\u0011A)\u0011\u0002\u0010\u0007>$WmZ3o\r\u0006dGNY1dWB\u0011a)S\u0007\u0002\u000f*\t\u0001*A\u0003tG\u0006d\u0017-\u0003\u0002K\u000f\n9\u0001K]8ek\u000e$\bC\u0001$M\u0013\tiuI\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0005be\u001e,X.\u001a8u+\u0005A\u0014!C1sOVlWM\u001c;!\u0003!1WO\\2uS>t\u0017!\u00034v]\u000e$\u0018n\u001c8!\u0003e\tG\u000e\\8x\u001dVdGnQ8na\u0006\u0014\u0018n]8o%\u0016\u001cX\u000f\u001c;\u0016\u0003U\u0003\"A\u0012,\n\u0005];%a\u0002\"p_2,\u0017M\\\u0001\u001bC2dwn\u001e(vY2\u001cu.\u001c9be&\u001cxN\u001c*fgVdG\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\tmcVL\u0018\t\u0003s\u0001AQAT\u0004A\u0002aBQ!U\u0004A\u0002aBQaU\u0004A\u0002U#2a\u00171b\u0011\u0015q\u0005\u00021\u00019\u0011\u0015\t\u0006\u00021\u00019)\tY6\rC\u0003O\u0013\u0001\u0007\u0001(A\u0006fY\u0016lWM\u001c;UsB,W#\u00014\u0011\u0005\u001dTW\"\u00015\u000b\u0005%t\u0013!\u0002;za\u0016\u001c\u0018BA6i\u0005!!\u0015\r^1UsB,\u0007F\u0001\u0006n!\t1e.\u0003\u0002p\u000f\nIAO]1og&,g\u000e^\u0001\tI\u0006$\u0018\rV=qKV\t!\u000f\u0005\u0002hg&\u0011A\u000f\u001b\u0002\n\u0003J\u0014\u0018-\u001f+za\u0016\f1c\u00195fG.Le\u000e];u\t\u0006$\u0018\rV=qKN$\u0012a\u001e\t\u0003qnl\u0011!\u001f\u0006\u0003u2\n\u0001\"\u00198bYf\u001c\u0018n]\u0005\u0003yf\u0014q\u0002V=qK\u000eCWmY6SKN,H\u000e^\u0001\u0005E&tG\r\u0006\u0002\\\u007f\"9\u0011\u0011A\u0007A\u0002\u0005\r\u0011!\u00014\u0011\u0011\u0019\u000b)\u0001OA\u0005\u0003OI1!a\u0002H\u0005%1UO\\2uS>t'\u0007\u0005\u0004\u0002\f\u0005m\u0011\u0011\u0005\b\u0005\u0003\u001b\t9B\u0004\u0003\u0002\u0010\u0005UQBAA\t\u0015\r\t\u0019BN\u0001\u0007yI|w\u000e\u001e \n\u0003!K1!!\u0007H\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\b\u0002 \t\u00191+Z9\u000b\u0007\u0005eq\tE\u0003G\u0003G1W+C\u0002\u0002&\u001d\u0013a\u0001V;qY\u0016\u0014\u0004cA\u001d\u0002*%\u0019\u00111\u0006\u0016\u0003\u001d1\u000bWN\u00193b\rVt7\r^5p]\u0006!\u0001\u0010\n\u001a2+\t\t\t\u0004E\u0004G\u0003G\t\u0019$a\r\u0011\u0007e\n)$C\u0002\u00028)\u00121CT1nK\u0012d\u0015-\u001c2eCZ\u000b'/[1cY\u0016\fABZ5sgR,E.Z7WCJ,\"!a\r)\u0005=i\u0017!D:fG>tG-\u00127f[Z\u000b'\u000f\u000b\u0002\u0011[\u0006Q1m\\7qCJ\fGo\u001c:\u0015\t\u0005\u001d\u0013Q\f\t\u0007\u0003\u0013\n\u0019&a\u0016\u000e\u0005\u0005-#\u0002BA'\u0003\u001f\nA!\u001e;jY*\u0011\u0011\u0011K\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002V\u0005-#AC\"p[B\f'/\u0019;peB\u0019a)!\u0017\n\u0007\u0005msIA\u0002B]fDq!a\u0018\u0012\u0001\u0004\t\t'\u0001\u0005j]B,HOU8x!\u0011\t\u0019'!\u001a\u000e\u00031J1!a\u001a-\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\r\u0005]\u0013QNA8\u0011\u001d\tyF\u0005a\u0001\u0003CBq!!\u001d\u0013\u0001\u0004\t9&A\u0007be\u001e,X.\u001a8u-\u0006dW/Z\u0001\u000baJ,G\u000f^=OC6,WCAA<!\u0011\tI(!!\u000f\t\u0005m\u0014Q\u0010\t\u0004\u0003\u001f9\u0015bAA@\u000f\u00061\u0001K]3eK\u001aLA!a!\u0002\u0006\n11\u000b\u001e:j]\u001eT1!a H\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0003\\\u0003\u0017\u000by\t\u0003\u0004\u0002\u000eR\u0001\r\u0001O\u0001\b]\u0016<H*\u001a4u\u0011\u0019\t\t\n\u0006a\u0001q\u0005Aa.Z<SS\u001eDG/\u0001\u0003d_BLHcB.\u0002\u0018\u0006e\u00151\u0014\u0005\b\u001dV\u0001\n\u00111\u00019\u0011\u001d\tV\u0003%AA\u0002aBqaU\u000b\u0011\u0002\u0003\u0007Q+\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\u0005&f\u0001\u001d\u0002$.\u0012\u0011Q\u0015\t\u0005\u0003O\u000b\t,\u0004\u0002\u0002**!\u00111VAW\u0003%)hn\u00195fG.,GMC\u0002\u00020\u001e\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019,!+\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u00111\u0018\u0016\u0004+\u0006\r\u0016!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002BB!\u00111YAe\u001b\t\t)M\u0003\u0003\u0002H\u0006=\u0013\u0001\u00027b]\u001eLA!a!\u0002F\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011q\u001a\t\u0004\r\u0006E\u0017bAAj\u000f\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011qKAm\u0011%\tYnGA\u0001\u0002\u0004\ty-A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003C\u0004b!a9\u0002j\u0006]SBAAs\u0015\r\t9oR\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAv\u0003K\u0014\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019Q+!=\t\u0013\u0005mW$!AA\u0002\u0005]\u0013AB3rk\u0006d7\u000fF\u0002V\u0003oD\u0011\"a7\u001f\u0003\u0003\u0005\r!a\u0016)'\u0001\tYP!\u0001\u0003\u0004\t\u001d!\u0011\u0002B\u0007\u0005\u001f\u0011\u0019B!\u0006\u0011\u0007e\ni0C\u0002\u0002\u0000*\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0003\u0006\u0005))i\u0018$V\u001d\u000e{\u0006&\u001a=qe2\u0002c-\u001e8dS\u0001j\u0003eU8siN\u0004C\u000f[3!S:\u0004X\u000f\u001e\u0011beJ\f\u0017P\f\u0011JM\u00022WO\\2!SN\u0004s.\\5ui\u0016$G\u0006I:peRT\u0001\u0005\t\u0011!S:\u0004\u0013m]2f]\u0012Lgn\u001a\u0011pe\u0012,'O\f\u0011UQ\u0016\u0004S\r\\3nK:$8\u000fI8gAQDW\rI5oaV$\b%\u0019:sCf\u0004S.^:uA\t,\u0007e\u001c:eKJ\f'\r\\3/\u0015\u0001\u0002\u0003\u0005\t(b\u001d\u0002J7\u000fI4sK\u0006$XM\u001d\u0011uQ\u0006t\u0007%\u00198zA9|g.\f(b\u001d\u0002*G.Z7f]R\u001c\bEZ8sA\u0011|WO\u00197f_\u0019dw.\u0019;!if\u0004XM\f\u0006!A\u0001\u0002c*\u001e7mA\u0015dW-\\3oiN\u0004s/\u001b7mA\t,\u0007\u0005\u001d7bG\u0016$\u0007%\u0019;!i\",\u0007%\u001a8eA=4\u0007\u0005\u001e5fAI,G/\u001e:oK\u0012\u0004\u0013M\u001d:bs:R\u0001\u0005\t\u0011!'&t7-\u001a\u00114]Ar\u0003\u0007\t;iSN\u0004c-\u001e8di&|g\u000eI1mg>\u00043o\u001c:ug\u0002\ng\u000e\u001a\u0011sKR,(O\\:!i\",\u0007%\u0019:sCf\u0004#-Y:fI\u0002zg\u000e\t;iK*\u0001\u0003\u0005\t\u0011hSZ,g\u000eI2p[B\f'/\u0019;pe\u00022WO\\2uS>tg\u0006\t+iK\u0002\u001aw.\u001c9be\u0006$xN\u001d\u0011xS2d\u0007\u0005^1lK\u0002\"xo\u001c\u0011be\u001e,X.\u001a8ug\u0002\u0012X\r\u001d:fg\u0016tG/\u001b8h\u0015\u0001\u0002\u0003\u0005\t;x_\u0002*G.Z7f]R\u001c\be\u001c4!i\",\u0007%\u0019:sCft#\u0002\t\u0011!A%#\bE]3ukJt7\u000fI1!]\u0016<\u0017\r^5wK\u0002Jg\u000e^3hKJd\u0003\u0005\r\u0017!_J\u0004\u0013\r\t9pg&$\u0018N^3!S:$XmZ3sA\u0005\u001c\b\u0005\u001e5fA\u0019L'o\u001d;!K2,W.\u001a8uA%\u001c\b\u0005\\3tg\u0002\"\b.\u00198-\u0015\u0001\u0002\u0003\u0005I3rk\u0006d\u0007\u0005^8-A=\u0014\be\u001a:fCR,'\u000f\t;iC:\u0004C\u000f[3!g\u0016\u001cwN\u001c3!K2,W.\u001a8u]\u0001Je\r\t;iK\u0002\u001aw.\u001c9be\u0006$xN\u001d\u0011gk:\u001cG/[8oAI,G/\u001e:og\u0002rW\u000f\u001c7-\u0015\u0001\u0002\u0003\u0005\t;iK\u00022WO\\2uS>t\u0007e^5mY\u00022\u0017-\u001b7!C:$\u0007E]1jg\u0016\u0004\u0013M\u001c\u0011feJ|'O\f\u0006!A\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\t-\u0011a!8\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u0005\u0014(/Y=)k1\u0002c\u0007\f\u00112S1\u0002\u0003\u0006\\3gi2\u0002#/[4ii&\u0002SF\u0010\u0011dCN,\u0007e\u001e5f]\u0002bWM\u001a;!y\u0001\u0012\u0018n\u001a5uAQDWM\u001c\u0011.c\u0001:\b.\u001a8!Y\u00164G\u000f\t !e&<\u0007\u000e\u001e\u0011uQ\u0016t\u0007%\r\u0011fYN,\u0007\u0005\r\u0011f]\u0012L3H\u0003\u0011!A\u0001\u0002\u0003\u0005I.2YUbc'\u0018\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)CJ\u0014\u0018-\u001f\u0015(E\u000e<C\u0006I\u0014bE\u001eb\u0003e\n3dO%b\u0003\u0005\u000b7fMRd\u0003E]5hQRL\u0003%\f !G\u0006\u001cX\rI<iK:\u0004C.\u001a4uA%\u001c\bE\\;mY\u0002\ng\u000e\u001a\u0011sS\u001eDG\u000fI5tA9,H\u000e\u001c\u0011uQ\u0016t\u0007\u0005\r\u0011xQ\u0016t\u0007\u0005\\3gi\u0002J7\u000f\t8vY2\u0004C\u000f[3oA5\n\u0004e\u001e5f]\u0002\u0012\u0018n\u001a5uA%\u001c\bE\\;mY\u0002\"\b.\u001a8!c\u0001:\b.\u001a8!Y\u00164G\u000f\t\u001f!e&<\u0007\u000e\u001e\u0011uQ\u0016t\u0007%\r\u0011xQ\u0016t\u0007\u0005\\3gi\u0002r\u0004E]5hQR\u0004C\u000f[3oA5\n\u0004%\u001a7tK\u0002\u0002\u0004%\u001a8eSmR\u0001\u0005\t\u0011!A\u0001\u00023L\t3dE1\u0012#m\u0019\u0012-E\u0005\u0014'%\u0018\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)CJ\u0014\u0018-\u001f\u0015(E\u001eb\u0003e\n3(Y\u0001rW\u000f\u001c7-A\u001d\u001aw\u0005\f\u0011(C\u001eJ\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011\\E\u0005\u0014CF\t2#Y\t\u001a'\u0005\f\u0012eE1rW\u000f\u001c7^\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017E\u0001B\t\u0003\u0015\u0011d\u0006\u000e\u00181\u0003\u00159'o\\;qC\t\u00119\"\u0001\u0007mC6\u0014G-Y0gk:\u001c7/A\u0005BeJ\f\u0017pU8siB\u0011\u0011\bI\n\u0005A\t}1\nE\u0002G\u0005CI1Aa\tH\u0005\u0019\te.\u001f*fMR\u0011!1D\u0001\u0006CB\u0004H.\u001f\u000b\u00067\n-\"Q\u0006\u0005\u0006\u001d\n\u0002\r\u0001\u000f\u0005\u0006#\n\u0002\r\u0001\u000f\u000b\u0006q\tE\"Q\u0007\u0005\u0007\u0005g\u0019\u0003\u0019\u0001\u001d\u0002\t1,g\r\u001e\u0005\u0007\u0005o\u0019\u0003\u0019\u0001\u001d\u0002\u000bILw\r\u001b;\u0002#\u0011,g-Y;mi\u000e{W\u000e]1sCR|'/\u0006\u0002\u0002(\u0005\u0011B-\u001a4bk2$8i\\7qCJ\fGo\u001c:!)\u001dY&\u0011\tB\"\u0005\u000bBQA\u0014\u0014A\u0002aBQ!\u0015\u0014A\u0002aBQa\u0015\u0014A\u0002U\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003L\t]\u0003#\u0002$\u0003N\tE\u0013b\u0001B(\u000f\n1q\n\u001d;j_:\u0004bA\u0012B*qa*\u0016b\u0001B+\u000f\n1A+\u001e9mKNB\u0001B!\u0017(\u0003\u0003\u0005\raW\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"Aa\u0018\u0011\t\u0005\r'\u0011M\u0005\u0005\u0005G\n)M\u0001\u0004PE*,7\r\u001e")
public class ArraySort
extends Expression
implements ArrayBasedSimpleHigherOrderFunction,
CodegenFallback,
Serializable {
    private transient DataType elementType;
    private Tuple2<NamedLambdaVariable, NamedLambdaVariable> x$21;
    private transient NamedLambdaVariable firstElemVar;
    private transient NamedLambdaVariable secondElemVar;
    private final Expression argument;
    private final Expression function;
    private final boolean allowNullComparisonResult;
    private transient Seq<Expression> children;
    private final Seq<Enumeration.Value> nodePatterns;
    private boolean argumentsResolved;
    private boolean resolved;
    private transient Seq<Expression> functionsForEval;
    private Expression canonicalized;
    private volatile transient byte bitmap$trans$0;
    private volatile byte bitmap$0;

    public static Option<Tuple3<Expression, Expression, Object>> unapply(ArraySort arraySort) {
        return ArraySort$.MODULE$.unapply(arraySort);
    }

    public static LambdaFunction defaultComparator() {
        return ArraySort$.MODULE$.defaultComparator();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public AbstractDataType argumentType() {
        return ArrayBasedSimpleHigherOrderFunction.argumentType$(this);
    }

    @Override
    public Seq<Expression> arguments() {
        return SimpleHigherOrderFunction.arguments$(this);
    }

    @Override
    public Seq<AbstractDataType> argumentTypes() {
        return SimpleHigherOrderFunction.argumentTypes$(this);
    }

    @Override
    public Seq<Expression> functions() {
        return SimpleHigherOrderFunction.functions$(this);
    }

    @Override
    public AbstractDataType functionType() {
        return SimpleHigherOrderFunction.functionType$(this);
    }

    @Override
    public Seq<AbstractDataType> functionTypes() {
        return SimpleHigherOrderFunction.functionTypes$(this);
    }

    @Override
    public Expression functionForEval() {
        return SimpleHigherOrderFunction.functionForEval$(this);
    }

    @Override
    public Expression left() {
        return SimpleHigherOrderFunction.left$(this);
    }

    @Override
    public Expression right() {
        return SimpleHigherOrderFunction.right$(this);
    }

    @Override
    public Object eval(InternalRow inputRow) {
        return SimpleHigherOrderFunction.eval$(this, inputRow);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return BinaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return BinaryLike.withNewChildrenInternal$(this, newChildren);
    }

    @Override
    public boolean nullable() {
        return HigherOrderFunction.nullable$(this);
    }

    @Override
    public TypeCheckResult checkArgumentDataTypes() {
        return HigherOrderFunction.checkArgumentDataTypes$(this);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return HigherOrderFunction.inputTypes$(this);
    }

    private Seq<Expression> children$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.children = BinaryLike.children$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.children$lzycompute() : this.children;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private boolean argumentsResolved$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.argumentsResolved = HigherOrderFunction.argumentsResolved$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.argumentsResolved;
    }

    @Override
    public boolean argumentsResolved() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.argumentsResolved$lzycompute() : this.argumentsResolved;
    }

    private boolean resolved$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.resolved = HigherOrderFunction.resolved$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.resolved$lzycompute() : this.resolved;
    }

    private Seq<Expression> functionsForEval$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
                this.functionsForEval = HigherOrderFunction.functionsForEval$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x10);
            }
        }
        return this.functionsForEval;
    }

    @Override
    public Seq<Expression> functionsForEval() {
        return (byte)(this.bitmap$trans$0 & 0x10) == 0 ? this.functionsForEval$lzycompute() : this.functionsForEval;
    }

    private Expression canonicalized$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.canonicalized = HigherOrderFunction.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.canonicalized$lzycompute() : this.canonicalized;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$HigherOrderFunction$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    @Override
    public Expression argument() {
        return this.argument;
    }

    @Override
    public Expression function() {
        return this.function;
    }

    public boolean allowNullComparisonResult() {
        return this.allowNullComparisonResult;
    }

    private DataType elementType$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.elementType = ((ArrayType)this.argument().dataType()).elementType();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.elementType;
    }

    public DataType elementType() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.elementType$lzycompute() : this.elementType;
    }

    @Override
    public ArrayType dataType() {
        return (ArrayType)this.argument().dataType();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult typeCheckResult;
        TypeCheckResult typeCheckResult2 = this.checkArgumentDataTypes();
        if (TypeCheckResult$TypeCheckSuccess$.MODULE$.equals(typeCheckResult2)) {
            TypeCheckResult typeCheckResult3;
            DataType dataType = this.argument().dataType();
            if (dataType instanceof ArrayType) {
                DataType dataType2 = this.function().dataType();
                IntegerType$ integerType$ = IntegerType$.MODULE$;
                typeCheckResult3 = !(dataType2 != null ? !dataType2.equals(integerType$) : integerType$ != null) ? TypeCheckResult$TypeCheckSuccess$.MODULE$ : new TypeCheckResult.TypeCheckFailure("Return type of the given function has to be IntegerType");
            } else {
                typeCheckResult3 = new TypeCheckResult.TypeCheckFailure(new StringBuilder(27).append(this.prettyName()).append(" only supports array input.").toString());
            }
            typeCheckResult = typeCheckResult3;
        } else {
            typeCheckResult = typeCheckResult2;
        }
        return typeCheckResult;
    }

    @Override
    public ArraySort bind(Function2<Expression, Seq<Tuple2<DataType, Object>>, LambdaFunction> f) {
        DataType dataType = this.argument().dataType();
        if (!(dataType instanceof ArrayType)) {
            throw new MatchError((Object)dataType);
        }
        ArrayType arrayType = (ArrayType)dataType;
        DataType elementType = arrayType.elementType();
        boolean containsNull = arrayType.containsNull();
        Tuple2 tuple2 = new Tuple2((Object)elementType, (Object)BoxesRunTime.boxToBoolean((boolean)containsNull));
        Tuple2 tuple22 = tuple2;
        DataType elementType2 = (DataType)tuple22._1();
        boolean containsNull2 = tuple22._2$mcZ$sp();
        Tuple2 tuple23 = new Tuple2((Object)elementType2, (Object)BoxesRunTime.boxToBoolean((boolean)containsNull2));
        Tuple2 tuple24 = new Tuple2((Object)elementType2, (Object)BoxesRunTime.boxToBoolean((boolean)containsNull2));
        LambdaFunction x$1 = (LambdaFunction)f.apply((Object)this.function(), (Object)Nil$.MODULE$.$colon$colon((Object)tuple24).$colon$colon((Object)tuple23));
        Expression x$2 = this.copy$default$1();
        boolean x$3 = this.copy$default$3();
        return this.copy(x$2, x$1, x$3);
    }

    private Tuple2<NamedLambdaVariable, NamedLambdaVariable> x$21$lzycompute() {
        block5: {
            ArraySort arraySort = this;
            synchronized (arraySort) {
                NamedLambdaVariable namedLambdaVariable;
                NamedExpression secondElemVar;
                block7: {
                    Expression expression;
                    block6: {
                        LambdaFunction lambdaFunction;
                        Seq<NamedExpression> seq;
                        Some some;
                        if ((byte)(this.bitmap$0 & 1) != 0) break block5;
                        expression = this.function();
                        if (!(expression instanceof LambdaFunction) || (some = Seq$.MODULE$.unapplySeq(seq = (lambdaFunction = (LambdaFunction)expression).arguments())).isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) break block6;
                        NamedExpression firstElemVar = (NamedExpression)((SeqLike)some.get()).apply(0);
                        secondElemVar = (NamedExpression)((SeqLike)some.get()).apply(1);
                        if (!(firstElemVar instanceof NamedLambdaVariable)) break block6;
                        namedLambdaVariable = (NamedLambdaVariable)firstElemVar;
                        if (secondElemVar instanceof NamedLambdaVariable) break block7;
                    }
                    throw new MatchError((Object)expression);
                }
                NamedLambdaVariable namedLambdaVariable2 = (NamedLambdaVariable)secondElemVar;
                Tuple2 tuple2 = new Tuple2((Object)namedLambdaVariable, (Object)namedLambdaVariable2);
                this.x$21 = tuple2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.x$21;
    }

    private /* synthetic */ Tuple2 x$21() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.x$21$lzycompute() : this.x$21;
    }

    private NamedLambdaVariable firstElemVar$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.firstElemVar = (NamedLambdaVariable)this.x$21()._1();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.firstElemVar;
    }

    public NamedLambdaVariable firstElemVar() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.firstElemVar$lzycompute() : this.firstElemVar;
    }

    private NamedLambdaVariable secondElemVar$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.secondElemVar = (NamedLambdaVariable)this.x$21()._2();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.secondElemVar;
    }

    public NamedLambdaVariable secondElemVar() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.secondElemVar$lzycompute() : this.secondElemVar;
    }

    public Comparator<Object> comparator(InternalRow inputRow) {
        Expression f = this.functionForEval();
        return (o1, o2) -> {
            this.firstElemVar().value().set(o1);
            this.secondElemVar().value().set(o2);
            Object cmp = f.eval(inputRow);
            if (!this.allowNullComparisonResult() && cmp == null) {
                throw QueryExecutionErrors$.MODULE$.nullComparisonResultError();
            }
            return BoxesRunTime.unboxToInt((Object)cmp);
        };
    }

    @Override
    public Object nullSafeEval(InternalRow inputRow, Object argumentValue) {
        Object[] arr = (Object[])((ArrayData)argumentValue).toArray(this.elementType(), ClassTag$.MODULE$.AnyRef());
        DataType dataType = this.elementType();
        NullType$ nullType$ = NullType$.MODULE$;
        if (dataType == null ? nullType$ != null : !dataType.equals(nullType$)) {
            Arrays.sort(arr, this.comparator(inputRow));
        }
        return new GenericArrayData(arr);
    }

    @Override
    public String prettyName() {
        return "array_sort";
    }

    @Override
    public ArraySort withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3());
    }

    public ArraySort copy(Expression argument, Expression function, boolean allowNullComparisonResult) {
        return new ArraySort(argument, function, allowNullComparisonResult);
    }

    public Expression copy$default$1() {
        return this.argument();
    }

    public Expression copy$default$2() {
        return this.function();
    }

    public boolean copy$default$3() {
        return this.allowNullComparisonResult();
    }

    @Override
    public String productPrefix() {
        return "ArraySort";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.argument();
                break;
            }
            case 1: {
                object = this.function();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.allowNullComparisonResult());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArraySort;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArraySort)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArraySort arraySort = (ArraySort)x$1;
        Expression expression = this.argument();
        Expression expression2 = arraySort.argument();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.function();
        Expression expression4 = arraySort.function();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (this.allowNullComparisonResult() != arraySort.allowNullComparisonResult()) return false;
        if (!arraySort.canEqual(this)) return false;
        return true;
    }

    public ArraySort(Expression argument, Expression function, boolean allowNullComparisonResult) {
        this.argument = argument;
        this.function = function;
        this.allowNullComparisonResult = allowNullComparisonResult;
        ExpectsInputTypes.$init$(this);
        HigherOrderFunction.$init$(this);
        BinaryLike.$init$(this);
        SimpleHigherOrderFunction.$init$(this);
        ArrayBasedSimpleHigherOrderFunction.$init$(this);
        CodegenFallback.$init$(this);
    }

    public ArraySort(Expression argument, Expression function) {
        this(argument, function, BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.LEGACY_ALLOW_NULL_COMPARISON_RESULT_IN_ARRAY_SORT())));
    }

    public ArraySort(Expression argument) {
        this(argument, ArraySort$.MODULE$.defaultComparator());
    }
}

