/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

#include "terminal/palette.h"

const guac_terminal_color GUAC_TERMINAL_INITIAL_PALETTE[256] = {

    /* Normal colors */
    {0, 0x00, 0x00, 0x00}, /* Black   */
    {1, 0x99, 0x3E, 0x3E}, /* Red     */
    {2, 0x3E, 0x99, 0x3E}, /* Green   */
    {3, 0x99, 0x99, 0x3E}, /* Brown   */
    {4, 0x3E, 0x3E, 0x99}, /* Blue    */
    {5, 0x99, 0x3E, 0x99}, /* Magenta */
    {6, 0x3E, 0x99, 0x99}, /* Cyan    */
    {7, 0x99, 0x99, 0x99}, /* White   */

    /* Intense colors */
    {8,  0x3E, 0x3E, 0x3E}, /* Black   */
    {9,  0xFF, 0x67, 0x67}, /* Red     */
    {10, 0x67, 0xFF, 0x67}, /* Green   */
    {11, 0xFF, 0xFF, 0x67}, /* Brown   */
    {12, 0x67, 0x67, 0xFF}, /* Blue    */
    {13, 0xFF, 0x67, 0xFF}, /* Magenta */
    {14, 0x67, 0xFF, 0xFF}, /* Cyan    */
    {15, 0xFF, 0xFF, 0xFF}, /* White   */

    /* Remainder of xterm's 256-color palette */
    {16,  0x00, 0x00, 0x00},
    {17,  0x00, 0x00, 0x5F},
    {18,  0x00, 0x00, 0x87},
    {19,  0x00, 0x00, 0xAF},
    {20,  0x00, 0x00, 0xD7},
    {21,  0x00, 0x00, 0xFF},
    {22,  0x00, 0x5F, 0x00},
    {23,  0x00, 0x5F, 0x5F},
    {24,  0x00, 0x5F, 0x87},
    {25,  0x00, 0x5F, 0xAF},
    {26,  0x00, 0x5F, 0xD7},
    {27,  0x00, 0x5F, 0xFF},
    {28,  0x00, 0x87, 0x00},
    {29,  0x00, 0x87, 0x5F},
    {30,  0x00, 0x87, 0x87},
    {31,  0x00, 0x87, 0xAF},
    {32,  0x00, 0x87, 0xD7},
    {33,  0x00, 0x87, 0xFF},
    {34,  0x00, 0xAF, 0x00},
    {35,  0x00, 0xAF, 0x5F},
    {36,  0x00, 0xAF, 0x87},
    {37,  0x00, 0xAF, 0xAF},
    {38,  0x00, 0xAF, 0xD7},
    {39,  0x00, 0xAF, 0xFF},
    {40,  0x00, 0xD7, 0x00},
    {41,  0x00, 0xD7, 0x5F},
    {42,  0x00, 0xD7, 0x87},
    {43,  0x00, 0xD7, 0xAF},
    {44,  0x00, 0xD7, 0xD7},
    {45,  0x00, 0xD7, 0xFF},
    {46,  0x00, 0xFF, 0x00},
    {47,  0x00, 0xFF, 0x5F},
    {48,  0x00, 0xFF, 0x87},
    {49,  0x00, 0xFF, 0xAF},
    {50,  0x00, 0xFF, 0xD7},
    {51,  0x00, 0xFF, 0xFF},
    {52,  0x5F, 0x00, 0x00},
    {53,  0x5F, 0x00, 0x5F},
    {54,  0x5F, 0x00, 0x87},
    {55,  0x5F, 0x00, 0xAF},
    {56,  0x5F, 0x00, 0xD7},
    {57,  0x5F, 0x00, 0xFF},
    {58,  0x5F, 0x5F, 0x00},
    {59,  0x5F, 0x5F, 0x5F},
    {60,  0x5F, 0x5F, 0x87},
    {61,  0x5F, 0x5F, 0xAF},
    {62,  0x5F, 0x5F, 0xD7},
    {63,  0x5F, 0x5F, 0xFF},
    {64,  0x5F, 0x87, 0x00},
    {65,  0x5F, 0x87, 0x5F},
    {66,  0x5F, 0x87, 0x87},
    {67,  0x5F, 0x87, 0xAF},
    {68,  0x5F, 0x87, 0xD7},
    {69,  0x5F, 0x87, 0xFF},
    {70,  0x5F, 0xAF, 0x00},
    {71,  0x5F, 0xAF, 0x5F},
    {72,  0x5F, 0xAF, 0x87},
    {73,  0x5F, 0xAF, 0xAF},
    {74,  0x5F, 0xAF, 0xD7},
    {75,  0x5F, 0xAF, 0xFF},
    {76,  0x5F, 0xD7, 0x00},
    {77,  0x5F, 0xD7, 0x5F},
    {78,  0x5F, 0xD7, 0x87},
    {79,  0x5F, 0xD7, 0xAF},
    {80,  0x5F, 0xD7, 0xD7},
    {81,  0x5F, 0xD7, 0xFF},
    {82,  0x5F, 0xFF, 0x00},
    {83,  0x5F, 0xFF, 0x5F},
    {84,  0x5F, 0xFF, 0x87},
    {85,  0x5F, 0xFF, 0xAF},
    {86,  0x5F, 0xFF, 0xD7},
    {87,  0x5F, 0xFF, 0xFF},
    {88,  0x87, 0x00, 0x00},
    {89,  0x87, 0x00, 0x5F},
    {90,  0x87, 0x00, 0x87},
    {91,  0x87, 0x00, 0xAF},
    {92,  0x87, 0x00, 0xD7},
    {93,  0x87, 0x00, 0xFF},
    {94,  0x87, 0x5F, 0x00},
    {95,  0x87, 0x5F, 0x5F},
    {96,  0x87, 0x5F, 0x87},
    {97,  0x87, 0x5F, 0xAF},
    {98,  0x87, 0x5F, 0xD7},
    {99,  0x87, 0x5F, 0xFF},
    {100, 0x87, 0x87, 0x00},
    {101, 0x87, 0x87, 0x5F},
    {102, 0x87, 0x87, 0x87},
    {103, 0x87, 0x87, 0xAF},
    {104, 0x87, 0x87, 0xD7},
    {105, 0x87, 0x87, 0xFF},
    {106, 0x87, 0xAF, 0x00},
    {107, 0x87, 0xAF, 0x5F},
    {108, 0x87, 0xAF, 0x87},
    {109, 0x87, 0xAF, 0xAF},
    {110, 0x87, 0xAF, 0xD7},
    {111, 0x87, 0xAF, 0xFF},
    {112, 0x87, 0xD7, 0x00},
    {113, 0x87, 0xD7, 0x5F},
    {114, 0x87, 0xD7, 0x87},
    {115, 0x87, 0xD7, 0xAF},
    {116, 0x87, 0xD7, 0xD7},
    {117, 0x87, 0xD7, 0xFF},
    {118, 0x87, 0xFF, 0x00},
    {119, 0x87, 0xFF, 0x5F},
    {120, 0x87, 0xFF, 0x87},
    {121, 0x87, 0xFF, 0xAF},
    {122, 0x87, 0xFF, 0xD7},
    {123, 0x87, 0xFF, 0xFF},
    {124, 0xAF, 0x00, 0x00},
    {125, 0xAF, 0x00, 0x5F},
    {126, 0xAF, 0x00, 0x87},
    {127, 0xAF, 0x00, 0xAF},
    {128, 0xAF, 0x00, 0xD7},
    {129, 0xAF, 0x00, 0xFF},
    {130, 0xAF, 0x5F, 0x00},
    {131, 0xAF, 0x5F, 0x5F},
    {132, 0xAF, 0x5F, 0x87},
    {133, 0xAF, 0x5F, 0xAF},
    {134, 0xAF, 0x5F, 0xD7},
    {135, 0xAF, 0x5F, 0xFF},
    {136, 0xAF, 0x87, 0x00},
    {137, 0xAF, 0x87, 0x5F},
    {138, 0xAF, 0x87, 0x87},
    {139, 0xAF, 0x87, 0xAF},
    {140, 0xAF, 0x87, 0xD7},
    {141, 0xAF, 0x87, 0xFF},
    {142, 0xAF, 0xAF, 0x00},
    {143, 0xAF, 0xAF, 0x5F},
    {144, 0xAF, 0xAF, 0x87},
    {145, 0xAF, 0xAF, 0xAF},
    {146, 0xAF, 0xAF, 0xD7},
    {147, 0xAF, 0xAF, 0xFF},
    {148, 0xAF, 0xD7, 0x00},
    {149, 0xAF, 0xD7, 0x5F},
    {150, 0xAF, 0xD7, 0x87},
    {151, 0xAF, 0xD7, 0xAF},
    {152, 0xAF, 0xD7, 0xD7},
    {153, 0xAF, 0xD7, 0xFF},
    {154, 0xAF, 0xFF, 0x00},
    {155, 0xAF, 0xFF, 0x5F},
    {156, 0xAF, 0xFF, 0x87},
    {157, 0xAF, 0xFF, 0xAF},
    {158, 0xAF, 0xFF, 0xD7},
    {159, 0xAF, 0xFF, 0xFF},
    {160, 0xD7, 0x00, 0x00},
    {161, 0xD7, 0x00, 0x5F},
    {162, 0xD7, 0x00, 0x87},
    {163, 0xD7, 0x00, 0xAF},
    {164, 0xD7, 0x00, 0xD7},
    {165, 0xD7, 0x00, 0xFF},
    {166, 0xD7, 0x5F, 0x00},
    {167, 0xD7, 0x5F, 0x5F},
    {168, 0xD7, 0x5F, 0x87},
    {169, 0xD7, 0x5F, 0xAF},
    {170, 0xD7, 0x5F, 0xD7},
    {171, 0xD7, 0x5F, 0xFF},
    {172, 0xD7, 0x87, 0x00},
    {173, 0xD7, 0x87, 0x5F},
    {174, 0xD7, 0x87, 0x87},
    {175, 0xD7, 0x87, 0xAF},
    {176, 0xD7, 0x87, 0xD7},
    {177, 0xD7, 0x87, 0xFF},
    {178, 0xD7, 0xAF, 0x00},
    {179, 0xD7, 0xAF, 0x5F},
    {180, 0xD7, 0xAF, 0x87},
    {181, 0xD7, 0xAF, 0xAF},
    {182, 0xD7, 0xAF, 0xD7},
    {183, 0xD7, 0xAF, 0xFF},
    {184, 0xD7, 0xD7, 0x00},
    {185, 0xD7, 0xD7, 0x5F},
    {186, 0xD7, 0xD7, 0x87},
    {187, 0xD7, 0xD7, 0xAF},
    {188, 0xD7, 0xD7, 0xD7},
    {189, 0xD7, 0xD7, 0xFF},
    {190, 0xD7, 0xFF, 0x00},
    {191, 0xD7, 0xFF, 0x5F},
    {192, 0xD7, 0xFF, 0x87},
    {193, 0xD7, 0xFF, 0xAF},
    {194, 0xD7, 0xFF, 0xD7},
    {195, 0xD7, 0xFF, 0xFF},
    {196, 0xFF, 0x00, 0x00},
    {197, 0xFF, 0x00, 0x5F},
    {198, 0xFF, 0x00, 0x87},
    {199, 0xFF, 0x00, 0xAF},
    {200, 0xFF, 0x00, 0xD7},
    {201, 0xFF, 0x00, 0xFF},
    {202, 0xFF, 0x5F, 0x00},
    {203, 0xFF, 0x5F, 0x5F},
    {204, 0xFF, 0x5F, 0x87},
    {205, 0xFF, 0x5F, 0xAF},
    {206, 0xFF, 0x5F, 0xD7},
    {207, 0xFF, 0x5F, 0xFF},
    {208, 0xFF, 0x87, 0x00},
    {209, 0xFF, 0x87, 0x5F},
    {210, 0xFF, 0x87, 0x87},
    {211, 0xFF, 0x87, 0xAF},
    {212, 0xFF, 0x87, 0xD7},
    {213, 0xFF, 0x87, 0xFF},
    {214, 0xFF, 0xAF, 0x00},
    {215, 0xFF, 0xAF, 0x5F},
    {216, 0xFF, 0xAF, 0x87},
    {217, 0xFF, 0xAF, 0xAF},
    {218, 0xFF, 0xAF, 0xD7},
    {219, 0xFF, 0xAF, 0xFF},
    {220, 0xFF, 0xD7, 0x00},
    {221, 0xFF, 0xD7, 0x5F},
    {222, 0xFF, 0xD7, 0x87},
    {223, 0xFF, 0xD7, 0xAF},
    {224, 0xFF, 0xD7, 0xD7},
    {225, 0xFF, 0xD7, 0xFF},
    {226, 0xFF, 0xFF, 0x00},
    {227, 0xFF, 0xFF, 0x5F},
    {228, 0xFF, 0xFF, 0x87},
    {229, 0xFF, 0xFF, 0xAF},
    {230, 0xFF, 0xFF, 0xD7},
    {231, 0xFF, 0xFF, 0xFF},
    {232, 0x08, 0x08, 0x08},
    {233, 0x12, 0x12, 0x12},
    {234, 0x1C, 0x1C, 0x1C},
    {235, 0x26, 0x26, 0x26},
    {236, 0x30, 0x30, 0x30},
    {237, 0x3A, 0x3A, 0x3A},
    {238, 0x44, 0x44, 0x44},
    {239, 0x4E, 0x4E, 0x4E},
    {240, 0x58, 0x58, 0x58},
    {241, 0x62, 0x62, 0x62},
    {242, 0x6C, 0x6C, 0x6C},
    {243, 0x76, 0x76, 0x76},
    {244, 0x80, 0x80, 0x80},
    {245, 0x8A, 0x8A, 0x8A},
    {246, 0x94, 0x94, 0x94},
    {247, 0x9E, 0x9E, 0x9E},
    {248, 0xA8, 0xA8, 0xA8},
    {249, 0xB2, 0xB2, 0xB2},
    {250, 0xBC, 0xBC, 0xBC},
    {251, 0xC6, 0xC6, 0xC6},
    {252, 0xD0, 0xD0, 0xD0},
    {253, 0xDA, 0xDA, 0xDA},
    {254, 0xE4, 0xE4, 0xE4},
    {255, 0xEE, 0xEE, 0xEE}

};

int guac_terminal_colorcmp(const guac_terminal_color* a,
        const guac_terminal_color* b) {

    /* Compare palette index alone if not unknown */
    if (a->palette_index != -1 && b->palette_index != -1)
        return a->palette_index - b->palette_index;

    /* Consider red component highest order ... */
    if (a->red != b->red)
        return a->red - b->red;

    /* ... followed by green ... */
    if (a->green != b->green)
        return a->green - b->green;

    /* ... followed by blue */
    if (a->blue != b->blue)
        return a->blue - b->blue;

    /* If all components match, colors are equal */
    return 0;

}

