/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.vault.ksm.secret;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.keepersecurity.secretsManager.core.KeeperRecord;
import com.keepersecurity.secretsManager.core.KeeperSecrets;
import com.keepersecurity.secretsManager.core.Notation;
import com.keepersecurity.secretsManager.core.SecretsManager;
import com.keepersecurity.secretsManager.core.SecretsManagerOptions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.vault.ksm.conf.KsmConfigurationService;
import org.apache.guacamole.vault.ksm.secret.KsmRecordService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class KsmClient {
    private static final Logger logger = LoggerFactory.getLogger(KsmClient.class);
    @Inject
    private KsmConfigurationService confService;
    @Inject
    private KsmRecordService recordService;
    private static final String KEEPER_NOTATION_DOC_URL = "https://docs.keeper.io/secrets-manager/secrets-manager/about/keeper-notation";
    private static final Pattern KEEPER_FILE_NOTATION = Pattern.compile("^(keeper://)?[^/]*/file/.+");
    private static final long CACHE_INTERVAL = 5000L;
    private final ReadWriteLock cacheLock = new ReentrantReadWriteLock();
    private volatile long cacheTimestamp = 0L;
    private KeeperSecrets cachedSecrets = null;
    private final Map<String, KeeperRecord> cachedRecordsByUid = new HashMap<String, KeeperRecord>();
    private final Map<String, KeeperRecord> cachedRecordsByHost = new HashMap<String, KeeperRecord>();
    private final Set<String> cachedAmbiguousHosts = new HashSet<String>();
    private final Map<String, KeeperRecord> cachedRecordsByUsername = new HashMap<String, KeeperRecord>();
    private final Set<String> cachedAmbiguousUsernames = new HashSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateCache() throws GuacamoleException {
        long currentTime = System.currentTimeMillis();
        this.cacheLock.readLock().lock();
        try {
            if (currentTime - this.cacheTimestamp < 5000L) {
                return;
            }
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
        this.cacheLock.writeLock().lock();
        try {
            if (currentTime - this.cacheTimestamp < 5000L) {
                return;
            }
            KeeperSecrets secrets = SecretsManager.getSecrets((SecretsManagerOptions)this.confService.getSecretsManagerOptions());
            List records = secrets.getRecords();
            this.cachedSecrets = secrets;
            this.cachedRecordsByUid.clear();
            this.cachedAmbiguousHosts.clear();
            this.cachedRecordsByHost.clear();
            this.cachedAmbiguousUsernames.clear();
            this.cachedRecordsByUsername.clear();
            records.forEach(record -> {
                this.cachedRecordsByUid.put(record.getRecordUid(), (KeeperRecord)record);
                String hostname = this.recordService.getHostname((KeeperRecord)record);
                this.addRecordForHost((KeeperRecord)record, hostname);
                if (hostname == null) {
                    this.addRecordForLogin((KeeperRecord)record, this.recordService.getUsername((KeeperRecord)record));
                }
            });
            this.cacheTimestamp = System.currentTimeMillis();
        }
        finally {
            this.cacheLock.writeLock().unlock();
        }
    }

    private void addRecordForHost(KeeperRecord record, String hostname) {
        if (hostname == null) {
            return;
        }
        KeeperRecord existing = this.cachedRecordsByHost.putIfAbsent(hostname, record);
        if (existing != null && record != existing) {
            this.cachedAmbiguousHosts.add(hostname);
        }
    }

    private void addRecordForLogin(KeeperRecord record, String username) {
        if (username == null) {
            return;
        }
        KeeperRecord existing = this.cachedRecordsByUsername.putIfAbsent(username, record);
        if (existing != null && record != existing) {
            this.cachedAmbiguousUsernames.add(username);
        }
    }

    public Collection<KeeperRecord> getRecords() throws GuacamoleException {
        this.validateCache();
        this.cacheLock.readLock().lock();
        try {
            Collection<KeeperRecord> collection = Collections.unmodifiableCollection(this.cachedRecordsByUid.values());
            return collection;
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
    }

    public KeeperRecord getRecord(String uid) throws GuacamoleException {
        this.validateCache();
        this.cacheLock.readLock().lock();
        try {
            KeeperRecord keeperRecord = this.cachedRecordsByUid.get(uid);
            return keeperRecord;
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
    }

    public KeeperRecord getRecordByHost(String hostname) throws GuacamoleException {
        this.validateCache();
        this.cacheLock.readLock().lock();
        try {
            if (this.cachedAmbiguousHosts.contains(hostname)) {
                logger.debug("The hostname/address \"{}\" is referenced by multiple Keeper records and cannot be used to locate individual secrets.", (Object)hostname);
                KeeperRecord keeperRecord = null;
                return keeperRecord;
            }
            KeeperRecord keeperRecord = this.cachedRecordsByHost.get(hostname);
            return keeperRecord;
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
    }

    public KeeperRecord getRecordByLogin(String username) throws GuacamoleException {
        this.validateCache();
        this.cacheLock.readLock().lock();
        try {
            if (this.cachedAmbiguousUsernames.contains(username)) {
                logger.debug("The username \"{}\" is referenced by multiple Keeper records and cannot be used to locate individual secrets.", (Object)username);
                KeeperRecord keeperRecord = null;
                return keeperRecord;
            }
            KeeperRecord keeperRecord = this.cachedRecordsByUsername.get(username);
            return keeperRecord;
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<String> getSecret(String notation) throws GuacamoleException {
        this.validateCache();
        this.cacheLock.readLock().lock();
        try {
            Matcher fileNotationMatcher = KEEPER_FILE_NOTATION.matcher(notation);
            if (fileNotationMatcher.matches()) {
                Future<String> future = this.recordService.download(Notation.getFile((KeeperSecrets)this.cachedSecrets, (String)notation));
                return future;
            }
            CompletableFuture<String> completableFuture = CompletableFuture.completedFuture(Notation.getValue((KeeperSecrets)this.cachedSecrets, (String)notation));
            return completableFuture;
        }
        catch (Error e) {
            logger.warn("Record \"{}\" does not exist.", (Object)notation);
            logger.debug("Retrieval of record by Keeper notation failed.", (Throwable)e);
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            return completableFuture;
        }
        catch (Exception e) {
            logger.warn("\"{}\" is not valid Keeper notation. Please check the documentation at {} for valid formatting.", (Object)notation, (Object)KEEPER_NOTATION_DOC_URL);
            logger.debug("Provided Keeper notation could not be parsed.", (Throwable)e);
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            return completableFuture;
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
    }
}

