/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.requests;

import java.util.List;
import org.apache.gravitino.dto.stats.PartitionStatisticsDropDTO;
import org.apache.gravitino.rest.RESTRequest;
import org.apache.gravitino.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.gravitino.shaded.com.google.common.base.Preconditions;

public class PartitionStatisticsDropRequest
implements RESTRequest {
    @JsonProperty(value="drops")
    private List<PartitionStatisticsDropDTO> drops;

    public PartitionStatisticsDropRequest(List<PartitionStatisticsDropDTO> drops) {
        this.drops = drops;
    }

    public PartitionStatisticsDropRequest() {
        this(null);
    }

    @Override
    public void validate() throws IllegalArgumentException {
        Preconditions.checkArgument(this.drops != null && !this.drops.isEmpty(), "\"drops\" must not be null or empty.");
        for (PartitionStatisticsDropDTO drop : this.drops) {
            drop.validate();
        }
    }

    public List<PartitionStatisticsDropDTO> getDrops() {
        return this.drops;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PartitionStatisticsDropRequest)) {
            return false;
        }
        PartitionStatisticsDropRequest other = (PartitionStatisticsDropRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<PartitionStatisticsDropDTO> this$drops = this.getDrops();
        List<PartitionStatisticsDropDTO> other$drops = other.getDrops();
        return !(this$drops == null ? other$drops != null : !((Object)this$drops).equals(other$drops));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PartitionStatisticsDropRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<PartitionStatisticsDropDTO> $drops = this.getDrops();
        result = result * 59 + ($drops == null ? 43 : ((Object)$drops).hashCode());
        return result;
    }

    public String toString() {
        return "PartitionStatisticsDropRequest(drops=" + String.valueOf(this.getDrops()) + ")";
    }
}

