/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest;

import com.fasterxml.jackson.databind.InjectableValues;
import java.util.Collections;
import java.util.Map;
import org.apache.hadoop.util.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;

public class ParserContext {
    private final Map<String, Object> data;

    private ParserContext(Builder builder) {
        this.data = Collections.unmodifiableMap(builder.data);
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public InjectableValues toInjectableValues() {
        return new InjectableValues.Std(this.data);
    }

    static Builder builder() {
        return new Builder();
    }

    static class Builder {
        private final Map<String, Object> data = Maps.newHashMap();

        private Builder() {
        }

        public Builder add(String key, Object value) {
            Preconditions.checkNotNull((Object)key, (Object)"Key cannot be null");
            Preconditions.checkNotNull((Object)value, (Object)"Value cannot be null");
            this.data.put(key, value);
            return this;
        }

        public ParserContext build() {
            return new ParserContext(this);
        }
    }
}

