/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.iceberg.avro.GenericAvroReader;
import org.apache.iceberg.avro.GenericAvroWriter;
import org.apache.iceberg.avro.LogicalMap;
import org.apache.iceberg.avro.VariantLogicalType;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public class AvroEncoderUtil {
    private static final byte[] MAGIC_BYTES;

    private AvroEncoderUtil() {
    }

    public static <T> byte[] encode(T datum, Schema avroSchema) throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            DataOutputStream dataOut = new DataOutputStream(out);
            dataOut.write(MAGIC_BYTES);
            dataOut.writeUTF(avroSchema.toString());
            BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)out, null);
            GenericAvroWriter writer = new GenericAvroWriter(avroSchema);
            writer.write(datum, (Encoder)encoder);
            encoder.flush();
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    public static <T> T decode(byte[] data) throws IOException {
        try (ByteArrayInputStream in = new ByteArrayInputStream(data, 0, data.length);){
            DataInputStream dataInput = new DataInputStream(in);
            byte header0 = dataInput.readByte();
            byte header1 = dataInput.readByte();
            Preconditions.checkState((header0 == MAGIC_BYTES[0] && header1 == MAGIC_BYTES[1] ? 1 : 0) != 0, (String)"Unrecognized header bytes: 0x%02X 0x%02X", (int)header0, (int)header1);
            Schema avroSchema = new Schema.Parser().parse(dataInput.readUTF());
            BinaryDecoder binaryDecoder = DecoderFactory.get().binaryDecoder((InputStream)in, null);
            GenericAvroReader reader = new GenericAvroReader(avroSchema);
            reader.setSchema(avroSchema);
            Object object = reader.read(null, (Decoder)binaryDecoder);
            return (T)object;
        }
    }

    static {
        LogicalTypes.register((String)"map", schema -> LogicalMap.get());
        LogicalTypes.register((String)"variant", schema -> VariantLogicalType.get());
        MAGIC_BYTES = new byte[]{-62, 1};
    }
}

