/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.meta;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.ArrayUtils;

public class NamespacedEntityId {
    private final long entityId;
    private final long[] namespaceIds;

    public NamespacedEntityId(long entityId, long ... namespaceIds) {
        Preconditions.checkArgument((namespaceIds != null ? 1 : 0) != 0, (Object)"namespaceIds cannot be null");
        this.entityId = entityId;
        this.namespaceIds = namespaceIds;
    }

    public NamespacedEntityId(long entityId) {
        this(entityId, new long[0]);
    }

    public long entityId() {
        return this.entityId;
    }

    public long[] namespaceIds() {
        return this.namespaceIds;
    }

    public long[] fullIds() {
        return ArrayUtils.add((long[])this.namespaceIds, (long)this.entityId);
    }
}

