/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.trino.connector.util.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import io.airlift.json.RecordAutoDetectModule;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import java.lang.reflect.Field;
import java.util.function.Function;
import org.apache.gravitino.trino.connector.GravitinoConnectorPluginManager;
import org.apache.gravitino.trino.connector.GravitinoErrorCode;
import org.apache.gravitino.trino.connector.util.json.AbstractTypedJacksonModule;
import org.apache.gravitino.trino.connector.util.json.BlockJsonSerde;
import org.apache.gravitino.trino.connector.util.json.TypeDeserializer;
import org.apache.gravitino.trino.connector.util.json.TypeSignatureDeserializer;

public class JsonCodec {
    private static volatile ObjectMapper mapper;
    private static volatile Type jsonType;

    private static ObjectMapper buildMapper(ClassLoader classLoader) {
        try {
            ClassLoader appClassLoader = GravitinoConnectorPluginManager.instance(classLoader).getAppClassloader();
            TypeManager typeManager = JsonCodec.createTypeManager(appClassLoader);
            return JsonCodec.createMapper(typeManager);
        }
        catch (Exception e) {
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_RUNTIME_ERROR, "Failed to build ObjectMapper", (Throwable)e);
        }
    }

    private static Type buildJsonType(ClassLoader classLoader) {
        try {
            ClassLoader appClassLoader = GravitinoConnectorPluginManager.instance(classLoader).getAppClassloader();
            TypeManager typeManager = JsonCodec.createTypeManager(appClassLoader);
            return typeManager.getType(new TypeSignature("json", new TypeSignatureParameter[0]));
        }
        catch (Exception e) {
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_RUNTIME_ERROR, "Failed to build JsonType", (Throwable)e);
        }
    }

    static TypeManager createTypeManager(ClassLoader classLoader) {
        try {
            Class<?> internalTypeManagerClass = classLoader.loadClass("io.trino.type.InternalTypeManager");
            Class<?> typeRegistryClass = classLoader.loadClass("io.trino.metadata.TypeRegistry");
            Class<?> typeOperatorsClass = classLoader.loadClass("io.trino.spi.type.TypeOperators");
            Class<?> featuresConfigClass = classLoader.loadClass("io.trino.FeaturesConfig");
            Object typeRegistry = typeRegistryClass.getConstructor(typeOperatorsClass, featuresConfigClass).newInstance(typeOperatorsClass.getConstructor(new Class[0]).newInstance(new Object[0]), featuresConfigClass.getConstructor(new Class[0]).newInstance(new Object[0]));
            return (TypeManager)internalTypeManagerClass.getConstructor(typeRegistryClass).newInstance(typeRegistry);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create TypeManager :" + e.getMessage(), e);
        }
    }

    static BlockEncodingSerde createBlockEncodingSerde(TypeManager typeManager) throws Exception {
        ClassLoader classLoader = typeManager.getClass().getClassLoader();
        Class<?> blockEncodingManagerClass = classLoader.loadClass("io.trino.metadata.BlockEncodingManager");
        Class<?> internalBlockEncodingSerdeClass = classLoader.loadClass("io.trino.metadata.InternalBlockEncodingSerde");
        return (BlockEncodingSerde)internalBlockEncodingSerdeClass.getConstructor(blockEncodingManagerClass, TypeManager.class).newInstance(blockEncodingManagerClass.getConstructor(new Class[0]).newInstance(new Object[0]), typeManager);
    }

    static void registerHandleSerializationModule(ObjectMapper objectMapper) {
        GravitinoConnectorPluginManager pluginManager = GravitinoConnectorPluginManager.instance();
        Function<Object, String> nameResolver = obj -> {
            try {
                ClassLoader pluginClassloader = obj.getClass().getClassLoader();
                if (pluginClassloader == GravitinoConnectorPluginManager.instance().getAppClassloader()) {
                    return "app:" + obj.getClass().getName();
                }
                Field idField = pluginClassloader.getClass().getDeclaredField("pluginName");
                idField.setAccessible(true);
                String classLoaderName = (String)idField.get(pluginClassloader);
                return classLoaderName + ":" + obj.getClass().getName();
            }
            catch (Exception e) {
                throw new RuntimeException("Gravitino connector serialize error " + e.getMessage(), e);
            }
        };
        Function<String, Class> classResolver = name -> {
            try {
                String[] nameParts = name.split(":");
                String classLoaderName = nameParts[0];
                String className = nameParts[1];
                ClassLoader loader = pluginManager.getClassLoader(classLoaderName);
                return loader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Gravitino connector deserialize error " + e.getMessage(), e);
            }
        };
        objectMapper.registerModule((Module)new AbstractTypedJacksonModule<ConnectorTransactionHandle>(ConnectorTransactionHandle.class, nameResolver, classResolver){});
        objectMapper.registerModule((Module)new AbstractTypedJacksonModule<ConnectorTableHandle>(ConnectorTableHandle.class, nameResolver, classResolver){});
        objectMapper.registerModule((Module)new AbstractTypedJacksonModule<ColumnHandle>(ColumnHandle.class, nameResolver, classResolver){});
        objectMapper.registerModule((Module)new AbstractTypedJacksonModule<ConnectorSplit>(ConnectorSplit.class, nameResolver, classResolver){});
        objectMapper.registerModule((Module)new AbstractTypedJacksonModule<ConnectorInsertTableHandle>(ConnectorInsertTableHandle.class, nameResolver, classResolver){});
    }

    private static ObjectMapper createMapper(TypeManager typeManager) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            objectMapper.disable(DeserializationFeature.ACCEPT_FLOAT_AS_INT);
            objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            objectMapper.setDefaultPropertyInclusion(JsonInclude.Value.construct((JsonInclude.Include)JsonInclude.Include.NON_ABSENT, (JsonInclude.Include)JsonInclude.Include.ALWAYS));
            objectMapper.disable(new MapperFeature[]{MapperFeature.AUTO_DETECT_CREATORS});
            objectMapper.disable(new MapperFeature[]{MapperFeature.AUTO_DETECT_FIELDS});
            objectMapper.disable(new MapperFeature[]{MapperFeature.AUTO_DETECT_SETTERS});
            objectMapper.disable(new MapperFeature[]{MapperFeature.AUTO_DETECT_GETTERS});
            objectMapper.disable(new MapperFeature[]{MapperFeature.AUTO_DETECT_IS_GETTERS});
            objectMapper.disable(new MapperFeature[]{MapperFeature.USE_GETTERS_AS_SETTERS});
            objectMapper.disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS});
            objectMapper.disable(new MapperFeature[]{MapperFeature.INFER_PROPERTY_MUTATORS});
            objectMapper.disable(new MapperFeature[]{MapperFeature.ALLOW_FINAL_FIELDS_AS_MUTATORS});
            SimpleModule module = new SimpleModule();
            objectMapper.registerModule((Module)new Jdk8Module());
            objectMapper.registerModule((Module)new JavaTimeModule());
            objectMapper.registerModule((Module)new GuavaModule());
            objectMapper.registerModule((Module)new ParameterNamesModule());
            objectMapper.registerModule((Module)new RecordAutoDetectModule());
            JsonCodec.registerHandleSerializationModule(objectMapper);
            module.addDeserializer(Type.class, (JsonDeserializer)new TypeDeserializer(typeManager));
            module.addDeserializer(TypeSignature.class, (JsonDeserializer)new TypeSignatureDeserializer(typeManager.getClass().getClassLoader()));
            BlockEncodingSerde blockEncodingSerde = JsonCodec.createBlockEncodingSerde(typeManager);
            module.addSerializer(Block.class, (JsonSerializer)new BlockJsonSerde.Serializer(blockEncodingSerde));
            module.addDeserializer(Block.class, (JsonDeserializer)new BlockJsonSerde.Deserializer(blockEncodingSerde));
            objectMapper.registerModule((Module)module);
            return objectMapper;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create JsonMapper:" + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjectMapper getMapper(ClassLoader appClassLoader) {
        if (mapper != null) {
            return mapper;
        }
        Class<JsonCodec> clazz = JsonCodec.class;
        synchronized (JsonCodec.class) {
            if (mapper != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return mapper;
            }
            mapper = JsonCodec.buildMapper(appClassLoader);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mapper;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Type getJsonType(ClassLoader classLoader) {
        if (jsonType != null) {
            return jsonType;
        }
        Class<JsonCodec> clazz = JsonCodec.class;
        synchronized (JsonCodec.class) {
            if (jsonType != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return jsonType;
            }
            jsonType = JsonCodec.buildJsonType(classLoader);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return jsonType;
        }
    }
}

