/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.rel.expressions;

import org.apache.gravitino.dto.rel.expressions.FunctionArg;
import org.apache.gravitino.rel.expressions.literals.Literal;
import org.apache.gravitino.rel.types.Type;
import org.apache.gravitino.rel.types.Types;

public class LiteralDTO
implements Literal<String>,
FunctionArg {
    public static final LiteralDTO NULL = new LiteralDTO("NULL", (Type)Types.NullType.get());
    private final String value;
    private final Type dataType;

    private LiteralDTO(String value, Type dataType) {
        this.value = value;
        this.dataType = dataType;
    }

    public String value() {
        return this.value;
    }

    public Type dataType() {
        return this.dataType;
    }

    @Override
    public FunctionArg.ArgType argType() {
        return FunctionArg.ArgType.LITERAL;
    }

    public String toString() {
        return "LiteralDTO{value='" + this.value + "', dataType=" + String.valueOf(this.dataType) + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LiteralDTO)) {
            return false;
        }
        LiteralDTO other = (LiteralDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$value = this.value;
        String other$value = other.value;
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        Type this$dataType = this.dataType;
        Type other$dataType = other.dataType;
        return !(this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LiteralDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $value = this.value;
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        Type $dataType = this.dataType;
        result = result * 59 + ($dataType == null ? 43 : $dataType.hashCode());
        return result;
    }

    public static class Builder {
        private String value;
        private Type dataType;

        public Builder withValue(String value) {
            this.value = value;
            return this;
        }

        public Builder withDataType(Type dataType) {
            this.dataType = dataType;
            return this;
        }

        private Builder() {
        }

        public LiteralDTO build() {
            return new LiteralDTO(this.value, this.dataType);
        }
    }
}

