/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper.provider.base;

import org.apache.gravitino.storage.relational.po.JobTemplatePO;
import org.apache.ibatis.annotations.Param;

public class JobTemplateMetaBaseSQLProvider {
    public String insertJobTemplateMeta(@Param(value="jobTemplateMeta") JobTemplatePO jobTemplatePO) {
        return "INSERT INTO job_template_meta (job_template_id, job_template_name, metalake_id, job_template_comment, job_template_content, audit_info, current_version, last_version, deleted_at) VALUES (#{jobTemplateMeta.jobTemplateId}, #{jobTemplateMeta.jobTemplateName}, #{jobTemplateMeta.metalakeId}, #{jobTemplateMeta.jobTemplateComment}, #{jobTemplateMeta.jobTemplateContent}, #{jobTemplateMeta.auditInfo}, #{jobTemplateMeta.currentVersion}, #{jobTemplateMeta.lastVersion}, #{jobTemplateMeta.deletedAt})";
    }

    public String insertJobTemplateMetaOnDuplicateKeyUpdate(@Param(value="jobTemplateMeta") JobTemplatePO jobTemplatePO) {
        return "INSERT INTO job_template_meta (job_template_id, job_template_name, metalake_id, job_template_comment, job_template_content, audit_info, current_version, last_version, deleted_at) VALUES (#{jobTemplateMeta.jobTemplateId}, #{jobTemplateMeta.jobTemplateName}, #{jobTemplateMeta.metalakeId}, #{jobTemplateMeta.jobTemplateComment}, #{jobTemplateMeta.jobTemplateContent}, #{jobTemplateMeta.auditInfo}, #{jobTemplateMeta.currentVersion}, #{jobTemplateMeta.lastVersion}, #{jobTemplateMeta.deletedAt}) ON DUPLICATE KEY UPDATE job_template_name = #{jobTemplateMeta.jobTemplateName}, metalake_id = #{jobTemplateMeta.metalakeId}, job_template_comment = #{jobTemplateMeta.jobTemplateComment}, job_template_content = #{jobTemplateMeta.jobTemplateContent}, audit_info = #{jobTemplateMeta.auditInfo}, current_version = #{jobTemplateMeta.currentVersion}, last_version = #{jobTemplateMeta.lastVersion}, deleted_at = #{jobTemplateMeta.deletedAt}";
    }

    public String listJobTemplatePOsByMetalake(@Param(value="metalakeName") String metalakeName) {
        return "SELECT jtm.job_template_id AS jobTemplateId, jtm.job_template_name AS jobTemplateName, jtm.metalake_id AS metalakeId, jtm.job_template_comment AS jobTemplateComment, jtm.job_template_content AS jobTemplateContent, jtm.audit_info AS auditInfo, jtm.current_version AS currentVersion, jtm.last_version AS lastVersion, jtm.deleted_at AS deletedAt FROM job_template_meta jtm JOIN metalake_meta mm ON jtm.metalake_id = mm.metalake_id WHERE mm.metalake_name = #{metalakeName} AND jtm.deleted_at = 0 AND mm.deleted_at = 0";
    }

    public String selectJobTemplatePOByMetalakeAndName(@Param(value="metalakeName") String metalakeName, @Param(value="jobTemplateName") String jobTemplateName) {
        return "SELECT jtm.job_template_id AS jobTemplateId, jtm.job_template_name AS jobTemplateName, jtm.metalake_id AS metalakeId, jtm.job_template_comment AS jobTemplateComment, jtm.job_template_content AS jobTemplateContent, jtm.audit_info AS auditInfo, jtm.current_version AS currentVersion, jtm.last_version AS lastVersion, jtm.deleted_at AS deletedAt FROM job_template_meta jtm JOIN metalake_meta mm ON jtm.metalake_id = mm.metalake_id WHERE mm.metalake_name = #{metalakeName} AND jtm.job_template_name = #{jobTemplateName} AND jtm.deleted_at = 0 AND mm.deleted_at = 0";
    }

    public String softDeleteJobTemplateMetaByMetalakeAndName(@Param(value="metalakeName") String metalakeName, @Param(value="jobTemplateName") String jobTemplateName) {
        return "UPDATE job_template_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000.0 WHERE job_template_name = #{jobTemplateName} AND metalake_id = (SELECT metalake_id FROM metalake_meta WHERE metalake_name = #{metalakeName} AND deleted_at = 0) AND deleted_at = 0";
    }

    public String softDeleteJobTemplateMetasByMetalakeId(@Param(value="metalakeId") Long metalakeId) {
        return "UPDATE job_template_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000.0 WHERE metalake_id = #{metalakeId} AND deleted_at = 0";
    }

    public String deleteJobTemplateMetasByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return "DELETE FROM job_template_meta WHERE deleted_at < #{legacyTimeline} AND deleted_at > 0 LIMIT #{limit}";
    }

    public String updateJobTemplateMeta(@Param(value="newJobTemplateMeta") JobTemplatePO newJobTemplatePO, @Param(value="oldJobTemplateMeta") JobTemplatePO oldJobTemplatePO) {
        return "UPDATE job_template_meta SET job_template_name = #{newJobTemplateMeta.jobTemplateName}, metalake_id = #{newJobTemplateMeta.metalakeId}, job_template_comment = #{newJobTemplateMeta.jobTemplateComment}, job_template_content = #{newJobTemplateMeta.jobTemplateContent}, audit_info = #{newJobTemplateMeta.auditInfo}, current_version = #{newJobTemplateMeta.currentVersion}, last_version = #{newJobTemplateMeta.lastVersion}, deleted_at = #{newJobTemplateMeta.deletedAt} WHERE job_template_id = #{oldJobTemplateMeta.jobTemplateId} AND job_template_name = #{oldJobTemplateMeta.jobTemplateName} AND metalake_id = #{oldJobTemplateMeta.metalakeId} AND current_version = #{oldJobTemplateMeta.currentVersion} AND last_version = #{oldJobTemplateMeta.lastVersion} AND deleted_at = 0";
    }
}

