/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.po;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class TablePO {
    private Long tableId;
    private String tableName;
    private Long metalakeId;
    private Long catalogId;
    private Long schemaId;
    private String auditInfo;
    private Long currentVersion;
    private Long lastVersion;
    private Long deletedAt;

    public Long getTableId() {
        return this.tableId;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Long getMetalakeId() {
        return this.metalakeId;
    }

    public Long getCatalogId() {
        return this.catalogId;
    }

    public Long getSchemaId() {
        return this.schemaId;
    }

    public String getAuditInfo() {
        return this.auditInfo;
    }

    public Long getCurrentVersion() {
        return this.currentVersion;
    }

    public Long getLastVersion() {
        return this.lastVersion;
    }

    public Long getDeletedAt() {
        return this.deletedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TablePO)) {
            return false;
        }
        TablePO tablePO = (TablePO)o;
        return Objects.equal((Object)this.getTableId(), (Object)tablePO.getTableId()) && Objects.equal((Object)this.getTableName(), (Object)tablePO.getTableName()) && Objects.equal((Object)this.getMetalakeId(), (Object)tablePO.getMetalakeId()) && Objects.equal((Object)this.getCatalogId(), (Object)tablePO.getCatalogId()) && Objects.equal((Object)this.getSchemaId(), (Object)tablePO.getSchemaId()) && Objects.equal((Object)this.getAuditInfo(), (Object)tablePO.getAuditInfo()) && Objects.equal((Object)this.getCurrentVersion(), (Object)tablePO.getCurrentVersion()) && Objects.equal((Object)this.getLastVersion(), (Object)tablePO.getLastVersion()) && Objects.equal((Object)this.getDeletedAt(), (Object)tablePO.getDeletedAt());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getTableId(), this.getTableName(), this.getMetalakeId(), this.getCatalogId(), this.getSchemaId(), this.getAuditInfo(), this.getCurrentVersion(), this.getLastVersion(), this.getDeletedAt()});
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final TablePO tablePO = new TablePO();

        private Builder() {
        }

        public Builder withTableId(Long tableId) {
            this.tablePO.tableId = tableId;
            return this;
        }

        public Builder withTableName(String tableName) {
            this.tablePO.tableName = tableName;
            return this;
        }

        public Builder withMetalakeId(Long metalakeId) {
            this.tablePO.metalakeId = metalakeId;
            return this;
        }

        public Builder withCatalogId(Long catalogId) {
            this.tablePO.catalogId = catalogId;
            return this;
        }

        public Builder withSchemaId(Long schemaId) {
            this.tablePO.schemaId = schemaId;
            return this;
        }

        public Builder withAuditInfo(String auditInfo) {
            this.tablePO.auditInfo = auditInfo;
            return this;
        }

        public Builder withCurrentVersion(Long currentVersion) {
            this.tablePO.currentVersion = currentVersion;
            return this;
        }

        public Builder withLastVersion(Long lastVersion) {
            this.tablePO.lastVersion = lastVersion;
            return this;
        }

        public Builder withDeletedAt(Long deletedAt) {
            this.tablePO.deletedAt = deletedAt;
            return this;
        }

        private void validate() {
            Preconditions.checkArgument((this.tablePO.tableId != null ? 1 : 0) != 0, (Object)"Table id is required");
            Preconditions.checkArgument((this.tablePO.tableName != null ? 1 : 0) != 0, (Object)"Table name is required");
            Preconditions.checkArgument((this.tablePO.metalakeId != null ? 1 : 0) != 0, (Object)"Metalake id is required");
            Preconditions.checkArgument((this.tablePO.catalogId != null ? 1 : 0) != 0, (Object)"Catalog id is required");
            Preconditions.checkArgument((this.tablePO.schemaId != null ? 1 : 0) != 0, (Object)"Schema id is required");
            Preconditions.checkArgument((this.tablePO.auditInfo != null ? 1 : 0) != 0, (Object)"Audit info is required");
            Preconditions.checkArgument((this.tablePO.currentVersion != null ? 1 : 0) != 0, (Object)"Current version is required");
            Preconditions.checkArgument((this.tablePO.lastVersion != null ? 1 : 0) != 0, (Object)"Last version is required");
            Preconditions.checkArgument((this.tablePO.deletedAt != null ? 1 : 0) != 0, (Object)"Deleted at is required");
        }

        public TablePO build() {
            this.validate();
            return this.tablePO;
        }
    }
}

