/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.listener;

import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import org.apache.gravitino.exceptions.ForbiddenException;
import org.apache.gravitino.listener.api.EventListenerPlugin;
import org.apache.gravitino.listener.api.event.BaseEvent;
import org.apache.gravitino.listener.api.event.Event;
import org.apache.gravitino.listener.api.event.PreEvent;
import org.apache.gravitino.listener.api.event.SupportsChangingPreEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventListenerPluginWrapper
implements EventListenerPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(EventListenerPluginWrapper.class);
    private String listenerName;
    private EventListenerPlugin userEventListener;

    public EventListenerPluginWrapper(String listenerName, EventListenerPlugin userEventListener) {
        this.listenerName = listenerName;
        this.userEventListener = userEventListener;
    }

    @Override
    public void init(Map<String, String> properties) {
        throw new RuntimeException("Should not reach here, the event listener has already been initialized.");
    }

    @Override
    public void start() {
        this.userEventListener.start();
        LOG.info("Start event listener {}.", (Object)this.listenerName);
    }

    @Override
    public void stop() {
        try {
            this.userEventListener.stop();
            LOG.info("Stop event listener {}.", (Object)this.listenerName);
        }
        catch (Exception e) {
            LOG.warn("Failed to stop event listener {}.", (Object)this.listenerName, (Object)e);
        }
    }

    @Override
    public void onPostEvent(Event event) {
        try {
            this.userEventListener.onPostEvent(event);
        }
        catch (Exception e) {
            this.printExceptionInEventProcess(this.listenerName, event, e);
        }
    }

    @Override
    public void onPreEvent(PreEvent preEvent) {
        try {
            this.userEventListener.onPreEvent(preEvent);
        }
        catch (ForbiddenException e) {
            if (EventListenerPlugin.Mode.SYNC.equals((Object)this.mode())) {
                LOG.warn("Event listener {} process pre event {} throws ForbiddenException, will skip the operation.", new Object[]{this.listenerName, preEvent.getClass().getSimpleName(), e});
                throw e;
            }
            this.printExceptionInEventProcess(this.listenerName, preEvent, (Exception)((Object)e));
        }
        catch (Exception e) {
            this.printExceptionInEventProcess(this.listenerName, preEvent, e);
        }
    }

    @Override
    public SupportsChangingPreEvent transformPreEvent(SupportsChangingPreEvent preEvent) {
        return this.userEventListener.transformPreEvent(preEvent);
    }

    public String listenerName() {
        return this.listenerName;
    }

    @VisibleForTesting
    public EventListenerPlugin getUserEventListener() {
        return this.userEventListener;
    }

    private void printExceptionInEventProcess(String listenerName, BaseEvent baseEvent, Exception e) {
        LOG.warn("Event listener {} process event {} failed,", new Object[]{listenerName, baseEvent.getClass().getSimpleName(), e});
    }
}

