/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Map;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.catalog.CatalogManager;
import org.apache.gravitino.connector.capability.Capability;
import org.apache.gravitino.file.FilesetChange;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.TableChange;
import org.apache.gravitino.rel.expressions.Expression;
import org.apache.gravitino.rel.expressions.FunctionExpression;
import org.apache.gravitino.rel.expressions.NamedReference;
import org.apache.gravitino.rel.expressions.distributions.Distribution;
import org.apache.gravitino.rel.expressions.distributions.Distributions;
import org.apache.gravitino.rel.expressions.distributions.Strategy;
import org.apache.gravitino.rel.expressions.literals.Literal;
import org.apache.gravitino.rel.expressions.sorts.NullOrdering;
import org.apache.gravitino.rel.expressions.sorts.SortDirection;
import org.apache.gravitino.rel.expressions.sorts.SortOrder;
import org.apache.gravitino.rel.expressions.sorts.SortOrders;
import org.apache.gravitino.rel.expressions.transforms.Transform;
import org.apache.gravitino.rel.expressions.transforms.Transforms;
import org.apache.gravitino.rel.indexes.Index;
import org.apache.gravitino.rel.indexes.Indexes;
import org.apache.gravitino.rel.partitions.IdentityPartition;
import org.apache.gravitino.rel.partitions.ListPartition;
import org.apache.gravitino.rel.partitions.Partition;
import org.apache.gravitino.rel.partitions.Partitions;
import org.apache.gravitino.rel.partitions.RangePartition;
import org.apache.gravitino.rel.types.Type;
import org.apache.gravitino.utils.NameIdentifierUtil;

public class CapabilityHelpers {
    public static Capability getCapability(NameIdentifier ident, CatalogManager catalogManager) {
        NameIdentifier catalogIdent = NameIdentifierUtil.getCatalogIdentifier(ident);
        CatalogManager.CatalogWrapper c = catalogManager.loadCatalogAndWrap(catalogIdent);
        try {
            return c.capabilities();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get capabilities for catalog: " + String.valueOf(catalogIdent), e);
        }
    }

    public static Column[] applyCapabilities(Column[] columns, Capability capabilities) {
        return (Column[])Arrays.stream(columns).map(c -> CapabilityHelpers.applyCapabilities(c, capabilities)).toArray(Column[]::new);
    }

    public static TableChange[] applyCapabilities(Capability capabilities, TableChange ... changes) {
        return (TableChange[])Arrays.stream(changes).map(change -> {
            if (change instanceof TableChange.ColumnChange) {
                return CapabilityHelpers.applyCapabilities((TableChange.ColumnChange)change, capabilities);
            }
            if (change instanceof TableChange.RenameTable) {
                return CapabilityHelpers.applyCapabilities((TableChange.RenameTable)change, capabilities);
            }
            return change;
        }).toArray(TableChange[]::new);
    }

    public static FilesetChange[] applyCapabilities(Capability capabilities, FilesetChange ... changes) {
        return (FilesetChange[])Arrays.stream(changes).map(change -> {
            if (change instanceof FilesetChange.RenameFileset) {
                return CapabilityHelpers.applyCapabilities((FilesetChange.RenameFileset)change, capabilities);
            }
            return change;
        }).toArray(FilesetChange[]::new);
    }

    public static NameIdentifier[] applyCapabilities(NameIdentifier[] idents, Capability.Scope scope, Capability capabilities) {
        return (NameIdentifier[])Arrays.stream(idents).map(ident -> CapabilityHelpers.applyCapabilities(ident, scope, capabilities)).toArray(NameIdentifier[]::new);
    }

    public static NameIdentifier applyCapabilities(NameIdentifier ident, Capability.Scope scope, Capability capabilities) {
        Namespace namespace = ident.namespace();
        namespace = CapabilityHelpers.applyCapabilities(namespace, scope, capabilities);
        String name = CapabilityHelpers.applyCapabilitiesOnName(scope, ident.name(), capabilities);
        return NameIdentifier.of((Namespace)namespace, (String)name);
    }

    public static NameIdentifier[] applyCaseSensitive(NameIdentifier[] idents, Capability.Scope scope, Capability capabilities) {
        return (NameIdentifier[])Arrays.stream(idents).map(ident -> CapabilityHelpers.applyCaseSensitive(ident, scope, capabilities)).toArray(NameIdentifier[]::new);
    }

    public static NameIdentifier applyCaseSensitive(NameIdentifier ident, Capability.Scope scope, Capability capabilities) {
        Namespace namespace = CapabilityHelpers.applyCaseSensitive(ident.namespace(), scope, capabilities);
        String name = CapabilityHelpers.applyCaseSensitiveOnName(scope, ident.name(), capabilities);
        return NameIdentifier.of((Namespace)namespace, (String)name);
    }

    public static Namespace applyCaseSensitive(Namespace namespace, Capability.Scope identScope, Capability capabilities) {
        String metalake = namespace.level(0);
        String catalog = namespace.level(1);
        if (identScope == Capability.Scope.TABLE || identScope == Capability.Scope.FILESET || identScope == Capability.Scope.TOPIC || identScope == Capability.Scope.MODEL) {
            String schema = namespace.level(namespace.length() - 1);
            schema = CapabilityHelpers.applyCaseSensitiveOnName(Capability.Scope.SCHEMA, schema, capabilities);
            return Namespace.of((String[])new String[]{metalake, catalog, schema});
        }
        return namespace;
    }

    public static Partition[] applyCaseSensitive(Partition[] partitions, Capability capabilities) {
        return (Partition[])Arrays.stream(partitions).map(p -> CapabilityHelpers.applyCaseSensitive(p, capabilities)).toArray(Partition[]::new);
    }

    public static Partition applyCaseSensitive(Partition partition, Capability capabilities) {
        String newName;
        String string = newName = capabilities.caseSensitiveOnName(Capability.Scope.PARTITION).supported() ? partition.name() : partition.name().toLowerCase();
        if (partition instanceof IdentityPartition) {
            IdentityPartition identityPartition = (IdentityPartition)partition;
            return Partitions.identity((String)newName, (String[][])identityPartition.fieldNames(), (Literal[])identityPartition.values(), (Map)identityPartition.properties());
        }
        if (partition instanceof ListPartition) {
            ListPartition listPartition = (ListPartition)partition;
            return Partitions.list((String)newName, (Literal[][])listPartition.lists(), (Map)listPartition.properties());
        }
        if (partition instanceof RangePartition) {
            RangePartition rangePartition = (RangePartition)partition;
            return Partitions.range((String)newName, (Literal)rangePartition.upper(), (Literal)rangePartition.lower(), (Map)rangePartition.properties());
        }
        throw new IllegalArgumentException("Unknown partition type: " + String.valueOf(partition.getClass()));
    }

    public static Transform[] applyCapabilities(Transform[] transforms, Capability capabilities) {
        return (Transform[])Arrays.stream(transforms).map(t -> CapabilityHelpers.applyCapabilities(t, capabilities)).toArray(Transform[]::new);
    }

    public static Distribution applyCapabilities(Distribution distribution, Capability capabilities) {
        Expression[] expressions = CapabilityHelpers.applyCapabilities(distribution.expressions(), capabilities);
        return Distributions.of((Strategy)distribution.strategy(), (int)distribution.number(), (Expression[])expressions);
    }

    public static SortOrder[] applyCapabilities(SortOrder[] sortOrders, Capability capabilities) {
        return (SortOrder[])Arrays.stream(sortOrders).map(s -> CapabilityHelpers.applyCapabilities(s, capabilities)).toArray(SortOrder[]::new);
    }

    public static Index[] applyCapabilities(Index[] indexes, Capability capabilities) {
        return (Index[])Arrays.stream(indexes).map(i -> CapabilityHelpers.applyCapabilities(i, capabilities)).toArray(Index[]::new);
    }

    public static Namespace applyCapabilities(Namespace namespace, Capability.Scope identScope, Capability capabilities) {
        String metalake = namespace.level(0);
        String catalog = namespace.level(1);
        if (identScope == Capability.Scope.TABLE || identScope == Capability.Scope.FILESET || identScope == Capability.Scope.TOPIC) {
            String schema = namespace.level(namespace.length() - 1);
            schema = CapabilityHelpers.applyCapabilitiesOnName(Capability.Scope.SCHEMA, schema, capabilities);
            return Namespace.of((String[])new String[]{metalake, catalog, schema});
        }
        return namespace;
    }

    private static Index applyCapabilities(Index index, Capability capabilities) {
        return Indexes.of((Index.IndexType)index.type(), (String)index.name(), (String[][])CapabilityHelpers.applyCapabilities(index.fieldNames(), capabilities));
    }

    private static String[][] applyCapabilities(String[][] fieldNames, Capability capabilities) {
        String[][] standardizeFieldNames = new String[fieldNames.length][];
        for (int i = 0; i < standardizeFieldNames.length; ++i) {
            standardizeFieldNames[i] = CapabilityHelpers.applyCapabilities(fieldNames[i], capabilities);
        }
        return standardizeFieldNames;
    }

    private static String[] applyCapabilities(String[] fieldName, Capability capabilities) {
        String[] sensitiveOnColumnName = CapabilityHelpers.applyCaseSensitiveOnColumnName(fieldName, capabilities);
        CapabilityHelpers.applyNameSpecification(Capability.Scope.COLUMN, sensitiveOnColumnName[0], capabilities);
        return sensitiveOnColumnName;
    }

    private static Transform applyCapabilities(Transform transform, Capability capabilities) {
        if (transform instanceof Transform.SingleFieldTransform) {
            String[] standardizeFieldName = CapabilityHelpers.applyCapabilities(((Transform.SingleFieldTransform)transform).fieldName(), capabilities);
            switch (transform.name()) {
                case "identity": {
                    return Transforms.identity((String[])standardizeFieldName);
                }
                case "year": {
                    return Transforms.year((String[])standardizeFieldName);
                }
                case "month": {
                    return Transforms.month((String[])standardizeFieldName);
                }
                case "day": {
                    return Transforms.day((String[])standardizeFieldName);
                }
                case "hour": {
                    return Transforms.hour((String[])standardizeFieldName);
                }
            }
            throw new IllegalArgumentException("Unsupported transform: " + transform.name());
        }
        if (transform instanceof Transforms.BucketTransform) {
            Transforms.BucketTransform bucketTransform = (Transforms.BucketTransform)transform;
            return Transforms.bucket((int)bucketTransform.numBuckets(), (String[][])CapabilityHelpers.applyCapabilities(bucketTransform.fieldNames(), capabilities));
        }
        if (transform instanceof Transforms.TruncateTransform) {
            Transforms.TruncateTransform truncateTransform = (Transforms.TruncateTransform)transform;
            return Transforms.truncate((int)truncateTransform.width(), (String[])CapabilityHelpers.applyCapabilities(truncateTransform.fieldName(), capabilities));
        }
        if (transform instanceof Transforms.ListTransform) {
            Transforms.ListTransform listTransform = (Transforms.ListTransform)transform;
            ListPartition[] assignments = (ListPartition[])Arrays.stream(listTransform.assignments()).map(l -> CapabilityHelpers.applyCaseSensitive((Partition)l, capabilities)).toArray(ListPartition[]::new);
            return Transforms.list((String[][])CapabilityHelpers.applyCapabilities(listTransform.fieldNames(), capabilities), (ListPartition[])assignments);
        }
        if (transform instanceof Transforms.RangeTransform) {
            Transforms.RangeTransform rangeTransform = (Transforms.RangeTransform)transform;
            RangePartition[] assignments = (RangePartition[])Arrays.stream(rangeTransform.assignments()).map(r -> CapabilityHelpers.applyCaseSensitive((Partition)r, capabilities)).toArray(RangePartition[]::new);
            return Transforms.range((String[])CapabilityHelpers.applyCapabilities(rangeTransform.fieldName(), capabilities), (RangePartition[])assignments);
        }
        if (transform instanceof Transforms.ApplyTransform) {
            return Transforms.apply((String)transform.name(), (Expression[])CapabilityHelpers.applyCapabilities(transform.arguments(), capabilities));
        }
        throw new IllegalArgumentException("Unsupported transform: " + transform.name());
    }

    private static SortOrder applyCapabilities(SortOrder sortOrder, Capability capabilities) {
        Expression expression = CapabilityHelpers.applyCapabilities(sortOrder.expression(), capabilities);
        return SortOrders.of((Expression)expression, (SortDirection)sortOrder.direction(), (NullOrdering)sortOrder.nullOrdering());
    }

    private static Expression[] applyCapabilities(Expression[] expressions, Capability capabilities) {
        return (Expression[])Arrays.stream(expressions).map(e -> CapabilityHelpers.applyCapabilities(e, capabilities)).toArray(Expression[]::new);
    }

    private static Expression applyCapabilities(Expression expression, Capability capabilities) {
        if (expression instanceof NamedReference.FieldReference) {
            NamedReference.FieldReference ref = (NamedReference.FieldReference)expression;
            String[] fieldName = CapabilityHelpers.applyCapabilities(ref.fieldName(), capabilities);
            return NamedReference.field((String[])fieldName);
        }
        if (expression instanceof FunctionExpression) {
            FunctionExpression functionExpression = (FunctionExpression)expression;
            return FunctionExpression.of((String)functionExpression.functionName(), (Expression[])CapabilityHelpers.applyCapabilities(functionExpression.arguments(), capabilities));
        }
        return expression;
    }

    private static FilesetChange applyCapabilities(FilesetChange.RenameFileset renameFileset, Capability capabilities) {
        String newName = CapabilityHelpers.applyCaseSensitiveOnName(Capability.Scope.FILESET, renameFileset.getNewName(), capabilities);
        CapabilityHelpers.applyNameSpecification(Capability.Scope.FILESET, newName, capabilities);
        return FilesetChange.rename((String)newName);
    }

    private static TableChange applyCapabilities(TableChange.RenameTable renameTable, Capability capabilities) {
        String newName = CapabilityHelpers.applyCaseSensitiveOnName(Capability.Scope.TABLE, renameTable.getNewName(), capabilities);
        CapabilityHelpers.applyNameSpecification(Capability.Scope.TABLE, newName, capabilities);
        return TableChange.rename((String)newName);
    }

    private static TableChange applyCapabilities(TableChange.ColumnChange change, Capability capabilities) {
        String[] fieldName = CapabilityHelpers.applyCaseSensitiveOnColumnName(change.fieldName(), capabilities);
        CapabilityHelpers.applyNameSpecification(Capability.Scope.COLUMN, fieldName[0], capabilities);
        if (change instanceof TableChange.AddColumn) {
            return CapabilityHelpers.applyCapabilities((TableChange.AddColumn)change, capabilities);
        }
        if (change instanceof TableChange.UpdateColumnNullability) {
            return CapabilityHelpers.applyCapabilities((TableChange.UpdateColumnNullability)change, capabilities);
        }
        if (change instanceof TableChange.UpdateColumnDefaultValue) {
            return CapabilityHelpers.applyCapabilities((TableChange.UpdateColumnDefaultValue)change, capabilities);
        }
        if (change instanceof TableChange.RenameColumn) {
            return CapabilityHelpers.applyCapabilities((TableChange.RenameColumn)change, capabilities);
        }
        if (change instanceof TableChange.DeleteColumn) {
            return TableChange.deleteColumn((String[])fieldName, (Boolean)((TableChange.DeleteColumn)change).getIfExists());
        }
        if (change instanceof TableChange.UpdateColumnAutoIncrement) {
            return TableChange.updateColumnAutoIncrement((String[])fieldName, (boolean)((TableChange.UpdateColumnAutoIncrement)change).isAutoIncrement());
        }
        if (change instanceof TableChange.UpdateColumnComment) {
            return TableChange.updateColumnComment((String[])fieldName, (String)((TableChange.UpdateColumnComment)change).getNewComment());
        }
        if (change instanceof TableChange.UpdateColumnPosition) {
            TableChange.UpdateColumnPosition updateColumnPosition = (TableChange.UpdateColumnPosition)change;
            if (updateColumnPosition.getPosition() instanceof TableChange.After) {
                TableChange.After afterPosition = (TableChange.After)updateColumnPosition.getPosition();
                String afterFieldName = CapabilityHelpers.applyCaseSensitiveOnName(Capability.Scope.COLUMN, afterPosition.getColumn(), capabilities);
                CapabilityHelpers.applyNameSpecification(Capability.Scope.COLUMN, afterFieldName, capabilities);
                return TableChange.updateColumnPosition((String[])fieldName, (TableChange.ColumnPosition)TableChange.ColumnPosition.after((String)afterFieldName));
            }
            return TableChange.updateColumnPosition((String[])fieldName, (TableChange.ColumnPosition)updateColumnPosition.getPosition());
        }
        if (change instanceof TableChange.UpdateColumnType) {
            return TableChange.updateColumnType((String[])fieldName, (Type)((TableChange.UpdateColumnType)change).getNewDataType());
        }
        throw new IllegalArgumentException("Unsupported column change: " + String.valueOf(change));
    }

    private static TableChange applyCapabilities(TableChange.AddColumn addColumn, Capability capabilities) {
        Column appliedColumn = CapabilityHelpers.applyCapabilities((Column)Column.of((String)addColumn.fieldName()[0], (Type)addColumn.getDataType(), (String)addColumn.getComment(), (boolean)addColumn.isNullable(), (boolean)addColumn.isAutoIncrement(), (Expression)addColumn.getDefaultValue()), capabilities);
        String[] standardizeFieldName = Arrays.copyOf(addColumn.fieldName(), addColumn.fieldName().length);
        standardizeFieldName[0] = appliedColumn.name();
        return TableChange.addColumn((String[])standardizeFieldName, (Type)appliedColumn.dataType(), (String)appliedColumn.comment(), (TableChange.ColumnPosition)addColumn.getPosition(), (boolean)appliedColumn.nullable(), (boolean)appliedColumn.autoIncrement(), (Expression)appliedColumn.defaultValue());
    }

    private static TableChange applyCapabilities(TableChange.UpdateColumnNullability updateColumnNullability, Capability capabilities) {
        CapabilityHelpers.applyColumnNotNull(String.join((CharSequence)".", updateColumnNullability.fieldName()), updateColumnNullability.nullable(), capabilities);
        return TableChange.updateColumnNullability((String[])CapabilityHelpers.applyCaseSensitiveOnColumnName(updateColumnNullability.fieldName(), capabilities), (boolean)updateColumnNullability.nullable());
    }

    private static TableChange applyCapabilities(TableChange.UpdateColumnDefaultValue updateColumnDefaultValue, Capability capabilities) {
        CapabilityHelpers.applyColumnDefaultValue(String.join((CharSequence)".", updateColumnDefaultValue.fieldName()), updateColumnDefaultValue.getNewDefaultValue(), capabilities);
        return TableChange.updateColumnDefaultValue((String[])CapabilityHelpers.applyCaseSensitiveOnColumnName(updateColumnDefaultValue.fieldName(), capabilities), (Expression)updateColumnDefaultValue.getNewDefaultValue());
    }

    private static TableChange applyCapabilities(TableChange.RenameColumn renameColumn, Capability capabilities) {
        String[] fieldName = CapabilityHelpers.applyCapabilities(renameColumn.fieldName(), capabilities);
        String newName = renameColumn.getNewName();
        if (fieldName.length == 1) {
            newName = CapabilityHelpers.applyCapabilitiesOnName(Capability.Scope.COLUMN, newName, capabilities);
        }
        return TableChange.renameColumn((String[])fieldName, (String)newName);
    }

    private static Column applyCapabilities(Column column, Capability capabilities) {
        CapabilityHelpers.applyColumnNotNull(column, capabilities);
        CapabilityHelpers.applyColumnDefaultValue(column, capabilities);
        return Column.of((String)CapabilityHelpers.applyCapabilitiesOnName(Capability.Scope.COLUMN, column.name(), capabilities), (Type)column.dataType(), (String)column.comment(), (boolean)column.nullable(), (boolean)column.autoIncrement(), (Expression)column.defaultValue());
    }

    private static String applyCapabilitiesOnName(Capability.Scope scope, String name, Capability capabilities) {
        String standardizeName = CapabilityHelpers.applyCaseSensitiveOnName(scope, name, capabilities);
        CapabilityHelpers.applyNameSpecification(scope, standardizeName, capabilities);
        return standardizeName;
    }

    public static String applyCaseSensitiveOnName(Capability.Scope scope, String name, Capability capabilities) {
        return capabilities.caseSensitiveOnName(scope).supported() ? name : name.toLowerCase();
    }

    private static String[] applyCaseSensitiveOnColumnName(String[] name, Capability capabilities) {
        if (!capabilities.caseSensitiveOnName(Capability.Scope.COLUMN).supported()) {
            String[] standardizeColumnName = Arrays.copyOf(name, name.length);
            standardizeColumnName[0] = name[0].toLowerCase();
            return standardizeColumnName;
        }
        return name;
    }

    private static void applyColumnNotNull(Column column, Capability capabilities) {
        CapabilityHelpers.applyColumnNotNull(column.name(), column.nullable(), capabilities);
    }

    private static void applyColumnNotNull(String columnName, boolean nullable, Capability capabilities) {
        Preconditions.checkArgument((capabilities.columnNotNull().supported() || nullable ? 1 : 0) != 0, (Object)(capabilities.columnNotNull().unsupportedMessage() + " Illegal column: " + columnName));
    }

    private static void applyColumnDefaultValue(Column column, Capability capabilities) {
        CapabilityHelpers.applyColumnDefaultValue(column.name(), column.defaultValue(), capabilities);
    }

    private static void applyColumnDefaultValue(String columnName, Expression defaultValue, Capability capabilities) {
        Preconditions.checkArgument((capabilities.columnDefaultValue().supported() || Column.DEFAULT_VALUE_NOT_SET.equals(defaultValue) ? 1 : 0) != 0, (Object)(capabilities.columnDefaultValue().unsupportedMessage() + " Illegal column: " + columnName));
    }

    private static void applyNameSpecification(Capability.Scope scope, String name, Capability capabilities) {
        Preconditions.checkArgument((boolean)capabilities.specificationOnName(scope, name).supported(), (Object)(capabilities.specificationOnName(scope, name).unsupportedMessage() + " Illegal name: " + name));
    }
}

