/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cache;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.googlecode.concurrenttrees.radix.ConcurrentRadixTree;
import com.googlecode.concurrenttrees.radix.RadixTree;
import com.googlecode.concurrenttrees.radix.node.NodeFactory;
import com.googlecode.concurrenttrees.radix.node.concrete.DefaultCharArrayNodeFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.gravitino.Entity;
import org.apache.gravitino.HasIdentifier;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.cache.EntityCacheKey;
import org.apache.gravitino.cache.EntityCacheRelationKey;
import org.apache.gravitino.cache.ReverseIndexRules;
import org.apache.gravitino.meta.GroupEntity;
import org.apache.gravitino.meta.RoleEntity;
import org.apache.gravitino.meta.UserEntity;

public class ReverseIndexCache {
    private RadixTree<EntityCacheKey> reverseIndex;
    private final Map<Class<? extends Entity>, ReverseIndexRule> reverseIndexRules = new HashMap<Class<? extends Entity>, ReverseIndexRule>();

    public ReverseIndexCache() {
        this.reverseIndex = new ConcurrentRadixTree((NodeFactory)new DefaultCharArrayNodeFactory());
        this.registerReverseRule(UserEntity.class, ReverseIndexRules.USER_REVERSE_RULE);
        this.registerReverseRule(GroupEntity.class, ReverseIndexRules.GROUP_REVERSE_RULE);
        this.registerReverseRule(RoleEntity.class, ReverseIndexRules.ROLE_REVERSE_RULE);
    }

    public boolean remove(EntityCacheKey key) {
        return this.reverseIndex.remove((CharSequence)key.toString());
    }

    public Iterable<EntityCacheKey> getValuesForKeysStartingWith(String keyPrefix) {
        return this.reverseIndex.getValuesForKeysStartingWith((CharSequence)keyPrefix);
    }

    public Iterable<CharSequence> getKeysStartingWith(String keyPrefix) {
        return this.reverseIndex.getKeysStartingWith((CharSequence)keyPrefix);
    }

    public boolean remove(String key) {
        return this.reverseIndex.remove((CharSequence)key);
    }

    public int size() {
        return this.reverseIndex.size();
    }

    public void put(NameIdentifier nameIdentifier, Entity.EntityType type, EntityCacheRelationKey key) {
        EntityCacheKey entityCacheKey = EntityCacheKey.of(nameIdentifier, type);
        String strEntityCacheKey = entityCacheKey.toString();
        ArrayList entityKeys = Lists.newArrayList((Iterable)this.reverseIndex.getValuesForKeysStartingWith((CharSequence)strEntityCacheKey));
        String strEntityCacheKeySerialNumber = String.format("%s-%d", strEntityCacheKey, entityKeys.size());
        this.reverseIndex.put((CharSequence)strEntityCacheKeySerialNumber, (Object)key);
    }

    public void put(Entity entity, EntityCacheRelationKey key) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"EntityCacheRelationKey cannot be null");
        if (entity instanceof HasIdentifier) {
            NameIdentifier nameIdent = ((HasIdentifier)((Object)entity)).nameIdentifier();
            this.put(nameIdent, entity.type(), key);
        }
    }

    public void registerReverseRule(Class<? extends Entity> entityClass, ReverseIndexRule rule) {
        this.reverseIndexRules.put(entityClass, rule);
    }

    public void indexEntity(Entity entity, EntityCacheRelationKey key) {
        ReverseIndexRule rule = this.reverseIndexRules.get(entity.getClass());
        if (rule != null) {
            rule.indexEntity(entity, key, this);
        }
    }

    @FunctionalInterface
    static interface ReverseIndexRule {
        public void indexEntity(Entity var1, EntityCacheRelationKey var2, ReverseIndexCache var3);
    }
}

