/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.authorization;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import org.apache.gravitino.Entity;
import org.apache.gravitino.EntityStore;
import org.apache.gravitino.GravitinoEnv;
import org.apache.gravitino.HasIdentifier;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.catalog.CapabilityHelpers;
import org.apache.gravitino.catalog.CatalogManager;
import org.apache.gravitino.connector.capability.Capability;
import org.apache.gravitino.meta.BaseMetalake;
import org.apache.gravitino.meta.CatalogEntity;
import org.apache.gravitino.meta.ColumnEntity;
import org.apache.gravitino.meta.FilesetEntity;
import org.apache.gravitino.meta.GroupEntity;
import org.apache.gravitino.meta.ModelEntity;
import org.apache.gravitino.meta.ModelVersionEntity;
import org.apache.gravitino.meta.RoleEntity;
import org.apache.gravitino.meta.SchemaEntity;
import org.apache.gravitino.meta.TableEntity;
import org.apache.gravitino.meta.TagEntity;
import org.apache.gravitino.meta.TopicEntity;
import org.apache.gravitino.meta.UserEntity;
import org.apache.gravitino.utils.MetadataObjectUtil;

public class MetadataIdConverter {
    private static final Map<MetadataObject.Type, Entity.EntityType> METADATA_TO_ENTITY_TYPE_MAPPING = ImmutableMap.of((Object)MetadataObject.Type.METALAKE, (Object)Entity.EntityType.METALAKE, (Object)MetadataObject.Type.CATALOG, (Object)Entity.EntityType.CATALOG, (Object)MetadataObject.Type.SCHEMA, (Object)Entity.EntityType.SCHEMA, (Object)MetadataObject.Type.TABLE, (Object)Entity.EntityType.TABLE, (Object)MetadataObject.Type.MODEL, (Object)Entity.EntityType.MODEL, (Object)MetadataObject.Type.FILESET, (Object)Entity.EntityType.FILESET, (Object)MetadataObject.Type.TOPIC, (Object)Entity.EntityType.TOPIC, (Object)MetadataObject.Type.COLUMN, (Object)Entity.EntityType.COLUMN, (Object)MetadataObject.Type.ROLE, (Object)Entity.EntityType.ROLE);
    private static final Map<MetadataObject.Type, Capability.Scope> METADATA_SCOPE_MAPPING = ImmutableMap.of((Object)MetadataObject.Type.SCHEMA, (Object)Capability.Scope.SCHEMA, (Object)MetadataObject.Type.TABLE, (Object)Capability.Scope.TABLE, (Object)MetadataObject.Type.MODEL, (Object)Capability.Scope.MODEL, (Object)MetadataObject.Type.FILESET, (Object)Capability.Scope.FILESET, (Object)MetadataObject.Type.TOPIC, (Object)Capability.Scope.TOPIC, (Object)MetadataObject.Type.COLUMN, (Object)Capability.Scope.COLUMN);
    private static final Map<Entity.EntityType, Class<?>> ENTITY_CLASS_MAPPING = ImmutableMap.builder().put((Object)Entity.EntityType.METALAKE, BaseMetalake.class).put((Object)Entity.EntityType.CATALOG, CatalogEntity.class).put((Object)Entity.EntityType.SCHEMA, SchemaEntity.class).put((Object)Entity.EntityType.TABLE, TableEntity.class).put((Object)Entity.EntityType.FILESET, FilesetEntity.class).put((Object)Entity.EntityType.MODEL, ModelEntity.class).put((Object)Entity.EntityType.TOPIC, TopicEntity.class).put((Object)Entity.EntityType.TAG, TagEntity.class).put((Object)Entity.EntityType.MODEL_VERSION, ModelVersionEntity.class).put((Object)Entity.EntityType.COLUMN, ColumnEntity.class).put((Object)Entity.EntityType.USER, UserEntity.class).put((Object)Entity.EntityType.GROUP, GroupEntity.class).put((Object)Entity.EntityType.ROLE, RoleEntity.class).build();

    private MetadataIdConverter() {
    }

    public static Long getID(MetadataObject metadataObject, String metalake) {
        Entity entity;
        Preconditions.checkArgument((metadataObject != null ? 1 : 0) != 0, (Object)"Metadata object cannot be null");
        EntityStore entityStore = GravitinoEnv.getInstance().entityStore();
        CatalogManager catalogManager = GravitinoEnv.getInstance().catalogManager();
        MetadataObject.Type metadataType = metadataObject.type();
        NameIdentifier ident = MetadataObjectUtil.toEntityIdent((String)metalake, (MetadataObject)metadataObject);
        NameIdentifier normalizedIdent = MetadataIdConverter.normalizeCaseSensitive(ident, METADATA_SCOPE_MAPPING.get(metadataType), catalogManager);
        Entity.EntityType entityType = MetadataIdConverter.getEntityType(metadataType);
        try {
            entity = entityStore.get(normalizedIdent, entityType, MetadataIdConverter.getEntityClass(entityType));
        }
        catch (IOException e) {
            throw new RuntimeException("failed to load entity from entity store: " + metadataObject.fullName(), e);
        }
        return MetadataIdConverter.extractIdFromEntity(entity);
    }

    @VisibleForTesting
    static NameIdentifier normalizeCaseSensitive(NameIdentifier ident, Capability.Scope scope, CatalogManager catalogManager) {
        if (scope == null) {
            return ident;
        }
        Capability capability = CapabilityHelpers.getCapability((NameIdentifier)ident, (CatalogManager)catalogManager);
        return CapabilityHelpers.applyCaseSensitive((NameIdentifier)ident, (Capability.Scope)scope, (Capability)capability);
    }

    private static Entity.EntityType getEntityType(MetadataObject.Type metadataType) {
        return METADATA_TO_ENTITY_TYPE_MAPPING.get(metadataType);
    }

    private static Long extractIdFromEntity(Entity entity) {
        Preconditions.checkArgument((boolean)(entity instanceof HasIdentifier), (Object)"Entity must implement HasIdentifier interface");
        return ((HasIdentifier)entity).id();
    }

    private static <E extends Entity & HasIdentifier> Class<E> getEntityClass(Entity.EntityType entityType) {
        Class<?> clazz = ENTITY_CLASS_MAPPING.get(entityType);
        return clazz;
    }
}

