/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.session;

import com.google.common.base.Preconditions;
import java.sql.SQLException;
import java.time.Duration;
import java.util.ServiceLoader;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.pool2.impl.BaseObjectPoolConfig;
import org.apache.gravitino.Config;
import org.apache.gravitino.Configs;
import org.apache.gravitino.GravitinoEnv;
import org.apache.gravitino.metrics.MetricsSystem;
import org.apache.gravitino.metrics.source.RelationDatasourceMetricsSource;
import org.apache.gravitino.storage.relational.JDBCBackend;
import org.apache.gravitino.storage.relational.mapper.provider.MapperPackageProvider;
import org.apache.gravitino.utils.JdbcUrlUtils;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.transaction.jdbc.JdbcTransactionFactory;

public class SqlSessionFactoryHelper {
    private static volatile SqlSessionFactory sqlSessionFactory;
    private static final SqlSessionFactoryHelper INSTANCE;

    public static SqlSessionFactoryHelper getInstance() {
        return INSTANCE;
    }

    private SqlSessionFactoryHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init(Config config) {
        BasicDataSource dataSource = new BasicDataSource();
        String jdbcUrl = config.get(Configs.ENTITY_RELATIONAL_JDBC_BACKEND_URL);
        String driverClass = config.get(Configs.ENTITY_RELATIONAL_JDBC_BACKEND_DRIVER);
        JdbcUrlUtils.validateJdbcConfig((String)jdbcUrl, (String)driverClass, config.getAllConfig());
        JDBCBackend.JDBCBackendType jdbcType = JDBCBackend.JDBCBackendType.fromURI(jdbcUrl);
        dataSource.setUrl(jdbcUrl);
        dataSource.setDriverClassName(driverClass);
        dataSource.setUsername(config.get(Configs.ENTITY_RELATIONAL_JDBC_BACKEND_USER));
        dataSource.setPassword(config.get(Configs.ENTITY_RELATIONAL_JDBC_BACKEND_PASSWORD));
        dataSource.setDefaultAutoCommit(Boolean.valueOf(false));
        dataSource.setMaxWaitMillis(config.get(Configs.ENTITY_RELATIONAL_JDBC_BACKEND_WAIT_MILLISECONDS).longValue());
        dataSource.setMaxTotal(config.get(Configs.ENTITY_RELATIONAL_JDBC_BACKEND_MAX_CONNECTIONS).intValue());
        dataSource.setMaxIdle(5);
        dataSource.setMinIdle(0);
        dataSource.setLogAbandoned(true);
        dataSource.setRemoveAbandonedOnBorrow(true);
        dataSource.setRemoveAbandonedTimeout(60);
        dataSource.setTimeBetweenEvictionRunsMillis(Duration.ofMillis(600000L).toMillis());
        dataSource.setTestOnBorrow(true);
        dataSource.setTestWhileIdle(true);
        dataSource.setMinEvictableIdleTimeMillis(1000L);
        dataSource.setNumTestsPerEvictionRun(3);
        dataSource.setTestOnReturn(false);
        dataSource.setSoftMinEvictableIdleTimeMillis(BaseObjectPoolConfig.DEFAULT_SOFT_MIN_EVICTABLE_IDLE_TIME.toMillis());
        dataSource.setLifo(true);
        MetricsSystem metricsSystem = GravitinoEnv.getInstance().metricsSystem();
        if (metricsSystem != null) {
            metricsSystem.register(new RelationDatasourceMetricsSource(dataSource));
        }
        JdbcTransactionFactory transactionFactory = new JdbcTransactionFactory();
        Environment environment = new Environment("development", (TransactionFactory)transactionFactory, (DataSource)dataSource);
        Configuration configuration = new Configuration(environment);
        configuration.setDatabaseId(jdbcType.name().toLowerCase());
        ServiceLoader<MapperPackageProvider> loader = ServiceLoader.load(MapperPackageProvider.class);
        for (MapperPackageProvider provider : loader) {
            configuration.addMappers(provider.getPackageName());
        }
        if (sqlSessionFactory != null) return;
        Class<SqlSessionFactoryHelper> clazz = SqlSessionFactoryHelper.class;
        synchronized (SqlSessionFactoryHelper.class) {
            if (sqlSessionFactory != null) return;
            sqlSessionFactory = new SqlSessionFactoryBuilder().build(configuration);
            // ** MonitorExit[var11_11] (shouldn't be in output)
            return;
        }
    }

    public SqlSessionFactory getSqlSessionFactory() {
        Preconditions.checkState((sqlSessionFactory != null ? 1 : 0) != 0, (Object)"SqlSessionFactory is not initialized.");
        return sqlSessionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void close() {
        if (sqlSessionFactory == null) return;
        Class<SqlSessionFactoryHelper> clazz = SqlSessionFactoryHelper.class;
        synchronized (SqlSessionFactoryHelper.class) {
            if (sqlSessionFactory == null) return;
            try {
                BasicDataSource dataSource = (BasicDataSource)sqlSessionFactory.getConfiguration().getEnvironment().getDataSource();
                dataSource.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            sqlSessionFactory = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    static {
        INSTANCE = new SqlSessionFactoryHelper();
    }
}

