/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.client.BaseSchemaCatalog;
import org.apache.gravitino.client.DTOConverters;
import org.apache.gravitino.client.ErrorHandlers;
import org.apache.gravitino.client.GenericModel;
import org.apache.gravitino.client.GenericModelVersion;
import org.apache.gravitino.client.RESTClient;
import org.apache.gravitino.dto.AuditDTO;
import org.apache.gravitino.dto.CatalogDTO;
import org.apache.gravitino.dto.requests.ModelRegisterRequest;
import org.apache.gravitino.dto.requests.ModelUpdatesRequest;
import org.apache.gravitino.dto.requests.ModelVersionLinkRequest;
import org.apache.gravitino.dto.requests.ModelVersionUpdatesRequest;
import org.apache.gravitino.dto.responses.BaseResponse;
import org.apache.gravitino.dto.responses.DropResponse;
import org.apache.gravitino.dto.responses.EntityListResponse;
import org.apache.gravitino.dto.responses.ModelResponse;
import org.apache.gravitino.dto.responses.ModelVersionListResponse;
import org.apache.gravitino.dto.responses.ModelVersionResponse;
import org.apache.gravitino.exceptions.ModelAlreadyExistsException;
import org.apache.gravitino.exceptions.ModelVersionAliasesAlreadyExistException;
import org.apache.gravitino.exceptions.NoSuchModelException;
import org.apache.gravitino.exceptions.NoSuchModelVersionException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.model.Model;
import org.apache.gravitino.model.ModelCatalog;
import org.apache.gravitino.model.ModelChange;
import org.apache.gravitino.model.ModelVersion;
import org.apache.gravitino.model.ModelVersionChange;
import org.apache.gravitino.rest.RESTRequest;
import org.apache.gravitino.rest.RESTUtils;

class GenericModelCatalog
extends BaseSchemaCatalog
implements ModelCatalog {
    GenericModelCatalog(Namespace namespace, String catalogName, Catalog.Type catalogType, String provider, String comment, Map<String, String> properties, AuditDTO auditDTO, RESTClient restClient) {
        super(namespace, catalogName, catalogType, provider, comment, properties, auditDTO, restClient);
    }

    public ModelCatalog asModelCatalog() {
        return this;
    }

    public NameIdentifier[] listModels(Namespace namespace) throws NoSuchSchemaException {
        this.checkModelNamespace(namespace);
        Namespace modelFullNs = this.modelFullNamespace(namespace);
        EntityListResponse resp = this.restClient.get(GenericModelCatalog.formatModelRequestPath(modelFullNs), EntityListResponse.class, Collections.emptyMap(), ErrorHandlers.modelErrorHandler());
        resp.validate();
        return (NameIdentifier[])Arrays.stream(resp.identifiers()).map(id -> NameIdentifier.of((String[])new String[]{id.namespace().level(2), id.name()})).toArray(NameIdentifier[]::new);
    }

    public Model getModel(NameIdentifier ident) throws NoSuchModelException {
        this.checkModelNameIdentifier(ident);
        Namespace modelFullNs = this.modelFullNamespace(ident.namespace());
        ModelResponse resp = this.restClient.get(GenericModelCatalog.formatModelRequestPath(modelFullNs) + "/" + RESTUtils.encodeString((String)ident.name()), ModelResponse.class, Collections.emptyMap(), ErrorHandlers.modelErrorHandler());
        resp.validate();
        return new GenericModel(resp.getModel(), this.restClient, modelFullNs);
    }

    public Model registerModel(NameIdentifier ident, String comment, Map<String, String> properties) throws NoSuchSchemaException, ModelAlreadyExistsException {
        this.checkModelNameIdentifier(ident);
        Namespace modelFullNs = this.modelFullNamespace(ident.namespace());
        ModelRegisterRequest req = new ModelRegisterRequest(ident.name(), comment, properties);
        req.validate();
        ModelResponse resp = this.restClient.post(GenericModelCatalog.formatModelRequestPath(modelFullNs), (RESTRequest)req, ModelResponse.class, Collections.emptyMap(), ErrorHandlers.modelErrorHandler());
        resp.validate();
        return new GenericModel(resp.getModel(), this.restClient, modelFullNs);
    }

    public boolean deleteModel(NameIdentifier ident) {
        this.checkModelNameIdentifier(ident);
        Namespace modelFullNs = this.modelFullNamespace(ident.namespace());
        DropResponse resp = this.restClient.delete(GenericModelCatalog.formatModelRequestPath(modelFullNs) + "/" + RESTUtils.encodeString((String)ident.name()), DropResponse.class, Collections.emptyMap(), ErrorHandlers.modelErrorHandler());
        resp.validate();
        return resp.dropped();
    }

    public int[] listModelVersions(NameIdentifier ident) throws NoSuchModelException {
        this.checkModelNameIdentifier(ident);
        NameIdentifier modelFullIdent = this.modelFullNameIdentifier(ident);
        ModelVersionListResponse resp = this.restClient.get(GenericModelCatalog.formatModelVersionRequestPath(modelFullIdent) + "/versions", ModelVersionListResponse.class, Collections.emptyMap(), ErrorHandlers.modelErrorHandler());
        resp.validate();
        return resp.getVersions();
    }

    public ModelVersion getModelVersion(NameIdentifier ident, int version) throws NoSuchModelVersionException {
        this.checkModelNameIdentifier(ident);
        Preconditions.checkArgument((version >= 0 ? 1 : 0) != 0, (Object)"Model version must be non-negative");
        NameIdentifier modelFullIdent = this.modelFullNameIdentifier(ident);
        ModelVersionResponse resp = this.restClient.get(GenericModelCatalog.formatModelVersionRequestPath(modelFullIdent) + "/versions/" + version, ModelVersionResponse.class, Collections.emptyMap(), ErrorHandlers.modelErrorHandler());
        resp.validate();
        return new GenericModelVersion(resp.getModelVersion());
    }

    public ModelVersion getModelVersion(NameIdentifier ident, String alias) throws NoSuchModelVersionException {
        this.checkModelNameIdentifier(ident);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)alias), (Object)"Model alias must be non-empty");
        NameIdentifier modelFullIdent = this.modelFullNameIdentifier(ident);
        ModelVersionResponse resp = this.restClient.get(GenericModelCatalog.formatModelVersionRequestPath(modelFullIdent) + "/aliases/" + RESTUtils.encodeString((String)alias), ModelVersionResponse.class, Collections.emptyMap(), ErrorHandlers.modelErrorHandler());
        resp.validate();
        return new GenericModelVersion(resp.getModelVersion());
    }

    public void linkModelVersion(NameIdentifier ident, String uri, String[] aliases, String comment, Map<String, String> properties) throws NoSuchModelException, ModelVersionAliasesAlreadyExistException {
        this.checkModelNameIdentifier(ident);
        ModelVersionLinkRequest req = new ModelVersionLinkRequest(uri, aliases, comment, properties);
        NameIdentifier modelFullIdent = this.modelFullNameIdentifier(ident);
        BaseResponse resp = this.restClient.post(GenericModelCatalog.formatModelVersionRequestPath(modelFullIdent) + "/versions", (RESTRequest)req, BaseResponse.class, Collections.emptyMap(), ErrorHandlers.modelErrorHandler());
        resp.validate();
    }

    public boolean deleteModelVersion(NameIdentifier ident, int version) {
        this.checkModelNameIdentifier(ident);
        Preconditions.checkArgument((version >= 0 ? 1 : 0) != 0, (Object)"Model version must be non-negative");
        NameIdentifier modelFullIdent = this.modelFullNameIdentifier(ident);
        DropResponse resp = this.restClient.delete(GenericModelCatalog.formatModelVersionRequestPath(modelFullIdent) + "/versions/" + version, DropResponse.class, Collections.emptyMap(), ErrorHandlers.modelErrorHandler());
        resp.validate();
        return resp.dropped();
    }

    public boolean deleteModelVersion(NameIdentifier ident, String alias) {
        this.checkModelNameIdentifier(ident);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)alias), (Object)"Model alias must be non-empty");
        NameIdentifier modelFullIdent = this.modelFullNameIdentifier(ident);
        DropResponse resp = this.restClient.delete(GenericModelCatalog.formatModelVersionRequestPath(modelFullIdent) + "/aliases/" + RESTUtils.encodeString((String)alias), DropResponse.class, Collections.emptyMap(), ErrorHandlers.modelErrorHandler());
        resp.validate();
        return resp.dropped();
    }

    public Model alterModel(NameIdentifier ident, ModelChange ... changes) throws NoSuchModelException, IllegalArgumentException {
        this.checkModelNameIdentifier(ident);
        List updateRequests = Arrays.stream(changes).map(DTOConverters::toModelUpdateRequest).collect(Collectors.toList());
        ModelUpdatesRequest req = new ModelUpdatesRequest(updateRequests);
        req.validate();
        Namespace modelFullNs = this.modelFullNamespace(ident.namespace());
        ModelResponse resp = this.restClient.put(GenericModelCatalog.formatModelRequestPath(modelFullNs) + "/" + RESTUtils.encodeString((String)ident.name()), (RESTRequest)req, ModelResponse.class, Collections.emptyMap(), ErrorHandlers.modelErrorHandler());
        resp.validate();
        return new GenericModel(resp.getModel(), this.restClient, modelFullNs);
    }

    public ModelVersion alterModelVersion(NameIdentifier ident, int version, ModelVersionChange ... changes) throws NoSuchModelException, NoSuchModelVersionException, IllegalArgumentException {
        this.checkModelNameIdentifier(ident);
        List updateRequests = Arrays.stream(changes).map(DTOConverters::toModelVersionUpdateRequest).collect(Collectors.toList());
        ModelVersionUpdatesRequest req = new ModelVersionUpdatesRequest(updateRequests);
        req.validate();
        NameIdentifier modelFullIdent = this.modelFullNameIdentifier(ident);
        ModelVersionResponse resp = this.restClient.put(GenericModelCatalog.formatModelVersionRequestPath(modelFullIdent) + "/versions/" + version, (RESTRequest)req, ModelVersionResponse.class, Collections.emptyMap(), ErrorHandlers.modelErrorHandler());
        resp.validate();
        return new GenericModelVersion(resp.getModelVersion());
    }

    public ModelVersion alterModelVersion(NameIdentifier ident, String alias, ModelVersionChange ... changes) throws NoSuchModelException, IllegalArgumentException {
        this.checkModelNameIdentifier(ident);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)alias), (Object)"Model alias must be non-empty");
        List updateRequests = Arrays.stream(changes).map(DTOConverters::toModelVersionUpdateRequest).collect(Collectors.toList());
        ModelVersionUpdatesRequest req = new ModelVersionUpdatesRequest(updateRequests);
        req.validate();
        NameIdentifier modelFullIdent = this.modelFullNameIdentifier(ident);
        ModelVersionResponse resp = this.restClient.put(GenericModelCatalog.formatModelVersionRequestPath(modelFullIdent) + "/aliases/" + RESTUtils.encodeString((String)alias), (RESTRequest)req, ModelVersionResponse.class, Collections.emptyMap(), ErrorHandlers.modelErrorHandler());
        resp.validate();
        return new GenericModelVersion(resp.getModelVersion());
    }

    public static Builder builder() {
        return new Builder();
    }

    private void checkModelNamespace(Namespace namespace) {
        Namespace.check((namespace != null && namespace.length() == 1 ? 1 : 0) != 0, (String)"Model namespace must be non-null and only have 1 level, the input namespace is %s", (Object[])new Object[]{namespace});
    }

    private void checkModelNameIdentifier(NameIdentifier ident) {
        NameIdentifier.check((ident != null ? 1 : 0) != 0, (String)"Model name identifier must be non-null", (Object[])new Object[0]);
        NameIdentifier.check((boolean)StringUtils.isNotBlank((CharSequence)ident.name()), (String)"Model name identifier must have a non-empty name", (Object[])new Object[0]);
        this.checkModelNamespace(ident.namespace());
    }

    private Namespace modelFullNamespace(Namespace modelNs) {
        return Namespace.of((String[])new String[]{this.catalogNamespace().level(0), this.name(), modelNs.level(0)});
    }

    private NameIdentifier modelFullNameIdentifier(NameIdentifier modelIdent) {
        return NameIdentifier.of((Namespace)this.modelFullNamespace(modelIdent.namespace()), (String)modelIdent.name());
    }

    @VisibleForTesting
    static String formatModelRequestPath(Namespace modelNs) {
        Namespace schemaNs = Namespace.of((String[])new String[]{modelNs.level(0), modelNs.level(1)});
        return GenericModelCatalog.formatSchemaRequestPath(schemaNs) + "/" + RESTUtils.encodeString((String)modelNs.level(2)) + "/models";
    }

    @VisibleForTesting
    static String formatModelVersionRequestPath(NameIdentifier modelIdent) {
        return GenericModelCatalog.formatModelRequestPath(modelIdent.namespace()) + "/" + RESTUtils.encodeString((String)modelIdent.name());
    }

    static class Builder
    extends CatalogDTO.Builder<Builder> {
        private RESTClient restClient;
        private Namespace namespace;

        private Builder() {
        }

        Builder withNamespace(Namespace namespace) {
            this.namespace = namespace;
            return this;
        }

        Builder withRestClient(RESTClient restClient) {
            this.restClient = restClient;
            return this;
        }

        public GenericModelCatalog build() {
            Namespace.check((this.namespace != null && this.namespace.length() == 1 ? 1 : 0) != 0, (String)"Catalog namespace must be non-null and have 1 level, the input namespace is %s", (Object[])new Object[]{this.namespace});
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.name), (Object)"name must not be blank");
            Preconditions.checkArgument((this.type != null ? 1 : 0) != 0, (Object)"type must not be null");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.provider), (Object)"provider must not be blank");
            Preconditions.checkArgument((this.audit != null ? 1 : 0) != 0, (Object)"audit must not be null");
            Preconditions.checkArgument((this.restClient != null ? 1 : 0) != 0, (Object)"restClient must be set");
            return new GenericModelCatalog(this.namespace, this.name, this.type, this.provider, this.comment, this.properties, this.audit, this.restClient);
        }
    }
}

