/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.gobblin.writer;

import java.io.IOException;

import org.apache.orc.storage.ql.exec.vector.VectorizedRowBatch;


/**
 * Write data value of a schema.
 * @param <T> Indicating the input type, {@link org.apache.avro.generic.GenericRecord} for example.
 */
public interface OrcValueWriter<T> {

  /**
   * Writes the data.
   * @param value the data value to write.
   * @param output the VectorizedRowBatch to which the output will be written.
   * @throws IOException if there's any IO error while writing the data value.
   */
  void write(T value, VectorizedRowBatch output)
      throws IOException;
}