/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.gobblin.crypto.CredentialStore;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCEKSKeystoreCredentialStore
implements CredentialStore {
    private static final Logger log = LoggerFactory.getLogger(JCEKSKeystoreCredentialStore.class);
    public static final String TAG = "java";
    private final KeyStore ks;
    private final char[] password;
    private final Path path;
    private final FileSystem fs;

    public JCEKSKeystoreCredentialStore(String path, String passwordStr) throws IOException {
        this(path, passwordStr, EnumSet.noneOf(CreationOptions.class));
    }

    public JCEKSKeystoreCredentialStore(String path, String passwordStr, EnumSet<CreationOptions> options) throws IOException {
        this(new Path(path), passwordStr, options);
    }

    public JCEKSKeystoreCredentialStore(Path path, String passwordStr, EnumSet<CreationOptions> options) throws IOException {
        block16: {
            try {
                this.ks = KeyStore.getInstance("JCEKS");
                this.password = passwordStr.toCharArray();
                this.path = path;
                this.fs = path.getFileSystem(new Configuration());
                if (!this.fs.exists(path)) {
                    if (options.contains((Object)CreationOptions.CREATE_IF_MISSING)) {
                        log.info("No keystore found at " + path + ", creating from scratch");
                        this.ks.load(null, this.password);
                        break block16;
                    }
                    throw new IllegalArgumentException("Keystore " + path + " does not exist");
                }
                try (FSDataInputStream fis = this.fs.open(path);){
                    this.ks.load((InputStream)fis, this.password);
                    log.info("Successfully loaded keystore from " + path);
                }
            }
            catch (KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new IllegalStateException("Unexpected failure initializing keystore", e);
            }
        }
    }

    public byte[] getEncodedKey(String id) {
        try {
            Key k = this.ks.getKey(id, this.password);
            return k == null ? null : k.getEncoded();
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            log.warn("Error trying to decode key " + id, (Throwable)e);
            return null;
        }
    }

    public Map<String, byte[]> getAllEncodedKeys() {
        HashMap<String, byte[]> ret = new HashMap<String, byte[]>();
        try {
            Enumeration<String> aliases = this.ks.aliases();
            while (aliases.hasMoreElements()) {
                String key = aliases.nextElement();
                try {
                    if (!this.ks.isKeyEntry(key)) continue;
                    ret.put(key, this.getEncodedKey(key));
                }
                catch (KeyStoreException e) {
                    log.warn("Error trying to decode key id " + key + ", not returning in list", (Throwable)e);
                }
            }
        }
        catch (KeyStoreException e) {
            log.warn("Error retrieving all aliases in keystore; treating as empty", (Throwable)e);
            return ret;
        }
        return ret;
    }

    public void generateAesKeys(int numKeys, int startOffset) throws IOException, KeyStoreException {
        for (int i = 1; i <= numKeys; ++i) {
            SecretKey key = this.generateKey();
            this.ks.setEntry(String.valueOf(i + startOffset), new KeyStore.SecretKeyEntry(key), new KeyStore.PasswordProtection(this.password));
        }
        this.saveKeystore();
    }

    private SecretKey generateKey() {
        SecureRandom r = new SecureRandom();
        byte[] keyBytes = new byte[16];
        r.nextBytes(keyBytes);
        return new SecretKeySpec(keyBytes, "AES");
    }

    private void saveKeystore() throws IOException {
        try (FSDataOutputStream fOs = this.fs.create(this.path, true);){
            this.ks.store((OutputStream)fOs, this.password);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new IOException("Error serializing keystore", e);
        }
    }

    public static enum CreationOptions {
        CREATE_IF_MISSING;

    }
}

