/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.converter;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import org.apache.gobblin.codec.StreamCodec;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.Converter;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.converter.SchemaConversionException;
import org.apache.gobblin.type.RecordWithMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SerializedRecordToEncryptedSerializedRecordConverterBase
extends Converter<String, String, RecordWithMetadata<byte[]>, RecordWithMetadata<byte[]>> {
    private static final Logger log = LoggerFactory.getLogger(SerializedRecordToEncryptedSerializedRecordConverterBase.class);
    private StreamCodec encryptor;

    public Converter<String, String, RecordWithMetadata<byte[]>, RecordWithMetadata<byte[]>> init(WorkUnitState workUnit) {
        super.init(workUnit);
        this.encryptor = this.buildEncryptor(workUnit);
        return this;
    }

    protected abstract StreamCodec buildEncryptor(WorkUnitState var1);

    public String convertSchema(String inputSchema, WorkUnitState workUnit) throws SchemaConversionException {
        return "";
    }

    public Iterable<RecordWithMetadata<byte[]>> convertRecord(String outputSchema, RecordWithMetadata<byte[]> inputRecord, WorkUnitState workUnit) throws DataConversionException {
        try {
            ByteArrayOutputStream bOs = new ByteArrayOutputStream();
            try (OutputStream encryptedStream = this.encryptor.encodeOutputStream((OutputStream)bOs);){
                encryptedStream.write((byte[])inputRecord.getRecord());
            }
            inputRecord.getMetadata().getGlobalMetadata().addTransferEncoding(this.encryptor.getTag());
            RecordWithMetadata serializedRecord = new RecordWithMetadata((Object)bOs.toByteArray(), inputRecord.getMetadata());
            return Collections.singleton(serializedRecord);
        }
        catch (Exception e) {
            throw new DataConversionException((Throwable)e);
        }
    }
}

