/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.aws;

import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import java.io.File;
import java.util.List;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.aws.GobblinAWSClusterManager;
import org.apache.gobblin.aws.GobblinAWSTaskRunner;
import org.apache.gobblin.aws.GobblinAWSUtils;
import org.apache.gobblin.util.JvmUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alpha
public class CloudInitScriptBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(CloudInitScriptBuilder.class);
    private static final Splitter SPLITTER = Splitter.on((String)",").trimResults().omitEmptyStrings();
    private static final String STDOUT = "stdout";
    private static final String STDERR = "stderr";
    private static final String NFS_SHARE_ALL_IPS = "*";
    private static final String NFS_SHARE_DEFAULT_OPTS = "rw,sync,no_subtree_check,fsid=1,no_root_squash";
    private static final String NFS_CONF_FILE = "/etc/exports";
    private static final String NFS_SERVER_INSTALL_CMD = "yum install nfs-utils nfs-utils-lib";
    private static final String NFS_SERVER_START_CMD = "/etc/init.d/nfs start";
    private static final String NFS_EXPORT_FS_CMD = "exportfs -a";
    private static final String NFS_TYPE_4 = "nfs4";

    public static String buildClusterMasterCommand(String clusterName, String nfsParentDir, String sinkLogRootDir, String awsConfDir, String appWorkDir, String masterS3ConfUri, String masterS3ConfFiles, String masterS3JarsUri, String masterS3JarsFiles, String masterJarsDir, String masterJvmMemory, Optional<String> masterJvmArgs, Optional<String> gobblinVersion) {
        StringBuilder cloudInitCmds = new StringBuilder().append("#!/bin/bash").append("\n");
        String clusterMasterClassName = GobblinAWSClusterManager.class.getSimpleName();
        String nfsDir = nfsParentDir + clusterName;
        String nfsShareDirCmd = String.format("echo '%s %s(%s)' | tee --append %s", nfsDir, NFS_SHARE_ALL_IPS, NFS_SHARE_DEFAULT_OPTS, NFS_CONF_FILE);
        cloudInitCmds.append("mkdir -p ").append(nfsDir).append(File.separator).append("1").append("\n");
        cloudInitCmds.append(NFS_SERVER_INSTALL_CMD).append("\n");
        cloudInitCmds.append(nfsShareDirCmd).append("\n");
        cloudInitCmds.append(NFS_SERVER_START_CMD).append("\n");
        cloudInitCmds.append(NFS_EXPORT_FS_CMD).append("\n");
        cloudInitCmds.append("mkdir -p ").append(sinkLogRootDir).append("\n");
        cloudInitCmds.append("chown -R ec2-user:ec2-user /home/ec2-user/*").append("\n");
        if (gobblinVersion.isPresent()) {
            cloudInitCmds.append("vr=").append((String)gobblinVersion.get()).append("\n");
        }
        cloudInitCmds.append("cgS3=").append(masterS3ConfUri).append("\n");
        cloudInitCmds.append("cg=").append(awsConfDir).append("\n");
        cloudInitCmds.append("jrS3=").append(masterS3JarsUri).append("\n");
        cloudInitCmds.append("jr=").append(masterJarsDir).append("\n");
        StringBuilder classpath = new StringBuilder();
        List awsConfs = SPLITTER.splitToList((CharSequence)masterS3ConfFiles);
        for (Object awsConf : awsConfs) {
            cloudInitCmds.append(String.format("wget -P \"${cg}\" \"${cgS3}\"%s", awsConf)).append("\n");
        }
        classpath.append(awsConfDir);
        List awsJars = SPLITTER.splitToList((CharSequence)masterS3JarsFiles);
        for (String awsJar : awsJars) {
            cloudInitCmds.append(String.format("wget -P \"${jr}\" \"${jrS3}\"%s", awsJar)).append("\n");
        }
        classpath.append(":").append(masterJarsDir).append(NFS_SHARE_ALL_IPS);
        StringBuilder launchGobblinClusterMasterCmd = new StringBuilder().append("java").append(" -cp ").append((CharSequence)classpath).append(" -Xmx").append(masterJvmMemory).append(" ").append(JvmUtils.formatJvmArguments(masterJvmArgs)).append(" ").append(GobblinAWSClusterManager.class.getName()).append(" --").append("app_name").append(" ").append(clusterName).append(" --").append("gobblin.aws.work.dir").append(" ").append(appWorkDir).append(" 1>").append(sinkLogRootDir).append(clusterMasterClassName).append(".").append("master").append(".").append(STDOUT).append(" 2>").append(sinkLogRootDir).append(clusterMasterClassName).append(".").append("master").append(".").append(STDERR);
        cloudInitCmds.append((CharSequence)launchGobblinClusterMasterCmd).append("\n");
        String cloudInitScript = cloudInitCmds.toString();
        LOGGER.info("Cloud-init script for master node: " + cloudInitScript);
        return GobblinAWSUtils.encodeBase64(cloudInitScript);
    }

    public static String buildClusterWorkerCommand(String clusterName, String nfsParentDir, String sinkLogRootDir, String awsConfDir, String appWorkDir, String masterPublicIp, String workerS3ConfUri, String workerS3ConfFiles, String workerS3JarsUri, String workerS3JarsFiles, String workerJarsDir, String workerJvmMemory, Optional<String> workerJvmArgs, Optional<String> gobblinVersion) {
        StringBuilder cloudInitCmds = new StringBuilder().append("#!/bin/bash").append("\n");
        String clusterWorkerClassName = GobblinAWSTaskRunner.class.getSimpleName();
        String nfsDir = nfsParentDir + clusterName;
        String nfsMountCmd = String.format("mount -t %s %s:%s %s", NFS_TYPE_4, masterPublicIp, nfsDir, nfsDir);
        cloudInitCmds.append("mkdir -p ").append(nfsDir).append("\n");
        cloudInitCmds.append(nfsMountCmd).append("\n");
        cloudInitCmds.append("mkdir -p ").append(sinkLogRootDir).append("\n");
        cloudInitCmds.append("chown -R ec2-user:ec2-user /home/ec2-user/*").append("\n");
        if (gobblinVersion.isPresent()) {
            cloudInitCmds.append("vr=").append((String)gobblinVersion.get()).append("\n");
        }
        cloudInitCmds.append("cg0=").append(workerS3ConfUri).append("\n");
        cloudInitCmds.append("cg=").append(awsConfDir).append("\n");
        cloudInitCmds.append("jr0=").append(workerS3JarsUri).append("\n");
        cloudInitCmds.append("jr=").append(workerJarsDir).append("\n");
        StringBuilder classpath = new StringBuilder();
        List awsConfs = SPLITTER.splitToList((CharSequence)workerS3ConfFiles);
        for (Object awsConf : awsConfs) {
            cloudInitCmds.append(String.format("wget -P \"${cg}\" \"${cg0}\"%s", awsConf)).append("\n");
        }
        classpath.append(awsConfDir);
        List awsJars = SPLITTER.splitToList((CharSequence)workerS3JarsFiles);
        for (String awsJar : awsJars) {
            cloudInitCmds.append(String.format("wget -P \"${jr}\" \"${jr0}\"%s", awsJar)).append("\n");
        }
        classpath.append(":").append(workerJarsDir).append(NFS_SHARE_ALL_IPS);
        cloudInitCmds.append("pi=`curl http://169.254.169.254/latest/meta-data/local-ipv4`").append("\n");
        StringBuilder launchGobblinClusterWorkerCmd = new StringBuilder().append("java").append(" -cp ").append((CharSequence)classpath).append(" -Xmx").append(workerJvmMemory).append(" ").append(JvmUtils.formatJvmArguments(workerJvmArgs)).append(" ").append(GobblinAWSTaskRunner.class.getName()).append(" --").append("app_name").append(" ").append(clusterName).append(" --").append("helix_instance_name").append(" ").append("$pi").append(" --").append("gobblin.aws.work.dir").append(" ").append(appWorkDir).append(" 1>").append(sinkLogRootDir).append(clusterWorkerClassName).append(".").append("$pi").append(".").append(STDOUT).append(" 2>").append(sinkLogRootDir).append(clusterWorkerClassName).append(".").append("$pi").append(".").append(STDERR);
        cloudInitCmds.append((CharSequence)launchGobblinClusterWorkerCmd);
        String cloudInitScript = cloudInitCmds.toString();
        LOGGER.info("Cloud-init script for worker node: " + cloudInitScript);
        return GobblinAWSUtils.encodeBase64(cloudInitScript);
    }
}

