/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.example.wikipedia;

import avro.shaded.com.google.common.base.Joiner;
import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.commons.cli.CommandLine;
import org.apache.gobblin.annotation.Alias;
import org.apache.gobblin.example.wikipedia.WikipediaConverter;
import org.apache.gobblin.example.wikipedia.WikipediaPartitioner;
import org.apache.gobblin.publisher.BaseDataPublisher;
import org.apache.gobblin.runtime.api.JobTemplate;
import org.apache.gobblin.runtime.api.SpecNotFoundException;
import org.apache.gobblin.runtime.cli.CliObjectOption;
import org.apache.gobblin.runtime.cli.CliObjectSupport;
import org.apache.gobblin.runtime.cli.PublicMethodsGobblinCliFactory;
import org.apache.gobblin.runtime.embedded.EmbeddedGobblin;
import org.apache.gobblin.runtime.template.ResourceBasedJobTemplate;
import org.apache.gobblin.writer.AvroDataWriterBuilder;
import org.apache.gobblin.writer.Destination;
import org.apache.gobblin.writer.WriterOutputFormat;

public class EmbeddedWikipediaExample
extends EmbeddedGobblin {
    @CliObjectSupport(argumentNames={"topics"})
    public EmbeddedWikipediaExample(String ... topics) throws JobTemplate.TemplateException, IOException {
        super("Wikipedia");
        try {
            this.setTemplate((JobTemplate)ResourceBasedJobTemplate.forResourcePath((String)"wikipedia.template"));
        }
        catch (URISyntaxException | SpecNotFoundException exc) {
            throw new RuntimeException("Could not instantiate an " + EmbeddedWikipediaExample.class.getName(), exc);
        }
        this.setConfiguration("titles", Joiner.on((String)",").join((Object[])topics));
    }

    @CliObjectOption(description="Sets the period for which articles should be pulled in ISO time format (e.g. P2D, PT1H)")
    public EmbeddedWikipediaExample lookback(String isoLookback) {
        this.setConfiguration("wikipedia.source.bootstrap.lookback", isoLookback);
        return this;
    }

    @CliObjectOption(description="Write output to Avro files. Specify the output directory as argument.")
    public EmbeddedWikipediaExample avroOutput(String outputPath) {
        this.setConfiguration("writer.builder.class", AvroDataWriterBuilder.class.getName());
        this.setConfiguration("writer.destination.type", Destination.DestinationType.HDFS.name());
        this.setConfiguration("writer.output.format", WriterOutputFormat.AVRO.name());
        this.setConfiguration("writer.partitioner.class", WikipediaPartitioner.class.getName());
        this.setConfiguration("data.publisher.job.type", BaseDataPublisher.class.getName());
        this.setConfiguration("converter.classes", WikipediaConverter.class.getName());
        this.setConfiguration("data.publisher.final.dir", outputPath);
        return this;
    }

    @Alias(value="wikipedia", description="Gobblin example that downloads revisions from Wikipedia.")
    public static class CliFactory
    extends PublicMethodsGobblinCliFactory {
        public CliFactory() {
            super(EmbeddedWikipediaExample.class);
        }

        public EmbeddedGobblin constructEmbeddedGobblin(CommandLine cli) throws JobTemplate.TemplateException, IOException {
            String[] leftoverArgs = cli.getArgs();
            if (leftoverArgs.length < 1) {
                throw new RuntimeException("Unexpected number of arguments.");
            }
            return new EmbeddedWikipediaExample(leftoverArgs);
        }

        public String getUsageString() {
            return "[OPTIONS] <article-title> [<article-title> ...]";
        }
    }
}

