/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.multipart;

import com.linkedin.data.ByteString;
import com.linkedin.multipart.MultiPartMIMEReader;
import com.linkedin.multipart.SinglePartMIMEReaderCallback;
import com.linkedin.r2.message.stream.entitystream.WriteHandle;

final class SinglePartMIMEChainReaderCallback
implements SinglePartMIMEReaderCallback {
    private final WriteHandle _writeHandle;
    private final MultiPartMIMEReader.SinglePartMIMEReader _singlePartMIMEReader;

    @Override
    public void onPartDataAvailable(ByteString partData) {
        this._writeHandle.write(partData);
        if (this._writeHandle.remaining() > 0) {
            this._singlePartMIMEReader.requestPartData();
        }
    }

    @Override
    public void onFinished() {
        this._writeHandle.done();
    }

    @Override
    public void onDrainComplete() {
    }

    @Override
    public void onStreamError(Throwable throwable) {
        this._writeHandle.error(throwable);
    }

    SinglePartMIMEChainReaderCallback(WriteHandle writeHandle, MultiPartMIMEReader.SinglePartMIMEReader singlePartMIMEReader) {
        this._singlePartMIMEReader = singlePartMIMEReader;
        this._writeHandle = writeHandle;
    }
}

