/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.multipart;

import com.linkedin.data.ByteString;
import com.linkedin.multipart.MultiPartMIMEDataSourceWriter;
import com.linkedin.multipart.exceptions.MultiPartIllegalFormatException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;

public final class MultiPartMIMEUtils {
    public static final String CONTENT_TYPE_HEADER = "Content-Type";
    public static final String MULTIPART_PREFIX = "multipart/";
    public static final String BOUNDARY_PARAMETER = "boundary";
    public static final byte SPACE_BYTE = 32;
    public static final byte TAB_BYTE = 9;
    public static final String CRLF_STRING = "\r\n";
    public static final byte[] CRLF_BYTES = "\r\n".getBytes();
    public static final byte[] CONSECUTIVE_CRLFS_BYTES = "\r\n\r\n".getBytes();
    public static final ByteString BYTE_STRING_CRLF_BYTES = ByteString.copy((byte[])CRLF_BYTES);
    public static final ByteString BYTE_STRING_CONSECUTIVE_CRLFS_BYTES = ByteString.copy((byte[])CONSECUTIVE_CRLFS_BYTES);
    private static final char[] MULTIPART_CHARS = "-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();

    static void serializeHeaders(Map<String, String> headers, ByteArrayOutputStream outputStream) throws IOException {
        StringBuilder headerBuffer = new StringBuilder();
        for (Map.Entry<String, String> header : headers.entrySet()) {
            headerBuffer.append(MultiPartMIMEUtils.formattedHeader(header.getKey(), header.getValue()));
        }
        outputStream.write(headerBuffer.toString().getBytes(Charset.forName("US-ASCII")));
    }

    static String formattedHeader(String name, String value) {
        return (name == null ? "" : name) + ": " + (null == value ? "" : value) + CRLF_STRING;
    }

    static String generateBoundary() {
        StringBuilder buffer = new StringBuilder();
        Random rand = new Random();
        int count = rand.nextInt(11) + 50;
        for (int i = 0; i < count; ++i) {
            buffer.append(MULTIPART_CHARS[rand.nextInt(MULTIPART_CHARS.length)]);
        }
        return buffer.toString();
    }

    public static String buildMIMEContentTypeHeader(String mimeType, String boundary, Map<String, String> contentTypeParameters) {
        StringBuilder contentTypeBuilder = new StringBuilder();
        contentTypeBuilder.append(MULTIPART_PREFIX).append(mimeType);
        contentTypeBuilder.append("; ").append(BOUNDARY_PARAMETER).append("=").append(boundary);
        for (Map.Entry<String, String> parameter : contentTypeParameters.entrySet()) {
            if (parameter.getKey().trim().equalsIgnoreCase(BOUNDARY_PARAMETER)) continue;
            contentTypeBuilder.append("; ").append(parameter.getKey().trim()).append("=").append(parameter.getValue().trim());
        }
        return contentTypeBuilder.toString();
    }

    static String extractBoundary(String contentTypeHeader) throws MultiPartIllegalFormatException {
        if (!contentTypeHeader.toLowerCase().startsWith(MULTIPART_PREFIX)) {
            throw new MultiPartIllegalFormatException("Malformed multipart mime request. Not a valid multipart mime header.");
        }
        if (!contentTypeHeader.contains(";")) {
            throw new MultiPartIllegalFormatException("Malformed multipart mime request. Improperly formatted Content-Type header. Expected at least one parameter in addition to the content type.");
        }
        String[] contentTypeParameters = contentTypeHeader.split(";");
        TreeMap<String, String> parameterMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (String parameter : contentTypeParameters) {
            if (parameter.startsWith(MULTIPART_PREFIX)) continue;
            String trimmedParameter = parameter.trim();
            int firstEquals = trimmedParameter.indexOf("=");
            if (firstEquals == 0 || firstEquals == -1 || firstEquals == trimmedParameter.length() - 1) {
                throw new MultiPartIllegalFormatException("Invalid parameter format.");
            }
            String parameterKey = trimmedParameter.substring(0, firstEquals);
            String parameterValue = trimmedParameter.substring(firstEquals + 1, trimmedParameter.length());
            if (parameterValue.charAt(0) == '\"') {
                if (parameterValue.charAt(parameterValue.length() - 1) != '\"') {
                    throw new MultiPartIllegalFormatException("Invalid parameter format.");
                }
                parameterValue = parameterValue.substring(1, parameterValue.length() - 1);
            }
            if (parameterMap.containsKey(parameterKey)) {
                throw new MultiPartIllegalFormatException("Invalid parameter format. Multiple declarations of the same parameter!");
            }
            parameterMap.put(parameterKey, parameterValue);
        }
        String boundaryValue = (String)parameterMap.get(BOUNDARY_PARAMETER);
        if (boundaryValue == null) {
            throw new MultiPartIllegalFormatException("No boundary parameter found!");
        }
        return boundaryValue;
    }

    static ByteString serializeBoundaryAndHeaders(byte[] normalEncapsulationBoundary, MultiPartMIMEDataSourceWriter dataSource) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(normalEncapsulationBoundary);
        byteArrayOutputStream.write(CRLF_BYTES);
        if (!dataSource.dataSourceHeaders().isEmpty()) {
            MultiPartMIMEUtils.serializeHeaders(dataSource.dataSourceHeaders(), byteArrayOutputStream);
        }
        byteArrayOutputStream.write(CRLF_BYTES);
        return ByteString.unsafeWrap((byte[])byteArrayOutputStream.toByteArray());
    }
}

