/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics.reporter.util;

import com.google.common.base.Optional;
import com.google.common.io.Closer;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.JsonDecoder;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.gobblin.metrics.GobblinTrackingEvent;

public class EventUtils {
    public static final int SCHEMA_VERSION = 1;
    private static Optional<SpecificDatumReader<GobblinTrackingEvent>> reader = Optional.absent();

    public static synchronized GobblinTrackingEvent deserializeReportFromJson(GobblinTrackingEvent reuse, byte[] bytes) throws IOException {
        if (!reader.isPresent()) {
            reader = Optional.of((Object)new SpecificDatumReader(GobblinTrackingEvent.class));
        }
        try (Closer closer = Closer.create();){
            DataInputStream inputStream = (DataInputStream)closer.register((Closeable)new DataInputStream(new ByteArrayInputStream(bytes)));
            int versionNumber = inputStream.readInt();
            if (versionNumber != 1) {
                throw new IOException(String.format("MetricReport schema version not recognized. Found version %d, expected %d.", versionNumber, 1));
            }
            JsonDecoder decoder = DecoderFactory.get().jsonDecoder(GobblinTrackingEvent.SCHEMA$, (InputStream)inputStream);
            GobblinTrackingEvent gobblinTrackingEvent = (GobblinTrackingEvent)((Object)((SpecificDatumReader)reader.get()).read((Object)reuse, (Decoder)decoder));
            return gobblinTrackingEvent;
        }
    }

    public static synchronized GobblinTrackingEvent deserializeReportFromAvroSerialization(GobblinTrackingEvent reuse, byte[] bytes) throws IOException {
        if (!reader.isPresent()) {
            reader = Optional.of((Object)new SpecificDatumReader(GobblinTrackingEvent.class));
        }
        try (Closer closer = Closer.create();){
            DataInputStream inputStream = (DataInputStream)closer.register((Closeable)new DataInputStream(new ByteArrayInputStream(bytes)));
            int versionNumber = inputStream.readInt();
            if (versionNumber != 1) {
                throw new IOException(String.format("MetricReport schema version not recognized. Found version %d, expected %d.", versionNumber, 1));
            }
            BinaryDecoder decoder = DecoderFactory.get().binaryDecoder((InputStream)inputStream, null);
            GobblinTrackingEvent gobblinTrackingEvent = (GobblinTrackingEvent)((Object)((SpecificDatumReader)reader.get()).read((Object)reuse, (Decoder)decoder));
            return gobblinTrackingEvent;
        }
    }
}

