/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics.reporter;

import com.google.common.base.Charsets;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Queue;
import org.apache.gobblin.metrics.GobblinTrackingEvent;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.reporter.EventReporter;
import org.apache.gobblin.metrics.reporter.util.AvroJsonSerializer;
import org.apache.gobblin.metrics.reporter.util.AvroSerializer;
import org.apache.gobblin.metrics.reporter.util.NoopSchemaVersionWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputStreamEventReporter
extends EventReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(OutputStreamEventReporter.class);
    private static final int CONSOLE_WIDTH = 80;
    protected PrintStream output;
    protected final AvroSerializer<GobblinTrackingEvent> serializer;
    private final ByteArrayOutputStream outputBuffer;
    private final PrintStream outputBufferPrintStream;
    private final DateFormat dateFormat;

    public OutputStreamEventReporter(Builder builder) throws IOException {
        super(builder);
        this.serializer = (AvroSerializer)this.closer.register(new AvroJsonSerializer(GobblinTrackingEvent.SCHEMA$, new NoopSchemaVersionWriter()));
        this.output = builder.output;
        this.outputBuffer = new ByteArrayOutputStream();
        this.outputBufferPrintStream = (PrintStream)this.closer.register((Closeable)new PrintStream((OutputStream)this.outputBuffer, false, Charsets.UTF_8.toString()));
        this.dateFormat = DateFormat.getDateTimeInstance(3, 2, Locale.getDefault());
    }

    @Override
    public void reportEventQueue(Queue<GobblinTrackingEvent> queue) {
        GobblinTrackingEvent nextEvent;
        if (queue.size() <= 0) {
            return;
        }
        this.outputBuffer.reset();
        String dateTime = this.dateFormat.format(new Date());
        this.printWithBanner(dateTime, '=');
        this.outputBufferPrintStream.println();
        this.printWithBanner("-- Events", '-');
        while (null != (nextEvent = queue.poll())) {
            this.outputBufferPrintStream.println(new String(this.serializer.serializeRecord(nextEvent), Charsets.UTF_8));
        }
        this.outputBufferPrintStream.println();
        try {
            this.outputBuffer.writeTo(this.output);
        }
        catch (IOException exception) {
            LOGGER.warn("Failed to write events to output stream.");
        }
    }

    private void printWithBanner(String s, char c) {
        this.outputBufferPrintStream.print(s);
        this.outputBufferPrintStream.print(' ');
        for (int i = 0; i < 80 - s.length() - 1; ++i) {
            this.outputBufferPrintStream.print(c);
        }
        this.outputBufferPrintStream.println();
    }

    public static Builder<? extends Builder> forContext(MetricContext context) {
        return new BuilderImpl(context);
    }

    public static abstract class Builder<T extends Builder<T>>
    extends EventReporter.Builder<T> {
        protected PrintStream output = System.out;

        public Builder(MetricContext context) {
            super(context);
        }

        public T outputTo(PrintStream output) {
            this.output = output;
            return (T)((Builder)this.self());
        }

        public T outputTo(OutputStream stream) {
            try {
                this.output = new PrintStream(stream, false, Charsets.UTF_8.toString());
            }
            catch (UnsupportedEncodingException exception) {
                LOGGER.error("Unsupported encoding in OutputStreamReporter. This is an error with the code itself.", (Throwable)exception);
                throw new RuntimeException(exception);
            }
            return (T)((Builder)this.self());
        }

        public OutputStreamEventReporter build() throws IOException {
            return new OutputStreamEventReporter(this);
        }
    }

    private static class BuilderImpl
    extends Builder<BuilderImpl> {
        public BuilderImpl(MetricContext context) {
            super(context);
        }

        @Override
        protected BuilderImpl self() {
            return this;
        }
    }
}

