/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics.reporter;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Timer;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.common.io.Closer;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.Closeable;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.SortedMap;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.gobblin.metrics.GobblinTrackingEvent;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.notification.EventNotification;
import org.apache.gobblin.metrics.notification.Notification;
import org.apache.gobblin.util.ExecutorsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EventReporter
extends ScheduledReporter
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(EventReporter.class);
    protected static final Joiner JOINER = Joiner.on((char)'.').skipNulls();
    protected static final String METRIC_KEY_PREFIX = "gobblin.metrics";
    protected static final String EVENTS_QUALIFIER = "events";
    private static final Logger LOGGER = LoggerFactory.getLogger(EventReporter.class);
    private static final int QUEUE_CAPACITY = 100;
    private static final String NULL_STRING = "null";
    private final MetricContext metricContext;
    private final BlockingQueue<GobblinTrackingEvent> reportingQueue;
    private final ExecutorService immediateReportExecutor;
    private final UUID notificationTargetKey;
    protected final Closer closer = Closer.create();

    public EventReporter(Builder builder) {
        super((MetricRegistry)builder.context, builder.name, builder.filter, builder.rateUnit, builder.durationUnit);
        this.immediateReportExecutor = MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)((ThreadPoolExecutor)Executors.newFixedThreadPool(1, ExecutorsUtils.newThreadFactory((Optional)Optional.of((Object)LOGGER), (Optional)Optional.of((Object)("EventReporter-" + builder.name + "-%d"))))), (long)5L, (TimeUnit)TimeUnit.MINUTES);
        this.metricContext = builder.context;
        this.notificationTargetKey = builder.context.addNotificationTarget(new Function<Notification, Void>(){

            @Nullable
            public Void apply(Notification notification) {
                EventReporter.this.notificationCallback(notification);
                return null;
            }
        });
        this.reportingQueue = Queues.newLinkedBlockingQueue((int)100);
    }

    public void notificationCallback(Notification notification) {
        if (notification instanceof EventNotification) {
            this.addEventToReportingQueue(((EventNotification)notification).getEvent());
        }
    }

    public void addEventToReportingQueue(GobblinTrackingEvent event) {
        if (this.reportingQueue.size() > 66) {
            this.immediatelyScheduleReport();
        }
        try {
            if (!this.reportingQueue.offer(EventReporter.sanitizeEvent(event), 10L, TimeUnit.SECONDS)) {
                log.error("Enqueuing of event {} at reporter with class {} timed out. Sending of events is probably stuck.", (Object)event, (Object)this.getClass().getCanonicalName());
            }
        }
        catch (InterruptedException ie) {
            log.warn("Enqueuing of event {} at reporter with class {} was interrupted.", new Object[]{event, this.getClass().getCanonicalName(), ie});
        }
    }

    public void report() {
        this.reportEventQueue(this.reportingQueue);
    }

    public abstract void reportEventQueue(Queue<GobblinTrackingEvent> var1);

    public final void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
    }

    protected String getMetricName(Map<String, String> metadata, String eventName) {
        return JOINER.join((Object)METRIC_KEY_PREFIX, (Object)metadata.get("jobId"), new Object[]{metadata.get("taskId"), EVENTS_QUALIFIER, eventName});
    }

    private void immediatelyScheduleReport() {
        this.immediateReportExecutor.submit(new Runnable(){

            @Override
            public void run() {
                EventReporter.this.report();
            }
        });
    }

    @Override
    public void close() {
        try {
            this.metricContext.removeNotificationTarget(this.notificationTargetKey);
            this.report();
            this.closer.close();
        }
        catch (Exception e) {
            LOGGER.warn("Exception when closing EventReporter", (Throwable)e);
        }
        finally {
            super.close();
        }
    }

    private static GobblinTrackingEvent sanitizeEvent(GobblinTrackingEvent event) {
        HashMap newMetadata = Maps.newHashMap();
        for (Map.Entry<String, String> metadata : event.getMetadata().entrySet()) {
            newMetadata.put(metadata.getKey() == null ? NULL_STRING : metadata.getKey(), metadata.getValue() == null ? NULL_STRING : metadata.getValue());
        }
        event.setMetadata(newMetadata);
        return event;
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected MetricContext context;
        protected String name;
        protected MetricFilter filter;
        protected TimeUnit rateUnit;
        protected TimeUnit durationUnit;

        protected Builder(MetricContext context) {
            this.context = context;
            this.name = "MetricReportReporter";
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.filter = MetricFilter.ALL;
        }

        protected abstract T self();
    }
}

