/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics.reporter;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Timer;
import com.google.common.base.Optional;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.metrics.MetricContext;

public abstract class ContextAwareScheduledReporter
extends ScheduledReporter {
    private final MetricContext context;
    private final Optional<MetricFilter> filter;

    protected ContextAwareScheduledReporter(MetricContext context, String name, MetricFilter filter, TimeUnit rateUnit, TimeUnit durationUnit) {
        super((MetricRegistry)context, name, filter, rateUnit, durationUnit);
        this.context = context;
        this.filter = Optional.fromNullable((Object)filter);
    }

    public void report() {
        if (this.filter.isPresent()) {
            this.report(this.context.getGauges((MetricFilter)this.filter.get()), this.context.getCounters((MetricFilter)this.filter.get()), this.context.getHistograms((MetricFilter)this.filter.get()), this.context.getMeters((MetricFilter)this.filter.get()), this.context.getTimers((MetricFilter)this.filter.get()));
        } else {
            this.report(this.context.getGauges(), this.context.getCounters(), this.context.getHistograms(), this.context.getMeters(), this.context.getTimers());
        }
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        this.reportInContext(this.context, gauges, counters, histograms, meters, timers);
    }

    protected abstract void reportInContext(MetricContext var1, SortedMap<String, Gauge> var2, SortedMap<String, Counter> var3, SortedMap<String, Histogram> var4, SortedMap<String, Meter> var5, SortedMap<String, Timer> var6);

    public static abstract class Builder<R extends ContextAwareScheduledReporter, B extends Builder> {
        protected final String name;
        protected MetricFilter filter = MetricFilter.ALL;
        protected TimeUnit rateUnit = TimeUnit.SECONDS;
        protected TimeUnit durationUnit = TimeUnit.MILLISECONDS;

        public Builder(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public abstract R build(MetricContext var1);

        public B filter(MetricFilter filter) {
            this.filter = filter;
            return (B)this;
        }

        public B convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return (B)this;
        }

        public B convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return (B)this;
        }
    }
}

