/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics.example;

import java.io.IOException;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.metrics.ContextAwareCounter;
import org.apache.gobblin.metrics.ContextAwareHistogram;
import org.apache.gobblin.metrics.ContextAwareMeter;
import org.apache.gobblin.metrics.ContextAwareTimer;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.Tag;
import org.apache.gobblin.metrics.reporter.ContextAwareScheduledReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReporterExampleBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReporterExampleBase.class);
    private static final String JOB_NAME = "ExampleJob";
    private static final String TASK_ID_KEY = "task.id";
    private static final String TASK_ID_PREFIX = "ExampleTask_";
    private static final String TOTAL_RECORDS = "totalRecords";
    private static final String RECORD_PROCESS_RATE = "recordProcessRate";
    private static final String RECORD_PROCESS_TIME = "recordProcessTime";
    private static final String RECORD_SIZES = "recordSizes";
    private final ExecutorService executor = Executors.newFixedThreadPool(10);
    private final MetricContext context = MetricContext.builder("Job").addTag(new Tag<String>("jobName", "ExampleJob")).addTag(new Tag<String>("jobId", "ExampleJob_" + System.currentTimeMillis())).build();
    private final ContextAwareScheduledReporter.Builder reporterBuilder;
    private final int tasks;
    private final long totalRecords;

    public ReporterExampleBase(ContextAwareScheduledReporter.Builder reporterBuilder, int tasks, long totalRecords) {
        this.reporterBuilder = reporterBuilder;
        this.tasks = tasks;
        this.totalRecords = totalRecords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        try {
            CountDownLatch countDownLatch = new CountDownLatch(this.tasks);
            for (int i = 0; i < this.tasks; ++i) {
                this.addTask(i, countDownLatch);
            }
            countDownLatch.await();
        }
        finally {
            try {
                this.context.close();
            }
            finally {
                this.executor.shutdownNow();
            }
        }
    }

    private void addTask(int taskIndex, CountDownLatch countDownLatch) {
        MetricContext taskContext = this.context.childBuilder("Task" + taskIndex).addTag(new Tag<String>(TASK_ID_KEY, TASK_ID_PREFIX + taskIndex)).build();
        Task task = new Task(taskContext, taskIndex, this.totalRecords, countDownLatch);
        this.executor.execute(task);
    }

    private static class Task
    implements Runnable {
        private final MetricContext context;
        private final int taskIndex;
        private final long totalRecords;
        private final CountDownLatch countDownLatch;
        private final Random rand = new Random();

        public Task(MetricContext context, int taskIndex, long totalRecords, CountDownLatch countDownLatch) {
            this.context = context;
            this.taskIndex = taskIndex;
            this.totalRecords = totalRecords;
            this.countDownLatch = countDownLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            ContextAwareCounter totalRecordsCounter = this.context.contextAwareCounter(ReporterExampleBase.TOTAL_RECORDS);
            ContextAwareMeter recordProcessRateMeter = this.context.contextAwareMeter(ReporterExampleBase.RECORD_PROCESS_RATE);
            ContextAwareTimer recordProcessTimeTimer = this.context.contextAwareTimer(ReporterExampleBase.RECORD_PROCESS_TIME);
            ContextAwareHistogram recordSizesHistogram = this.context.contextAwareHistogram(ReporterExampleBase.RECORD_SIZES);
            try {
                int i = 0;
                while ((long)i < this.totalRecords) {
                    totalRecordsCounter.inc();
                    recordProcessRateMeter.mark();
                    recordSizesHistogram.update((this.rand.nextLong() & Long.MAX_VALUE) % 5000L);
                    if (i % 100 == 0) {
                        LOGGER.info(String.format("Task %d has processed %d records so far", this.taskIndex, i));
                    }
                    long processTime = (this.rand.nextLong() & Long.MAX_VALUE) % 10L;
                    try {
                        Thread.sleep(processTime);
                    }
                    catch (InterruptedException ie) {
                        LOGGER.warn(String.format("Task %d has been interrupted", this.taskIndex));
                        Thread.currentThread().interrupt();
                        try {
                            this.context.close();
                            return;
                        }
                        catch (IOException ioe) {
                            LOGGER.error("Failed to close context: " + this.context.getName(), (Throwable)ioe);
                            return;
                        }
                        finally {
                            this.countDownLatch.countDown();
                        }
                    }
                    recordProcessTimeTimer.update(processTime, TimeUnit.MILLISECONDS);
                    ++i;
                }
                LOGGER.info(String.format("Task %d has processed all %d records", this.taskIndex, this.totalRecords));
                return;
            }
            finally {
                try {
                    this.context.close();
                }
                catch (IOException ioe) {
                    LOGGER.error("Failed to close context: " + this.context.getName(), (Throwable)ioe);
                }
                finally {
                    this.countDownLatch.countDown();
                }
            }
        }
    }
}

