/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics.event;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public enum MultiPartEvent {
    TIMING_EVENT("timingEvent", "startTime", "endTime", "durationMillis"),
    JOBSTATE_EVENT("JobStateEvent", "jobBeginTime", "jobEndTime", "jobLaunchedTasks", "jobCompletedTasks", "jobState"),
    TASKSTATE_EVENT("TaskStateEvent", "taskStartTime", "taskEndTime", "taskWorkingState");

    private String eventName;
    private String[] metadataFields;
    private static final Map<String, MultiPartEvent> lookup;

    private MultiPartEvent(String eventName, String ... metadataFields) {
        this.eventName = eventName;
        this.metadataFields = metadataFields;
    }

    public static MultiPartEvent getEvent(String eventName) {
        return lookup.get(eventName);
    }

    public String getEventName() {
        return this.eventName;
    }

    public String[] getMetadataFields() {
        return this.metadataFields;
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (MultiPartEvent event : MultiPartEvent.values()) {
            builder.put((Object)event.eventName, (Object)event);
        }
        lookup = builder.build();
    }
}

