/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.gobblin.metrics.Tag;
import org.apache.gobblin.metrics.Taggable;

public class Tagged
implements Taggable {
    protected final Map<String, Object> tags = Maps.newLinkedHashMap();

    public Tagged() {
    }

    public Tagged(Collection<Tag<?>> tags) {
        this.addTags(tags);
    }

    @Override
    public void addTag(Tag<?> tag) {
        Preconditions.checkNotNull(tag, (Object)"Cannot add a null Tag");
        Preconditions.checkNotNull(tag.getValue(), (Object)("Cannot add a Tag with a null value. Tag: " + tag));
        this.tags.put((String)tag.getKey(), tag.getValue());
    }

    @Override
    public void addTags(Collection<Tag<?>> tags) {
        for (Tag<?> tag : tags) {
            this.addTag(tag);
        }
    }

    @Override
    public List<Tag<?>> getTags() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Map.Entry<String, Object> entry : this.tags.entrySet()) {
            builder.add(new Tag<Object>(entry.getKey(), entry.getValue()));
        }
        return builder.build();
    }

    public Map<String, Object> getTagMap() {
        return ImmutableMap.copyOf(this.tags);
    }

    @Override
    public String metricNamePrefix(boolean includeTagKeys) {
        return Joiner.on((char)'.').join(includeTagKeys ? this.getTags() : this.tags.values());
    }
}

