/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.Closeable;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.metrics.InnerMetricContext;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.Tag;
import org.apache.gobblin.metrics.context.ContextWeakReference;
import org.apache.gobblin.metrics.context.NameConflictException;
import org.apache.gobblin.metrics.notification.MetricContextCleanupNotification;
import org.apache.gobblin.metrics.notification.NewMetricContextNotification;
import org.apache.gobblin.metrics.reporter.ContextAwareReporter;
import org.apache.gobblin.util.ExecutorsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootMetricContext
extends MetricContext {
    private static final Logger log = LoggerFactory.getLogger(RootMetricContext.class);
    public static final String ROOT_METRIC_CONTEXT = "RootMetricContext";
    private final ReferenceQueue<MetricContext> referenceQueue;
    private final Set<InnerMetricContext> innerMetricContexts = Sets.newConcurrentHashSet();
    private final ScheduledExecutorService referenceQueueExecutorService;
    private final Set<ContextAwareReporter> reporters;
    private volatile boolean reportingStarted;
    private static RootMetricContext INSTANCE;

    private RootMetricContext(List<Tag<?>> tags) throws NameConflictException {
        super(ROOT_METRIC_CONTEXT, null, tags, true);
        this.referenceQueue = new ReferenceQueue();
        this.referenceQueueExecutorService = ExecutorsUtils.loggingDecorator((ScheduledExecutorService)MoreExecutors.getExitingScheduledExecutorService((ScheduledThreadPoolExecutor)new ScheduledThreadPoolExecutor(1, ExecutorsUtils.newThreadFactory((Optional)Optional.of((Object)log), (Optional)Optional.of((Object)"GobblinMetrics-ReferenceQueue")))));
        this.referenceQueueExecutorService.scheduleWithFixedDelay(new CheckReferenceQueue(), 0L, 2L, TimeUnit.SECONDS);
        this.reporters = Sets.newConcurrentHashSet();
        this.reportingStarted = false;
        this.addShutdownHook();
    }

    private static void initialize(List<Tag<?>> tags) {
        try {
            INSTANCE = new RootMetricContext(tags);
        }
        catch (NameConflictException nce) {
            throw new IllegalStateException("Failed to generate root metric context. This is an error in the code.", nce);
        }
    }

    public static synchronized RootMetricContext get() {
        return RootMetricContext.get(Lists.newArrayList());
    }

    public static synchronized RootMetricContext get(List<Tag<?>> tags) {
        if (INSTANCE == null) {
            RootMetricContext.initialize(tags);
        }
        return INSTANCE;
    }

    public void addNewReporter(ContextAwareReporter reporter) {
        this.reporters.add((ContextAwareReporter)this.closer.register((Closeable)reporter));
        if (this.reportingStarted) {
            reporter.start();
        }
    }

    public void removeReporter(ContextAwareReporter reporter) {
        if (this.reporters.contains(reporter)) {
            reporter.stop();
            this.reporters.remove(reporter);
        }
    }

    public void startReporting() {
        this.reportingStarted = true;
        for (ContextAwareReporter reporter : this.reporters) {
            try {
                reporter.start();
            }
            catch (Throwable throwable) {
                log.error(String.format("Failed to start reporter with class %s", reporter.getClass().getCanonicalName()), throwable);
            }
        }
    }

    public void stopReporting() {
        this.reportingStarted = false;
        for (ContextAwareReporter reporter : this.reporters) {
            try {
                reporter.stop();
            }
            catch (Throwable throwable) {
                log.error(String.format("Failed to stop reporter with class %s", reporter.getClass().getCanonicalName()), throwable);
            }
        }
    }

    protected void addMetricContext(MetricContext context) {
        this.innerMetricContexts.add(context.getInnerMetricContext());
        this.sendNotification(new NewMetricContextNotification(context, context.getInnerMetricContext()));
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                RootMetricContext.this.stopReporting();
                try {
                    RootMetricContext.this.close();
                }
                catch (IOException e) {
                    log.warn("Unable to close " + this.getClass().getCanonicalName(), (Throwable)e);
                }
            }
        });
    }

    public ReferenceQueue<MetricContext> getReferenceQueue() {
        return this.referenceQueue;
    }

    public Set<ContextAwareReporter> getReporters() {
        return this.reporters;
    }

    private class CheckReferenceQueue
    implements Runnable {
        private CheckReferenceQueue() {
        }

        @Override
        public void run() {
            Reference reference;
            while ((reference = RootMetricContext.this.referenceQueue.poll()) != null) {
                ContextWeakReference contextReference = (ContextWeakReference)reference;
                RootMetricContext.this.sendNotification(new MetricContextCleanupNotification(contextReference.getInnerContext()));
                RootMetricContext.this.innerMetricContexts.remove(contextReference.getInnerContext());
            }
        }
    }
}

