/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.mapreduce.avro;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.gobblin.compaction.mapreduce.avro.AvroDeltaFieldNameProvider;
import org.apache.hadoop.conf.Configuration;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ObjectNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldAttributeBasedDeltaFieldsProvider
implements AvroDeltaFieldNameProvider {
    private static final Logger log = LoggerFactory.getLogger(FieldAttributeBasedDeltaFieldsProvider.class);
    public static final String ATTRIBUTE_FIELD = "org.apache.gobblin.compaction." + FieldAttributeBasedDeltaFieldsProvider.class.getSimpleName() + ".deltaAttributeField";
    public static final String DELTA_PROP_NAME = "org.apache.gobblin.compaction." + FieldAttributeBasedDeltaFieldsProvider.class.getSimpleName() + ".deltaPropName";
    public static final String DEFAULT_DELTA_PROP_NAME = "delta";
    private final String attributeField;
    private final String deltaPropName;
    private final LoadingCache<Schema, List<String>> recordSchemaToDeltaSchemaCache;

    public FieldAttributeBasedDeltaFieldsProvider(Configuration conf) {
        this.attributeField = conf.get(ATTRIBUTE_FIELD);
        Preconditions.checkArgument((this.attributeField != null ? 1 : 0) != 0, (Object)("Missing config " + ATTRIBUTE_FIELD));
        this.deltaPropName = conf.get(DELTA_PROP_NAME, DEFAULT_DELTA_PROP_NAME);
        this.recordSchemaToDeltaSchemaCache = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)new CacheLoader<Schema, List<String>>(){

            public List<String> load(Schema schema) throws Exception {
                return FieldAttributeBasedDeltaFieldsProvider.this.getDeltaFieldNamesForNewSchema(schema);
            }
        });
    }

    @Override
    public List<String> getDeltaFieldNames(GenericRecord record) {
        try {
            return (List)this.recordSchemaToDeltaSchemaCache.get((Object)record.getSchema());
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private List<String> getDeltaFieldNamesForNewSchema(Schema originalSchema) {
        ArrayList<String> deltaFields = new ArrayList<String>();
        for (Schema.Field field : originalSchema.getFields()) {
            String deltaAttributeField = field.getJsonProp(this.attributeField).getValueAsText();
            ObjectNode objectNode = this.getDeltaPropValue(deltaAttributeField);
            if (objectNode == null || objectNode.get(this.deltaPropName) == null || !Boolean.parseBoolean(objectNode.get(this.deltaPropName).toString())) continue;
            deltaFields.add(field.name());
        }
        log.info("Will use delta fields: " + deltaFields);
        return deltaFields;
    }

    private ObjectNode getDeltaPropValue(String json) {
        try {
            JsonFactory jf = new JsonFactory();
            JsonParser jp = jf.createJsonParser(json);
            ObjectMapper objMap = new ObjectMapper(jf);
            jp.setCodec((ObjectCodec)objMap);
            return (ObjectNode)jp.readValueAsTree();
        }
        catch (IOException e) {
            return null;
        }
    }
}

