/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.stream;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.util.List;
import org.apache.gobblin.ack.Ackable;
import org.apache.gobblin.ack.HierarchicalAckable;

public abstract class StreamEntity<D>
implements Ackable {
    private final List<Ackable> _callbacks;
    private boolean _callbacksUsedForDerivedEntity = false;

    protected StreamEntity() {
        this._callbacks = Lists.newArrayList();
    }

    protected StreamEntity(StreamEntity<?> upstreamEntity, boolean copyCallbacks) {
        this._callbacks = copyCallbacks ? super.getCallbacksForDerivedEntity() : Lists.newArrayList();
    }

    protected StreamEntity(ForkedEntityBuilder forkedEntityBuilder, boolean copyCallbacks) {
        this._callbacks = copyCallbacks ? forkedEntityBuilder.getChildCallback() : Lists.newArrayList();
    }

    @Override
    public void ack() {
        for (Ackable ackable : this._callbacks) {
            ackable.ack();
        }
    }

    @Override
    public void nack(Throwable error) {
        for (Ackable ackable : this._callbacks) {
            ackable.nack(error);
        }
    }

    private synchronized List<Ackable> getCallbacksForDerivedEntity() {
        Preconditions.checkState((!this._callbacksUsedForDerivedEntity ? 1 : 0) != 0, (Object)"StreamEntity was attempted to use more than once for a derived entity.");
        this._callbacksUsedForDerivedEntity = true;
        return this._callbacks;
    }

    public StreamEntity<D> addCallBack(Ackable ackable) {
        this._callbacks.add(ackable);
        return this;
    }

    private void setCallbacks(List<Ackable> callbacks) {
        this._callbacks.addAll(callbacks);
    }

    public final StreamEntity<D> getSingleClone() {
        StreamEntity<D> entity = this.buildClone();
        super.setCallbacks(this.getCallbacksForDerivedEntity());
        return entity;
    }

    protected abstract StreamEntity<D> buildClone();

    public ForkCloner forkCloner() {
        return new ForkCloner();
    }

    public class ForkedEntityBuilder
    implements Closeable {
        private final HierarchicalAckable _hierarchicalAckable;

        protected ForkedEntityBuilder() {
            List callbacks = StreamEntity.this.getCallbacksForDerivedEntity();
            this._hierarchicalAckable = callbacks.isEmpty() ? null : new HierarchicalAckable(callbacks);
        }

        protected List<Ackable> getChildCallback() {
            return this._hierarchicalAckable == null ? Lists.newArrayList() : Lists.newArrayList((Object[])new Ackable[]{this._hierarchicalAckable.newChildAckable()});
        }

        @Override
        public void close() {
            if (this._hierarchicalAckable != null) {
                this._hierarchicalAckable.close();
            }
        }
    }

    public class ForkCloner
    implements Closeable {
        private final ForkedEntityBuilder _forkedEntityBuilder;

        private ForkCloner() {
            this._forkedEntityBuilder = new ForkedEntityBuilder();
        }

        public StreamEntity<D> getClone() {
            StreamEntity entity = StreamEntity.this.buildClone();
            entity.setCallbacks(this._forkedEntityBuilder.getChildCallback());
            return entity;
        }

        @Override
        public void close() {
            this._forkedEntityBuilder.close();
        }
    }
}

