/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.workunit;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.gobblin.source.workunit.WorkUnit;
import org.apache.gobblin.source.workunit.WorkUnitStream;

public class BasicWorkUnitStream
implements WorkUnitStream {
    private final Iterator<WorkUnit> workUnits;
    private List<WorkUnit> materializedWorkUnits;
    private final boolean finiteStream;
    private final boolean safeToMaterialize;

    BasicWorkUnitStream(Iterator<WorkUnit> workUnits, List<WorkUnit> materializedWorkUnits, boolean finiteStream, boolean safeToMaterialize) {
        this.workUnits = workUnits;
        this.materializedWorkUnits = materializedWorkUnits;
        this.finiteStream = finiteStream;
        this.safeToMaterialize = safeToMaterialize;
    }

    private BasicWorkUnitStream(BasicWorkUnitStream other, Iterator<WorkUnit> workUnits, List<WorkUnit> materializedWorkUnits) {
        this.workUnits = workUnits;
        this.materializedWorkUnits = materializedWorkUnits;
        this.finiteStream = other.finiteStream;
        this.safeToMaterialize = other.safeToMaterialize;
    }

    @Override
    public Iterator<WorkUnit> getWorkUnits() {
        if (this.materializedWorkUnits == null) {
            return this.workUnits;
        }
        return this.materializedWorkUnits.iterator();
    }

    @Override
    public WorkUnitStream transform(Function<WorkUnit, WorkUnit> function) {
        if (this.materializedWorkUnits == null) {
            return new BasicWorkUnitStream(this, Iterators.transform(this.workUnits, function), null);
        }
        return new BasicWorkUnitStream(this, null, Lists.newArrayList((Iterable)Lists.transform(this.materializedWorkUnits, function)));
    }

    @Override
    public WorkUnitStream filter(Predicate<WorkUnit> predicate) {
        if (this.materializedWorkUnits == null) {
            return new BasicWorkUnitStream(this, (Iterator<WorkUnit>)Iterators.filter(this.workUnits, predicate), null);
        }
        return new BasicWorkUnitStream(this, null, Lists.newArrayList((Iterable)Iterables.filter(this.materializedWorkUnits, predicate)));
    }

    @Override
    public Collection<WorkUnit> getMaterializedWorkUnitCollection() {
        this.materialize();
        return this.materializedWorkUnits;
    }

    private void materialize() {
        if (this.materializedWorkUnits != null) {
            return;
        }
        if (!this.isSafeToMaterialize()) {
            throw new UnsupportedOperationException("WorkUnitStream is not safe to materialize.");
        }
        this.materializedWorkUnits = Lists.newArrayList(this.workUnits);
    }

    @Override
    public boolean isFiniteStream() {
        return this.finiteStream;
    }

    @Override
    public boolean isSafeToMaterialize() {
        return this.safeToMaterialize;
    }

    public static class Builder {
        private Iterator<WorkUnit> workUnits;
        private List<WorkUnit> workUnitList;
        private boolean finiteStream = true;
        private boolean safeToMaterialize = false;

        public Builder(Iterator<WorkUnit> workUnits) {
            this.workUnits = workUnits;
        }

        public Builder(List<WorkUnit> workUnits) {
            this.workUnitList = workUnits;
            this.safeToMaterialize = true;
            this.finiteStream = true;
        }

        public Builder setFiniteStream(boolean finiteStream) {
            this.finiteStream = finiteStream;
            return this;
        }

        public Builder setSafeToMaterialize(boolean safeToMaterialize) {
            this.safeToMaterialize = safeToMaterialize;
            return this;
        }

        public WorkUnitStream build() {
            return new BasicWorkUnitStream(this.workUnits, this.workUnitList, this.finiteStream, this.safeToMaterialize);
        }
    }
}

