/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics.influxdb;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Counting;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metered;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.typesafe.config.Config;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.metrics.Measurements;
import org.apache.gobblin.metrics.influxdb.InfluxDBConnectionType;
import org.apache.gobblin.metrics.influxdb.InfluxDBPusher;
import org.apache.gobblin.metrics.reporter.ConfiguredScheduledReporter;
import org.apache.gobblin.util.ConfigUtils;
import org.influxdb.dto.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfluxDBReporter
extends ConfiguredScheduledReporter {
    private final InfluxDBPusher influxDBPusher;
    private static final Logger LOGGER = LoggerFactory.getLogger(InfluxDBReporter.class);

    public InfluxDBReporter(Builder<?> builder, Config config) {
        super(builder, config);
        this.influxDBPusher = builder.influxDBPusher.isPresent() ? (InfluxDBPusher)builder.influxDBPusher.get() : new InfluxDBPusher.Builder(builder.url, builder.username, builder.password, builder.database, builder.connectionType).build();
    }

    protected void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers, Map<String, Object> tags) {
        String prefix = this.getMetricNamePrefix(tags);
        long timestamp = System.currentTimeMillis();
        ArrayList points = Lists.newArrayList();
        try {
            for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
                this.reportGauge(points, prefix, entry.getKey(), entry.getValue(), timestamp);
            }
            for (Map.Entry<String, Gauge> entry : counters.entrySet()) {
                this.reportCounter(points, prefix, entry.getKey(), (Counting)entry.getValue(), timestamp);
            }
            for (Map.Entry<String, Gauge> entry : histograms.entrySet()) {
                this.reportHistogram(points, prefix, entry.getKey(), (Histogram)entry.getValue(), timestamp);
            }
            for (Map.Entry<String, Gauge> entry : meters.entrySet()) {
                this.reportMetered(points, prefix, entry.getKey(), (Metered)entry.getValue(), timestamp);
            }
            for (Map.Entry<String, Gauge> entry : timers.entrySet()) {
                this.reportTimer(points, prefix, entry.getKey(), (Timer)entry.getValue(), timestamp);
            }
            this.influxDBPusher.push(points);
        }
        catch (IOException ioe) {
            LOGGER.error("Error sending metrics to InfluxDB", (Throwable)ioe);
        }
    }

    private void reportGauge(List<Point> points, String prefix, String name, Gauge gauge, long timestamp) throws IOException {
        String metricName = this.getKey(prefix, name);
        points.add(this.buildMetricAsPoint(metricName, gauge.getValue(), timestamp));
    }

    private void reportCounter(List<Point> points, String prefix, String name, Counting counter, long timestamp) throws IOException {
        String metricName = this.getKey(prefix, name, Measurements.COUNT.getName());
        points.add(this.buildMetricAsPoint(metricName, counter.getCount(), false, timestamp));
    }

    private void reportHistogram(List<Point> points, String prefix, String name, Histogram histogram, long timestamp) throws IOException {
        this.reportCounter(points, prefix, name, (Counting)histogram, timestamp);
        this.reportSnapshot(points, prefix, name, histogram.getSnapshot(), timestamp, false);
    }

    private void reportTimer(List<Point> points, String prefix, String name, Timer timer, long timestamp) throws IOException {
        this.reportSnapshot(points, prefix, name, timer.getSnapshot(), timestamp, true);
        this.reportMetered(points, prefix, name, (Metered)timer, timestamp);
    }

    private void reportSnapshot(List<Point> points, String prefix, String name, Snapshot snapshot, long timestamp, boolean convertDuration) throws IOException {
        String baseMetricName = this.getKey(prefix, name);
        points.add(this.buildMetricAsPoint(this.getKey(baseMetricName, Measurements.MIN), snapshot.getMin(), convertDuration, timestamp));
        points.add(this.buildMetricAsPoint(this.getKey(baseMetricName, Measurements.MAX), snapshot.getMax(), convertDuration, timestamp));
        points.add(this.buildMetricAsPoint(this.getKey(baseMetricName, Measurements.MEAN), snapshot.getMean(), convertDuration, timestamp));
        points.add(this.buildMetricAsPoint(this.getKey(baseMetricName, Measurements.STDDEV), snapshot.getStdDev(), convertDuration, timestamp));
        points.add(this.buildMetricAsPoint(this.getKey(baseMetricName, Measurements.MEDIAN), snapshot.getMedian(), convertDuration, timestamp));
        points.add(this.buildMetricAsPoint(this.getKey(baseMetricName, Measurements.PERCENTILE_75TH), snapshot.get75thPercentile(), convertDuration, timestamp));
        points.add(this.buildMetricAsPoint(this.getKey(baseMetricName, Measurements.PERCENTILE_95TH), snapshot.get95thPercentile(), convertDuration, timestamp));
        points.add(this.buildMetricAsPoint(this.getKey(baseMetricName, Measurements.PERCENTILE_98TH), snapshot.get98thPercentile(), convertDuration, timestamp));
        points.add(this.buildMetricAsPoint(this.getKey(baseMetricName, Measurements.PERCENTILE_99TH), snapshot.get99thPercentile(), convertDuration, timestamp));
        points.add(this.buildMetricAsPoint(this.getKey(baseMetricName, Measurements.PERCENTILE_999TH), snapshot.get999thPercentile(), convertDuration, timestamp));
    }

    private void reportMetered(List<Point> points, String prefix, String name, Metered metered, long timestamp) throws IOException {
        this.reportCounter(points, prefix, name, (Counting)metered, timestamp);
        String baseMetricName = this.getKey(prefix, name);
        points.add(this.buildRateAsPoint(this.getKey(baseMetricName, Measurements.RATE_1MIN), metered.getOneMinuteRate(), timestamp));
        points.add(this.buildRateAsPoint(this.getKey(baseMetricName, Measurements.RATE_5MIN), metered.getFiveMinuteRate(), timestamp));
        points.add(this.buildRateAsPoint(this.getKey(baseMetricName, Measurements.RATE_15MIN), metered.getFifteenMinuteRate(), timestamp));
        points.add(this.buildRateAsPoint(this.getKey(baseMetricName, Measurements.MEAN_RATE), metered.getMeanRate(), timestamp));
    }

    private Point buildMetricAsPoint(String metricName, Number value, boolean toDuration, long timestamp) throws IOException {
        Number metricValue = toDuration ? (Number)this.convertDuration(value.doubleValue()) : (Number)value;
        return this.buildMetricAsPoint(metricName, metricValue, timestamp);
    }

    private Point buildRateAsPoint(String metricName, double value, long timestamp) throws IOException {
        return this.buildMetricAsPoint(metricName, this.convertRate(value), timestamp);
    }

    private Point buildMetricAsPoint(String name, Object value, long timestamp) throws IOException {
        return Point.measurement((String)name).field("value", value).time(timestamp, TimeUnit.MILLISECONDS).build();
    }

    private String getKey(String baseName, Measurements measurements) {
        return this.getKey(baseName, measurements.getName());
    }

    private String getKey(String ... keys) {
        return JOINER.join((Object[])keys);
    }

    public static abstract class Builder<T extends ConfiguredScheduledReporter.Builder<T>>
    extends ConfiguredScheduledReporter.Builder<T> {
        protected MetricFilter filter;
        protected String url;
        protected String username;
        protected String password;
        protected String database;
        protected InfluxDBConnectionType connectionType;
        protected Optional<InfluxDBPusher> influxDBPusher;

        protected Builder() {
            this.name = "InfluxDBReporter";
            this.influxDBPusher = Optional.absent();
            this.filter = MetricFilter.ALL;
            this.connectionType = InfluxDBConnectionType.TCP;
        }

        public T withInfluxDBPusher(InfluxDBPusher pusher) {
            this.influxDBPusher = Optional.of((Object)pusher);
            return (T)this.self();
        }

        public T withConnection(String url, String username, String password, String database) {
            this.url = url;
            this.username = username;
            this.password = password;
            this.database = database;
            return (T)this.self();
        }

        public T withConnectionType(InfluxDBConnectionType connectionType) {
            this.connectionType = connectionType;
            return (T)this.self();
        }

        public T filter(MetricFilter filter) {
            this.filter = filter;
            return (T)this.self();
        }

        public InfluxDBReporter build(Properties props) throws IOException {
            return new InfluxDBReporter(this, ConfigUtils.propertiesToConfig((Properties)props, (Optional)Optional.of((Object)"metrics.")));
        }
    }

    public static class BuilderImpl
    extends Builder<BuilderImpl> {
        protected BuilderImpl self() {
            return this;
        }
    }

    public static class Factory {
        public static BuilderImpl newBuilder() {
            return new BuilderImpl();
        }
    }
}

