/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.pegasus.generator;

import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaLocation;
import com.linkedin.pegasus.generator.DataSchemaParser;
import com.linkedin.pegasus.generator.DefaultGeneratorResult;
import com.linkedin.pegasus.generator.GeneratorResult;
import com.linkedin.pegasus.generator.JavaCodeUtil;
import com.linkedin.pegasus.generator.JavaDataTemplateGenerator;
import com.linkedin.pegasus.generator.TemplateSpecGenerator;
import com.linkedin.pegasus.generator.spec.ClassTemplateSpec;
import com.linkedin.util.FileUtil;
import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.writer.FileCodeWriter;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PegasusDataTemplateGenerator {
    public static final String GENERATOR_GENERATE_IMPORTED = "generator.generate.imported";
    private static final Logger _log = LoggerFactory.getLogger(PegasusDataTemplateGenerator.class);

    public static void main(String[] args) throws IOException {
        String generateImportedProperty;
        if (args.length < 2) {
            _log.error("Usage: PegasusDataTemplateGenerator targetDirectoryPath [sourceFile or sourceDirectory or schemaName]+");
            System.exit(1);
        }
        boolean generateImported = (generateImportedProperty = System.getProperty(GENERATOR_GENERATE_IMPORTED)) == null ? true : Boolean.parseBoolean(generateImportedProperty);
        PegasusDataTemplateGenerator.run(System.getProperty("generator.resolver.path"), System.getProperty("generator.default.package"), generateImported, args[0], Arrays.copyOfRange(args, 1, args.length));
    }

    public static GeneratorResult run(String resolverPath, String defaultPackage, boolean generateImported, String targetDirectoryPath, String[] sources) throws IOException {
        List<File> modifiedFiles;
        DataSchemaParser schemaParser = new DataSchemaParser(resolverPath);
        TemplateSpecGenerator specGenerator = new TemplateSpecGenerator(schemaParser.getSchemaResolver());
        JavaDataTemplateGenerator dataTemplateGenerator = new JavaDataTemplateGenerator(defaultPackage);
        for (DataSchema dataSchema : JavaDataTemplateGenerator.PredefinedJavaClasses.keySet()) {
            specGenerator.registerDefinedSchema(dataSchema);
        }
        DataSchemaParser.ParseResult parseResult = schemaParser.parseSources(sources);
        for (Map.Entry<DataSchema, DataSchemaLocation> entry : parseResult.getSchemaAndLocations().entrySet()) {
            specGenerator.generate(entry.getKey(), entry.getValue());
        }
        for (ClassTemplateSpec classTemplateSpec : specGenerator.getGeneratedSpecs()) {
            dataTemplateGenerator.generate(classTemplateSpec);
        }
        DataTemplatePersistentClassChecker dataTemplatePersistentClassChecker = new DataTemplatePersistentClassChecker(generateImported, specGenerator, dataTemplateGenerator, parseResult.getSourceFiles());
        File file = new File(targetDirectoryPath);
        List<File> targetFiles = JavaCodeUtil.targetFiles(file, dataTemplateGenerator.getCodeModel(), JavaCodeUtil.classLoaderFromResolverPath(schemaParser.getResolverPath()), dataTemplatePersistentClassChecker);
        if (FileUtil.upToDate(parseResult.getSourceFiles(), targetFiles)) {
            modifiedFiles = Collections.emptyList();
            _log.info("Target files are up-to-date: " + targetFiles);
        } else {
            modifiedFiles = targetFiles;
            _log.info("Generating " + targetFiles.size() + " files: " + targetFiles);
            PegasusDataTemplateGenerator.validateDefinedClassRegistration(dataTemplateGenerator.getCodeModel(), dataTemplateGenerator.getGeneratedClasses().keySet());
            dataTemplateGenerator.getCodeModel().build((CodeWriter)new FileCodeWriter(file, true));
        }
        return new DefaultGeneratorResult(parseResult.getSourceFiles(), targetFiles, modifiedFiles);
    }

    private static void validateDefinedClassRegistration(JCodeModel codeModel, Collection<JDefinedClass> classes) {
        Iterator packageIterator = codeModel.packages();
        while (packageIterator.hasNext()) {
            JPackage currentPackage = (JPackage)packageIterator.next();
            Iterator classIterator = currentPackage.classes();
            while (classIterator.hasNext()) {
                JDefinedClass currentClass = (JDefinedClass)classIterator.next();
                if (classes.contains(currentClass)) continue;
                throw new IllegalStateException("Attempting to generate unregistered class: '" + currentClass.fullName() + "'");
            }
        }
    }

    public static class DataTemplatePersistentClassChecker
    implements JavaCodeUtil.PersistentClassChecker {
        private final boolean _generateImported;
        private final TemplateSpecGenerator _specGenerator;
        private final JavaDataTemplateGenerator _dataTemplateGenerator;
        private final Set<File> _sourceFiles;

        public DataTemplatePersistentClassChecker(boolean generateImported, TemplateSpecGenerator specGenerator, JavaDataTemplateGenerator dataTemplateGenerator, Set<File> sourceFiles) {
            this._generateImported = generateImported;
            this._specGenerator = specGenerator;
            this._dataTemplateGenerator = dataTemplateGenerator;
            this._sourceFiles = sourceFiles;
        }

        @Override
        public boolean isPersistent(JDefinedClass clazz) {
            if (this._generateImported) {
                return true;
            }
            ClassTemplateSpec spec = this._dataTemplateGenerator.getGeneratedClasses().get(clazz);
            DataSchemaLocation location = this._specGenerator.getClassLocation(spec);
            return location == null || this._sourceFiles.contains(location.getSourceFile());
        }
    }
}

