/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.pegasus.generator;

import com.linkedin.data.ByteString;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.SetMode;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JPackage;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class JavaCodeGeneratorBase {
    public static final String GENERATOR_DEFAULT_PACKAGE = "generator.default.package";
    protected static final String SUPER = "super";
    protected static final String THIS = "this";
    private static final Set<String> _reserved = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while")));
    protected final JClass _byteStringClass;
    protected final JClass _collectionClass;
    protected final JClass _customClass;
    protected final JClass _dataListClass;
    protected final JClass _dataMapClass;
    protected final JClass _dataTemplateUtilClass;
    protected final JClass _getModeClass;
    protected final JClass _mapClass;
    protected final JClass _pathSpecClass;
    protected final JClass _setModeClass;
    protected final JClass _stringBuilderClass;
    protected final JClass _stringClass;
    protected final JFieldRef _disallowNullSetMode;
    protected final JFieldRef _strictGetMode;
    private final JCodeModel _codeModel = new JCodeModel();
    private JPackage _package;

    public JavaCodeGeneratorBase(String defaultPackage) {
        this._byteStringClass = this.getCodeModel().ref(ByteString.class);
        this._collectionClass = this.getCodeModel().ref(Collection.class);
        this._customClass = this.getCodeModel().ref(Custom.class);
        this._dataListClass = this.getCodeModel().ref(DataList.class);
        this._dataMapClass = this.getCodeModel().ref(DataMap.class);
        this._dataTemplateUtilClass = this.getCodeModel().ref(DataTemplateUtil.class);
        this._getModeClass = this.getCodeModel().ref(GetMode.class);
        this._mapClass = this.getCodeModel().ref(Map.class);
        this._pathSpecClass = this.getCodeModel().ref(PathSpec.class);
        this._setModeClass = this.getCodeModel().ref(SetMode.class);
        this._stringBuilderClass = this.getCodeModel().ref(StringBuilder.class);
        this._stringClass = this.getCodeModel().ref(String.class);
        this._disallowNullSetMode = this.getCodeModel().ref(SetMode.class).staticRef("DISALLOW_NULL");
        this._strictGetMode = this.getCodeModel().ref(GetMode.class).staticRef("STRICT");
        this._package = this.getCodeModel()._package(defaultPackage == null ? "" : defaultPackage);
    }

    protected static boolean isReserved(String name) {
        return _reserved.contains(name);
    }

    protected static String escapeReserved(String name) {
        if (_reserved.contains(name)) {
            return name + '_';
        }
        return name;
    }

    public JCodeModel getCodeModel() {
        return this._codeModel;
    }

    protected JPackage getPackage() {
        return this._package;
    }

    protected JPackage getPackage(String namespace) {
        return namespace.isEmpty() ? this.getPackage() : this._codeModel._package(namespace);
    }
}

