/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.pegasus.generator;

import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaLocation;
import com.linkedin.data.schema.DataSchemaParserFactory;
import com.linkedin.data.schema.DataSchemaResolver;
import com.linkedin.data.schema.resolver.MultiFormatDataSchemaResolver;
import com.linkedin.pegasus.generator.FileFormatDataSchemaParser;
import com.linkedin.util.FileUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;

public class DataSchemaParser {
    private final String _resolverPath;
    private final Map<String, FileFormatDataSchemaParser> _parserByFileExtension;
    private final MultiFormatDataSchemaResolver _resolver;

    public DataSchemaParser(String resolverPath) {
        this(resolverPath, MultiFormatDataSchemaResolver.BUILTIN_FORMAT_PARSER_FACTORIES);
    }

    public DataSchemaParser(String resolverPath, List<DataSchemaParserFactory> parserFactoriesForFromats) {
        this._resolverPath = resolverPath;
        MultiFormatDataSchemaResolver resolver = new MultiFormatDataSchemaResolver(resolverPath, parserFactoriesForFromats);
        this._parserByFileExtension = new HashMap<String, FileFormatDataSchemaParser>();
        for (DataSchemaParserFactory parserForFormat : parserFactoriesForFromats) {
            FileFormatDataSchemaParser fileFormatParser = new FileFormatDataSchemaParser(resolverPath, (DataSchemaResolver)resolver, parserForFormat);
            this._parserByFileExtension.put(parserForFormat.getLanguageExtension(), fileFormatParser);
        }
        this._resolver = resolver;
    }

    public String getResolverPath() {
        return this._resolverPath;
    }

    public DataSchemaResolver getSchemaResolver() {
        return this._resolver;
    }

    public ParseResult parseSources(String[] sources) throws IOException {
        Set<String> fileExtensions = this._parserByFileExtension.keySet();
        HashMap byExtension = new HashMap(fileExtensions.size());
        for (String fileExtension : fileExtensions) {
            byExtension.put(fileExtension, new ArrayList());
        }
        for (String source : sources) {
            File sourceFile = new File(source);
            if (!sourceFile.exists()) continue;
            if (sourceFile.isDirectory()) {
                FileExtensionFilter filter = new FileExtensionFilter(fileExtensions);
                List sourceFilesInDirectory = FileUtil.listFiles((File)sourceFile, (FileFilter)filter);
                for (File f : sourceFilesInDirectory) {
                    String ext = FilenameUtils.getExtension((String)f.getName());
                    List filesForExtension = (List)byExtension.get(ext);
                    if (filesForExtension == null) continue;
                    filesForExtension.add(f.getAbsolutePath());
                }
                continue;
            }
            String ext = FilenameUtils.getExtension((String)sourceFile.getName());
            List filesForExtension = (List)byExtension.get(ext);
            if (filesForExtension == null) continue;
            filesForExtension.add(sourceFile.getAbsolutePath());
        }
        ArrayList<ParseResult> results = new ArrayList<ParseResult>();
        for (Map.Entry entry : byExtension.entrySet()) {
            String ext = (String)entry.getKey();
            List files = (List)entry.getValue();
            ParseResult parseResult = this._parserByFileExtension.get(ext).parseSources(files.toArray(new String[files.size()]));
            results.add(parseResult);
        }
        return DataSchemaParser.combine(results);
    }

    private static ParseResult combine(Collection<ParseResult> parseResults) {
        ParseResult combined = new ParseResult();
        for (ParseResult result : parseResults) {
            combined.getSchemaAndLocations().putAll(result.getSchemaAndLocations());
            combined.getSourceFiles().addAll(result.getSourceFiles());
            combined.addMessage(result.getMessage());
        }
        return combined;
    }

    public static class ParseResult {
        private final Map<DataSchema, DataSchemaLocation> _schemaAndLocations = new HashMap<DataSchema, DataSchemaLocation>();
        private final Set<File> _sourceFiles = new HashSet<File>();
        protected final StringBuilder _messageBuilder = new StringBuilder();

        public Map<DataSchema, DataSchemaLocation> getSchemaAndLocations() {
            return this._schemaAndLocations;
        }

        public Set<File> getSourceFiles() {
            return this._sourceFiles;
        }

        public String getMessage() {
            return this._messageBuilder.toString();
        }

        public ParseResult addMessage(String message) {
            this._messageBuilder.append(message);
            return this;
        }
    }

    private static class FileExtensionFilter
    implements FileFilter {
        private final Set<String> extensions;

        public FileExtensionFilter(Set<String> extensions) {
            this.extensions = extensions;
        }

        @Override
        public boolean accept(File file) {
            return this.extensions.contains(FilenameUtils.getExtension((String)file.getName()));
        }
    }
}

