/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq.trace;

import com.linkedin.parseq.trace.ShallowTrace;
import com.linkedin.parseq.trace.TraceRelationship;
import com.linkedin.parseq.trace.TraceUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class Trace {
    private final Map<Long, ShallowTrace> _traceMap;
    private final Set<TraceRelationship> _relationships;
    private final Long _planId;
    private final String _planClass;

    public Trace(Map<Long, ShallowTrace> traceMap, Set<TraceRelationship> relationships) {
        this(traceMap, relationships, "unknown", -1L);
    }

    public Trace(Map<Long, ShallowTrace> traceMap, Set<TraceRelationship> relationships, String planClass, Long planId) {
        this._traceMap = Collections.unmodifiableMap(traceMap);
        this._relationships = Collections.unmodifiableSet(relationships);
        this._planClass = planClass;
        this._planId = planId;
    }

    public Map<Long, ShallowTrace> getTraceMap() {
        return this._traceMap;
    }

    public Set<TraceRelationship> getRelationships() {
        return this._relationships;
    }

    public static Trace single(ShallowTrace shallowTrace) {
        return Trace.single(shallowTrace, "unknown", -1L);
    }

    public static Trace single(ShallowTrace shallowTrace, String planClass, Long planId) {
        return new Trace(Collections.singletonMap(shallowTrace.getId(), shallowTrace), Collections.emptySet(), planClass, planId);
    }

    public Long getPlanId() {
        return this._planId;
    }

    public String getPlanClass() {
        return this._planClass;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._relationships == null ? 0 : this._relationships.hashCode());
        result = 31 * result + (this._traceMap == null ? 0 : this._traceMap.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Trace other = (Trace)obj;
        if (this._relationships == null ? other._relationships != null : !this._relationships.equals(other._relationships)) {
            return false;
        }
        return !(this._traceMap == null ? other._traceMap != null : !this._traceMap.equals(other._traceMap));
    }

    public String toString() {
        try {
            return TraceUtil.getJsonTrace(this);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not serialize trace to JSON", e);
        }
    }
}

