/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq.promise;

import com.linkedin.parseq.internal.Continuations;
import com.linkedin.parseq.promise.PromiseException;
import com.linkedin.parseq.promise.PromiseListener;
import com.linkedin.parseq.promise.PromiseResolvedException;
import com.linkedin.parseq.promise.PromiseUnresolvedException;
import com.linkedin.parseq.promise.SettablePromise;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SettablePromiseImpl<T>
implements SettablePromise<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SettablePromiseImpl.class);
    private static final Continuations CONTINUATIONS = new Continuations();
    private final Object _lock = new Object();
    private final List<PromiseListener<T>> _listeners = new ArrayList<PromiseListener<T>>();
    private final CountDownLatch _valueLatch = new CountDownLatch(1);
    private final CountDownLatch _awaitLatch = new CountDownLatch(1);
    private volatile T _value;
    private volatile Throwable _error;

    SettablePromiseImpl() {
    }

    @Override
    public void done(T value) throws PromiseResolvedException {
        this.doFinish(value, null);
    }

    @Override
    public void fail(Throwable error) throws PromiseResolvedException {
        this.doFinish(null, error);
    }

    @Override
    public T get() throws PromiseException {
        this.ensureDone();
        if (this._error != null) {
            throw new PromiseException(this._error);
        }
        return this._value;
    }

    @Override
    public Throwable getError() throws PromiseUnresolvedException {
        this.ensureDone();
        return this._error;
    }

    @Override
    public T getOrDefault(T defaultValue) throws PromiseUnresolvedException {
        this.ensureDone();
        if (this._error != null) {
            return defaultValue;
        }
        return this._value;
    }

    @Override
    public void await() throws InterruptedException {
        this._awaitLatch.await();
    }

    @Override
    public boolean await(long time, TimeUnit unit) throws InterruptedException {
        return this._awaitLatch.await(time, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(PromiseListener<T> listener) {
        Object object = this._lock;
        synchronized (object) {
            if (!this.isDone()) {
                this._listeners.add(listener);
                return;
            }
        }
        this.notifyListener(listener);
    }

    @Override
    public boolean isDone() {
        return this._valueLatch.getCount() == 0L;
    }

    @Override
    public boolean isFailed() {
        return this.isDone() && this._error != null;
    }

    private void doFinish(T value, Throwable error) throws PromiseResolvedException {
        List<PromiseListener<T>> listeners = this.finalizeResult(value, error);
        CONTINUATIONS.submit(() -> this.notifyListeners(listeners));
        CONTINUATIONS.submit(this._awaitLatch::countDown);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PromiseListener<T>> finalizeResult(T value, Throwable error) {
        ArrayList<PromiseListener<T>> listeners;
        Object object = this._lock;
        synchronized (object) {
            this.ensureNotDone();
            this._value = value;
            this._error = error;
            this._valueLatch.countDown();
            listeners = new ArrayList<PromiseListener<T>>(this._listeners);
            this._listeners.clear();
        }
        return listeners;
    }

    private void notifyListeners(List<PromiseListener<T>> listeners) {
        for (int i = listeners.size() - 1; i >= 0; --i) {
            this.notifyListener(listeners.get(i));
        }
    }

    private void notifyListener(PromiseListener<T> listener) {
        try {
            listener.onResolved(this);
        }
        catch (Throwable e) {
            LOGGER.error("An exception was thrown by listener", e);
        }
    }

    private void ensureNotDone() throws PromiseResolvedException {
        if (this.isDone()) {
            throw new PromiseResolvedException("Promise has already been satisfied");
        }
    }

    private void ensureDone() throws PromiseUnresolvedException {
        if (!this.isDone()) {
            throw new PromiseUnresolvedException("Promise has not yet been satisfied");
        }
    }
}

